// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.exception.ManagementError;
import com.azure.resourcemanager.costmanagement.models.ExecutionStatus;
import com.azure.resourcemanager.costmanagement.models.ExecutionType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** The properties of the export run. */
@Fluent
public final class ExportRunPropertiesInner {
    /*
     * The type of the export run.
     */
    @JsonProperty(value = "executionType")
    private ExecutionType executionType;

    /*
     * The last known status of the export run.
     */
    @JsonProperty(value = "status")
    private ExecutionStatus status;

    /*
     * The identifier for the entity that triggered the export. For on-demand runs it is the user email. For scheduled
     * runs it is 'System'.
     */
    @JsonProperty(value = "submittedBy")
    private String submittedBy;

    /*
     * The time when export was queued to be run.
     */
    @JsonProperty(value = "submittedTime")
    private OffsetDateTime submittedTime;

    /*
     * The time when export was picked up to be run.
     */
    @JsonProperty(value = "processingStartTime")
    private OffsetDateTime processingStartTime;

    /*
     * The time when the export run finished.
     */
    @JsonProperty(value = "processingEndTime")
    private OffsetDateTime processingEndTime;

    /*
     * The name of the exported file.
     */
    @JsonProperty(value = "fileName")
    private String fileName;

    /*
     * The export settings that were in effect for this run.
     */
    @JsonProperty(value = "runSettings")
    private CommonExportPropertiesInner runSettings;

    /*
     * The details of any error.
     */
    @JsonProperty(value = "error")
    private ManagementError error;

    /** Creates an instance of ExportRunPropertiesInner class. */
    public ExportRunPropertiesInner() {
    }

    /**
     * Get the executionType property: The type of the export run.
     *
     * @return the executionType value.
     */
    public ExecutionType executionType() {
        return this.executionType;
    }

    /**
     * Set the executionType property: The type of the export run.
     *
     * @param executionType the executionType value to set.
     * @return the ExportRunPropertiesInner object itself.
     */
    public ExportRunPropertiesInner withExecutionType(ExecutionType executionType) {
        this.executionType = executionType;
        return this;
    }

    /**
     * Get the status property: The last known status of the export run.
     *
     * @return the status value.
     */
    public ExecutionStatus status() {
        return this.status;
    }

    /**
     * Set the status property: The last known status of the export run.
     *
     * @param status the status value to set.
     * @return the ExportRunPropertiesInner object itself.
     */
    public ExportRunPropertiesInner withStatus(ExecutionStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the submittedBy property: The identifier for the entity that triggered the export. For on-demand runs it is
     * the user email. For scheduled runs it is 'System'.
     *
     * @return the submittedBy value.
     */
    public String submittedBy() {
        return this.submittedBy;
    }

    /**
     * Set the submittedBy property: The identifier for the entity that triggered the export. For on-demand runs it is
     * the user email. For scheduled runs it is 'System'.
     *
     * @param submittedBy the submittedBy value to set.
     * @return the ExportRunPropertiesInner object itself.
     */
    public ExportRunPropertiesInner withSubmittedBy(String submittedBy) {
        this.submittedBy = submittedBy;
        return this;
    }

    /**
     * Get the submittedTime property: The time when export was queued to be run.
     *
     * @return the submittedTime value.
     */
    public OffsetDateTime submittedTime() {
        return this.submittedTime;
    }

    /**
     * Set the submittedTime property: The time when export was queued to be run.
     *
     * @param submittedTime the submittedTime value to set.
     * @return the ExportRunPropertiesInner object itself.
     */
    public ExportRunPropertiesInner withSubmittedTime(OffsetDateTime submittedTime) {
        this.submittedTime = submittedTime;
        return this;
    }

    /**
     * Get the processingStartTime property: The time when export was picked up to be run.
     *
     * @return the processingStartTime value.
     */
    public OffsetDateTime processingStartTime() {
        return this.processingStartTime;
    }

    /**
     * Set the processingStartTime property: The time when export was picked up to be run.
     *
     * @param processingStartTime the processingStartTime value to set.
     * @return the ExportRunPropertiesInner object itself.
     */
    public ExportRunPropertiesInner withProcessingStartTime(OffsetDateTime processingStartTime) {
        this.processingStartTime = processingStartTime;
        return this;
    }

    /**
     * Get the processingEndTime property: The time when the export run finished.
     *
     * @return the processingEndTime value.
     */
    public OffsetDateTime processingEndTime() {
        return this.processingEndTime;
    }

    /**
     * Set the processingEndTime property: The time when the export run finished.
     *
     * @param processingEndTime the processingEndTime value to set.
     * @return the ExportRunPropertiesInner object itself.
     */
    public ExportRunPropertiesInner withProcessingEndTime(OffsetDateTime processingEndTime) {
        this.processingEndTime = processingEndTime;
        return this;
    }

    /**
     * Get the fileName property: The name of the exported file.
     *
     * @return the fileName value.
     */
    public String fileName() {
        return this.fileName;
    }

    /**
     * Set the fileName property: The name of the exported file.
     *
     * @param fileName the fileName value to set.
     * @return the ExportRunPropertiesInner object itself.
     */
    public ExportRunPropertiesInner withFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    /**
     * Get the runSettings property: The export settings that were in effect for this run.
     *
     * @return the runSettings value.
     */
    public CommonExportPropertiesInner runSettings() {
        return this.runSettings;
    }

    /**
     * Set the runSettings property: The export settings that were in effect for this run.
     *
     * @param runSettings the runSettings value to set.
     * @return the ExportRunPropertiesInner object itself.
     */
    public ExportRunPropertiesInner withRunSettings(CommonExportPropertiesInner runSettings) {
        this.runSettings = runSettings;
        return this;
    }

    /**
     * Get the error property: The details of any error.
     *
     * @return the error value.
     */
    public ManagementError error() {
        return this.error;
    }

    /**
     * Set the error property: The details of any error.
     *
     * @param error the error value to set.
     * @return the ExportRunPropertiesInner object itself.
     */
    public ExportRunPropertiesInner withError(ManagementError error) {
        this.error = error;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (runSettings() != null) {
            runSettings().validate();
        }
    }
}
