// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** The result of the long running operation for cost detailed report. */
@Fluent
public final class GenerateDetailedCostReportOperationResultInner {
    /*
     * The ARM resource id of the long running operation.
     */
    @JsonProperty(value = "id")
    private String id;

    /*
     * The name of the long running operation.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * The type of the long running operation.
     */
    @JsonProperty(value = "type")
    private String type;

    /*
     * The properties of the resource generated.
     */
    @JsonProperty(value = "properties")
    private DownloadUrlInner innerProperties;

    /** Creates an instance of GenerateDetailedCostReportOperationResultInner class. */
    public GenerateDetailedCostReportOperationResultInner() {
    }

    /**
     * Get the id property: The ARM resource id of the long running operation.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The ARM resource id of the long running operation.
     *
     * @param id the id value to set.
     * @return the GenerateDetailedCostReportOperationResultInner object itself.
     */
    public GenerateDetailedCostReportOperationResultInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name property: The name of the long running operation.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the long running operation.
     *
     * @param name the name value to set.
     * @return the GenerateDetailedCostReportOperationResultInner object itself.
     */
    public GenerateDetailedCostReportOperationResultInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: The type of the long running operation.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: The type of the long running operation.
     *
     * @param type the type value to set.
     * @return the GenerateDetailedCostReportOperationResultInner object itself.
     */
    public GenerateDetailedCostReportOperationResultInner withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the innerProperties property: The properties of the resource generated.
     *
     * @return the innerProperties value.
     */
    private DownloadUrlInner innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the expiryTime property: The time at which report URL becomes invalid/expires in UTC e.g.
     * 2020-12-08T05:55:59.4394737Z.
     *
     * @return the expiryTime value.
     */
    public OffsetDateTime expiryTime() {
        return this.innerProperties() == null ? null : this.innerProperties().expiryTime();
    }

    /**
     * Get the validTill property: The time at which report URL becomes invalid/expires in UTC e.g.
     * 2020-12-08T05:55:59.4394737Z.
     *
     * @return the validTill value.
     */
    public OffsetDateTime validTill() {
        return this.innerProperties() == null ? null : this.innerProperties().validTill();
    }

    /**
     * Set the validTill property: The time at which report URL becomes invalid/expires in UTC e.g.
     * 2020-12-08T05:55:59.4394737Z.
     *
     * @param validTill the validTill value to set.
     * @return the GenerateDetailedCostReportOperationResultInner object itself.
     */
    public GenerateDetailedCostReportOperationResultInner withValidTill(OffsetDateTime validTill) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DownloadUrlInner();
        }
        this.innerProperties().withValidTill(validTill);
        return this;
    }

    /**
     * Get the downloadUrl property: The URL to download the generated report.
     *
     * @return the downloadUrl value.
     */
    public String downloadUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().downloadUrl();
    }

    /**
     * Set the downloadUrl property: The URL to download the generated report.
     *
     * @param downloadUrl the downloadUrl value to set.
     * @return the GenerateDetailedCostReportOperationResultInner object itself.
     */
    public GenerateDetailedCostReportOperationResultInner withDownloadUrl(String downloadUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DownloadUrlInner();
        }
        this.innerProperties().withDownloadUrl(downloadUrl);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
