// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.costmanagement.models.BenefitKind;
import com.azure.resourcemanager.costmanagement.models.BenefitUtilizationSummaryProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;

/** Included Quantity utilization summary properties. */
@Fluent
public final class IncludedQuantityUtilizationSummaryProperties extends BenefitUtilizationSummaryProperties {
    /*
     * This is the utilized percentage for the benefit ID.
     */
    @JsonProperty(value = "utilizationPercentage", access = JsonProperty.Access.WRITE_ONLY)
    private BigDecimal utilizationPercentage;

    /** Creates an instance of IncludedQuantityUtilizationSummaryProperties class. */
    public IncludedQuantityUtilizationSummaryProperties() {
    }

    /**
     * Get the utilizationPercentage property: This is the utilized percentage for the benefit ID.
     *
     * @return the utilizationPercentage value.
     */
    public BigDecimal utilizationPercentage() {
        return this.utilizationPercentage;
    }

    /** {@inheritDoc} */
    @Override
    public IncludedQuantityUtilizationSummaryProperties withBenefitType(BenefitKind benefitType) {
        super.withBenefitType(benefitType);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
