// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.costmanagement.models.FileDestination;
import com.azure.resourcemanager.costmanagement.models.NotificationProperties;
import com.azure.resourcemanager.costmanagement.models.ScheduleProperties;
import com.azure.resourcemanager.costmanagement.models.ScheduledActionKind;
import com.azure.resourcemanager.costmanagement.models.ScheduledActionProxyResource;
import com.azure.resourcemanager.costmanagement.models.ScheduledActionStatus;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Scheduled action definition. */
@Fluent
public final class ScheduledActionInner extends ScheduledActionProxyResource {
    /*
     * The properties of the scheduled action.
     */
    @JsonProperty(value = "properties")
    private ScheduledActionProperties innerProperties;

    /** Creates an instance of ScheduledActionInner class. */
    public ScheduledActionInner() {
    }

    /**
     * Get the innerProperties property: The properties of the scheduled action.
     *
     * @return the innerProperties value.
     */
    private ScheduledActionProperties innerProperties() {
        return this.innerProperties;
    }

    /** {@inheritDoc} */
    @Override
    public ScheduledActionInner withKind(ScheduledActionKind kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the displayName property: Scheduled action name.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    /**
     * Set the displayName property: Scheduled action name.
     *
     * @param displayName the displayName value to set.
     * @return the ScheduledActionInner object itself.
     */
    public ScheduledActionInner withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledActionProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    /**
     * Get the fileDestination property: Destination format of the view data. This is optional.
     *
     * @return the fileDestination value.
     */
    public FileDestination fileDestination() {
        return this.innerProperties() == null ? null : this.innerProperties().fileDestination();
    }

    /**
     * Set the fileDestination property: Destination format of the view data. This is optional.
     *
     * @param fileDestination the fileDestination value to set.
     * @return the ScheduledActionInner object itself.
     */
    public ScheduledActionInner withFileDestination(FileDestination fileDestination) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledActionProperties();
        }
        this.innerProperties().withFileDestination(fileDestination);
        return this;
    }

    /**
     * Get the notification property: Notification properties based on scheduled action kind.
     *
     * @return the notification value.
     */
    public NotificationProperties notification() {
        return this.innerProperties() == null ? null : this.innerProperties().notification();
    }

    /**
     * Set the notification property: Notification properties based on scheduled action kind.
     *
     * @param notification the notification value to set.
     * @return the ScheduledActionInner object itself.
     */
    public ScheduledActionInner withNotification(NotificationProperties notification) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledActionProperties();
        }
        this.innerProperties().withNotification(notification);
        return this;
    }

    /**
     * Get the notificationEmail property: Email address of the point of contact that should get the unsubscribe
     * requests and notification emails.
     *
     * @return the notificationEmail value.
     */
    public String notificationEmail() {
        return this.innerProperties() == null ? null : this.innerProperties().notificationEmail();
    }

    /**
     * Set the notificationEmail property: Email address of the point of contact that should get the unsubscribe
     * requests and notification emails.
     *
     * @param notificationEmail the notificationEmail value to set.
     * @return the ScheduledActionInner object itself.
     */
    public ScheduledActionInner withNotificationEmail(String notificationEmail) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledActionProperties();
        }
        this.innerProperties().withNotificationEmail(notificationEmail);
        return this;
    }

    /**
     * Get the schedule property: Schedule of the scheduled action.
     *
     * @return the schedule value.
     */
    public ScheduleProperties schedule() {
        return this.innerProperties() == null ? null : this.innerProperties().schedule();
    }

    /**
     * Set the schedule property: Schedule of the scheduled action.
     *
     * @param schedule the schedule value to set.
     * @return the ScheduledActionInner object itself.
     */
    public ScheduledActionInner withSchedule(ScheduleProperties schedule) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledActionProperties();
        }
        this.innerProperties().withSchedule(schedule);
        return this;
    }

    /**
     * Get the scope property: Cost Management scope like 'subscriptions/{subscriptionId}' for subscription scope,
     * 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope,
     * 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
     * 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope,
     * 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for
     * EnrollmentAccount scope,
     * 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for
     * BillingProfile scope,
     * 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for
     * InvoiceSection scope, '/providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}'
     * for ExternalBillingAccount scope, and
     * '/providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for ExternalSubscription
     * scope.
     *
     * @return the scope value.
     */
    public String scope() {
        return this.innerProperties() == null ? null : this.innerProperties().scope();
    }

    /**
     * Set the scope property: Cost Management scope like 'subscriptions/{subscriptionId}' for subscription scope,
     * 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope,
     * 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
     * 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope,
     * 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for
     * EnrollmentAccount scope,
     * 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for
     * BillingProfile scope,
     * 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for
     * InvoiceSection scope, '/providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}'
     * for ExternalBillingAccount scope, and
     * '/providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for ExternalSubscription
     * scope.
     *
     * @param scope the scope value to set.
     * @return the ScheduledActionInner object itself.
     */
    public ScheduledActionInner withScope(String scope) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledActionProperties();
        }
        this.innerProperties().withScope(scope);
        return this;
    }

    /**
     * Get the status property: Status of the scheduled action.
     *
     * @return the status value.
     */
    public ScheduledActionStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Set the status property: Status of the scheduled action.
     *
     * @param status the status value to set.
     * @return the ScheduledActionInner object itself.
     */
    public ScheduledActionInner withStatus(ScheduledActionStatus status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledActionProperties();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    /**
     * Get the viewId property: Cost analysis viewId used for scheduled action. For example,
     * '/providers/Microsoft.CostManagement/views/swaggerExample'.
     *
     * @return the viewId value.
     */
    public String viewId() {
        return this.innerProperties() == null ? null : this.innerProperties().viewId();
    }

    /**
     * Set the viewId property: Cost analysis viewId used for scheduled action. For example,
     * '/providers/Microsoft.CostManagement/views/swaggerExample'.
     *
     * @param viewId the viewId value to set.
     * @return the ScheduledActionInner object itself.
     */
    public ScheduledActionInner withViewId(String viewId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledActionProperties();
        }
        this.innerProperties().withViewId(viewId);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
