// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.management.exception.ManagementError;
import com.azure.resourcemanager.costmanagement.fluent.models.CostDetailsOperationResultsInner;
import com.azure.resourcemanager.costmanagement.models.BlobInfo;
import com.azure.resourcemanager.costmanagement.models.CostDetailsDataFormat;
import com.azure.resourcemanager.costmanagement.models.CostDetailsOperationResults;
import com.azure.resourcemanager.costmanagement.models.CostDetailsStatusType;
import com.azure.resourcemanager.costmanagement.models.GenerateCostDetailsReportRequestDefinition;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;

public final class CostDetailsOperationResultsImpl implements CostDetailsOperationResults {
    private CostDetailsOperationResultsInner innerObject;

    private final com.azure.resourcemanager.costmanagement.CostManagementManager serviceManager;

    CostDetailsOperationResultsImpl(
        CostDetailsOperationResultsInner innerObject,
        com.azure.resourcemanager.costmanagement.CostManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public CostDetailsStatusType status() {
        return this.innerModel().status();
    }

    public OffsetDateTime validTill() {
        return this.innerModel().validTill();
    }

    public ManagementError error() {
        return this.innerModel().error();
    }

    public String manifestVersion() {
        return this.innerModel().manifestVersion();
    }

    public CostDetailsDataFormat dataFormat() {
        return this.innerModel().dataFormat();
    }

    public Long byteCount() {
        return this.innerModel().byteCount();
    }

    public Integer blobCount() {
        return this.innerModel().blobCount();
    }

    public Boolean compressData() {
        return this.innerModel().compressData();
    }

    public List<BlobInfo> blobs() {
        List<BlobInfo> inner = this.innerModel().blobs();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public String requestScope() {
        return this.innerModel().requestScope();
    }

    public GenerateCostDetailsReportRequestDefinition requestBody() {
        return this.innerModel().requestBody();
    }

    public CostDetailsOperationResultsInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.costmanagement.CostManagementManager manager() {
        return this.serviceManager;
    }
}
