// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.management.polling.PollerFactory;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.costmanagement.fluent.AlertsClient;
import com.azure.resourcemanager.costmanagement.fluent.BenefitRecommendationsClient;
import com.azure.resourcemanager.costmanagement.fluent.BenefitUtilizationSummariesClient;
import com.azure.resourcemanager.costmanagement.fluent.CostManagementClient;
import com.azure.resourcemanager.costmanagement.fluent.DimensionsClient;
import com.azure.resourcemanager.costmanagement.fluent.ExportsClient;
import com.azure.resourcemanager.costmanagement.fluent.ForecastsClient;
import com.azure.resourcemanager.costmanagement.fluent.GenerateCostDetailsReportsClient;
import com.azure.resourcemanager.costmanagement.fluent.GenerateDetailedCostReportOperationResultsClient;
import com.azure.resourcemanager.costmanagement.fluent.GenerateDetailedCostReportOperationStatusClient;
import com.azure.resourcemanager.costmanagement.fluent.GenerateDetailedCostReportsClient;
import com.azure.resourcemanager.costmanagement.fluent.GenerateReservationDetailsReportsClient;
import com.azure.resourcemanager.costmanagement.fluent.OperationsClient;
import com.azure.resourcemanager.costmanagement.fluent.PriceSheetsClient;
import com.azure.resourcemanager.costmanagement.fluent.QueriesClient;
import com.azure.resourcemanager.costmanagement.fluent.ScheduledActionsClient;
import com.azure.resourcemanager.costmanagement.fluent.ViewsClient;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** Initializes a new instance of the CostManagementClientImpl type. */
@ServiceClient(builder = CostManagementClientBuilder.class)
public final class CostManagementClientImpl implements CostManagementClient {
    /** server parameter. */
    private final String endpoint;

    /**
     * Gets server parameter.
     *
     * @return the endpoint value.
     */
    public String getEndpoint() {
        return this.endpoint;
    }

    /** Api Version. */
    private final String apiVersion;

    /**
     * Gets Api Version.
     *
     * @return the apiVersion value.
     */
    public String getApiVersion() {
        return this.apiVersion;
    }

    /** The HTTP pipeline to send requests through. */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     *
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /** The serializer to serialize an object into a string. */
    private final SerializerAdapter serializerAdapter;

    /**
     * Gets The serializer to serialize an object into a string.
     *
     * @return the serializerAdapter value.
     */
    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    /** The default poll interval for long-running operation. */
    private final Duration defaultPollInterval;

    /**
     * Gets The default poll interval for long-running operation.
     *
     * @return the defaultPollInterval value.
     */
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    /** The OperationsClient object to access its operations. */
    private final OperationsClient operations;

    /**
     * Gets the OperationsClient object to access its operations.
     *
     * @return the OperationsClient object.
     */
    public OperationsClient getOperations() {
        return this.operations;
    }

    /** The ViewsClient object to access its operations. */
    private final ViewsClient views;

    /**
     * Gets the ViewsClient object to access its operations.
     *
     * @return the ViewsClient object.
     */
    public ViewsClient getViews() {
        return this.views;
    }

    /** The AlertsClient object to access its operations. */
    private final AlertsClient alerts;

    /**
     * Gets the AlertsClient object to access its operations.
     *
     * @return the AlertsClient object.
     */
    public AlertsClient getAlerts() {
        return this.alerts;
    }

    /** The ForecastsClient object to access its operations. */
    private final ForecastsClient forecasts;

    /**
     * Gets the ForecastsClient object to access its operations.
     *
     * @return the ForecastsClient object.
     */
    public ForecastsClient getForecasts() {
        return this.forecasts;
    }

    /** The DimensionsClient object to access its operations. */
    private final DimensionsClient dimensions;

    /**
     * Gets the DimensionsClient object to access its operations.
     *
     * @return the DimensionsClient object.
     */
    public DimensionsClient getDimensions() {
        return this.dimensions;
    }

    /** The QueriesClient object to access its operations. */
    private final QueriesClient queries;

    /**
     * Gets the QueriesClient object to access its operations.
     *
     * @return the QueriesClient object.
     */
    public QueriesClient getQueries() {
        return this.queries;
    }

    /** The GenerateReservationDetailsReportsClient object to access its operations. */
    private final GenerateReservationDetailsReportsClient generateReservationDetailsReports;

    /**
     * Gets the GenerateReservationDetailsReportsClient object to access its operations.
     *
     * @return the GenerateReservationDetailsReportsClient object.
     */
    public GenerateReservationDetailsReportsClient getGenerateReservationDetailsReports() {
        return this.generateReservationDetailsReports;
    }

    /** The ExportsClient object to access its operations. */
    private final ExportsClient exports;

    /**
     * Gets the ExportsClient object to access its operations.
     *
     * @return the ExportsClient object.
     */
    public ExportsClient getExports() {
        return this.exports;
    }

    /** The GenerateCostDetailsReportsClient object to access its operations. */
    private final GenerateCostDetailsReportsClient generateCostDetailsReports;

    /**
     * Gets the GenerateCostDetailsReportsClient object to access its operations.
     *
     * @return the GenerateCostDetailsReportsClient object.
     */
    public GenerateCostDetailsReportsClient getGenerateCostDetailsReports() {
        return this.generateCostDetailsReports;
    }

    /** The GenerateDetailedCostReportsClient object to access its operations. */
    private final GenerateDetailedCostReportsClient generateDetailedCostReports;

    /**
     * Gets the GenerateDetailedCostReportsClient object to access its operations.
     *
     * @return the GenerateDetailedCostReportsClient object.
     */
    public GenerateDetailedCostReportsClient getGenerateDetailedCostReports() {
        return this.generateDetailedCostReports;
    }

    /** The GenerateDetailedCostReportOperationResultsClient object to access its operations. */
    private final GenerateDetailedCostReportOperationResultsClient generateDetailedCostReportOperationResults;

    /**
     * Gets the GenerateDetailedCostReportOperationResultsClient object to access its operations.
     *
     * @return the GenerateDetailedCostReportOperationResultsClient object.
     */
    public GenerateDetailedCostReportOperationResultsClient getGenerateDetailedCostReportOperationResults() {
        return this.generateDetailedCostReportOperationResults;
    }

    /** The GenerateDetailedCostReportOperationStatusClient object to access its operations. */
    private final GenerateDetailedCostReportOperationStatusClient generateDetailedCostReportOperationStatus;

    /**
     * Gets the GenerateDetailedCostReportOperationStatusClient object to access its operations.
     *
     * @return the GenerateDetailedCostReportOperationStatusClient object.
     */
    public GenerateDetailedCostReportOperationStatusClient getGenerateDetailedCostReportOperationStatus() {
        return this.generateDetailedCostReportOperationStatus;
    }

    /** The PriceSheetsClient object to access its operations. */
    private final PriceSheetsClient priceSheets;

    /**
     * Gets the PriceSheetsClient object to access its operations.
     *
     * @return the PriceSheetsClient object.
     */
    public PriceSheetsClient getPriceSheets() {
        return this.priceSheets;
    }

    /** The ScheduledActionsClient object to access its operations. */
    private final ScheduledActionsClient scheduledActions;

    /**
     * Gets the ScheduledActionsClient object to access its operations.
     *
     * @return the ScheduledActionsClient object.
     */
    public ScheduledActionsClient getScheduledActions() {
        return this.scheduledActions;
    }

    /** The BenefitRecommendationsClient object to access its operations. */
    private final BenefitRecommendationsClient benefitRecommendations;

    /**
     * Gets the BenefitRecommendationsClient object to access its operations.
     *
     * @return the BenefitRecommendationsClient object.
     */
    public BenefitRecommendationsClient getBenefitRecommendations() {
        return this.benefitRecommendations;
    }

    /** The BenefitUtilizationSummariesClient object to access its operations. */
    private final BenefitUtilizationSummariesClient benefitUtilizationSummaries;

    /**
     * Gets the BenefitUtilizationSummariesClient object to access its operations.
     *
     * @return the BenefitUtilizationSummariesClient object.
     */
    public BenefitUtilizationSummariesClient getBenefitUtilizationSummaries() {
        return this.benefitUtilizationSummaries;
    }

    /**
     * Initializes an instance of CostManagementClient client.
     *
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param serializerAdapter The serializer to serialize an object into a string.
     * @param defaultPollInterval The default poll interval for long-running operation.
     * @param environment The Azure environment.
     * @param endpoint server parameter.
     */
    CostManagementClientImpl(
        HttpPipeline httpPipeline,
        SerializerAdapter serializerAdapter,
        Duration defaultPollInterval,
        AzureEnvironment environment,
        String endpoint) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.endpoint = endpoint;
        this.apiVersion = "2022-10-01";
        this.operations = new OperationsClientImpl(this);
        this.views = new ViewsClientImpl(this);
        this.alerts = new AlertsClientImpl(this);
        this.forecasts = new ForecastsClientImpl(this);
        this.dimensions = new DimensionsClientImpl(this);
        this.queries = new QueriesClientImpl(this);
        this.generateReservationDetailsReports = new GenerateReservationDetailsReportsClientImpl(this);
        this.exports = new ExportsClientImpl(this);
        this.generateCostDetailsReports = new GenerateCostDetailsReportsClientImpl(this);
        this.generateDetailedCostReports = new GenerateDetailedCostReportsClientImpl(this);
        this.generateDetailedCostReportOperationResults =
            new GenerateDetailedCostReportOperationResultsClientImpl(this);
        this.generateDetailedCostReportOperationStatus = new GenerateDetailedCostReportOperationStatusClientImpl(this);
        this.priceSheets = new PriceSheetsClientImpl(this);
        this.scheduledActions = new ScheduledActionsClientImpl(this);
        this.benefitRecommendations = new BenefitRecommendationsClientImpl(this);
        this.benefitUtilizationSummaries = new BenefitUtilizationSummariesClientImpl(this);
    }

    /**
     * Gets default client context.
     *
     * @return the default client context.
     */
    public Context getContext() {
        return Context.NONE;
    }

    /**
     * Merges default client context with provided context.
     *
     * @param context the context to be merged with default client context.
     * @return the merged context.
     */
    public Context mergeContext(Context context) {
        return CoreUtils.mergeContexts(this.getContext(), context);
    }

    /**
     * Gets long running operation result.
     *
     * @param activationResponse the response of activation operation.
     * @param httpPipeline the http pipeline.
     * @param pollResultType type of poll result.
     * @param finalResultType type of final result.
     * @param context the context shared by all requests.
     * @param <T> type of poll result.
     * @param <U> type of final result.
     * @return poller flux for poll result and final result.
     */
    public <T, U> PollerFlux<PollResult<T>, U> getLroResult(
        Mono<Response<Flux<ByteBuffer>>> activationResponse,
        HttpPipeline httpPipeline,
        Type pollResultType,
        Type finalResultType,
        Context context) {
        return PollerFactory
            .create(
                serializerAdapter,
                httpPipeline,
                pollResultType,
                finalResultType,
                defaultPollInterval,
                activationResponse,
                context);
    }

    /**
     * Gets the final result, or an error, based on last async poll response.
     *
     * @param response the last async poll response.
     * @param <T> type of poll result.
     * @param <U> type of final result.
     * @return the final result, or an error.
     */
    public <T, U> Mono<U> getLroFinalResultOrError(AsyncPollResponse<PollResult<T>, U> response) {
        if (response.getStatus() != LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
            String errorMessage;
            ManagementError managementError = null;
            HttpResponse errorResponse = null;
            PollResult.Error lroError = response.getValue().getError();
            if (lroError != null) {
                errorResponse =
                    new HttpResponseImpl(
                        lroError.getResponseStatusCode(), lroError.getResponseHeaders(), lroError.getResponseBody());

                errorMessage = response.getValue().getError().getMessage();
                String errorBody = response.getValue().getError().getResponseBody();
                if (errorBody != null) {
                    // try to deserialize error body to ManagementError
                    try {
                        managementError =
                            this
                                .getSerializerAdapter()
                                .deserialize(errorBody, ManagementError.class, SerializerEncoding.JSON);
                        if (managementError.getCode() == null || managementError.getMessage() == null) {
                            managementError = null;
                        }
                    } catch (IOException | RuntimeException ioe) {
                        LOGGER.logThrowableAsWarning(ioe);
                    }
                }
            } else {
                // fallback to default error message
                errorMessage = "Long running operation failed.";
            }
            if (managementError == null) {
                // fallback to default ManagementError
                managementError = new ManagementError(response.getStatus().toString(), errorMessage);
            }
            return Mono.error(new ManagementException(errorMessage, errorResponse, managementError));
        } else {
            return response.getFinalResult();
        }
    }

    private static final class HttpResponseImpl extends HttpResponse {
        private final int statusCode;

        private final byte[] responseBody;

        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        public int getStatusCode() {
            return statusCode;
        }

        public String getHeaderValue(String s) {
            return httpHeaders.getValue(s);
        }

        public HttpHeaders getHeaders() {
            return httpHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just(ByteBuffer.wrap(responseBody));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just(responseBody);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just(new String(responseBody, StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just(new String(responseBody, charset));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CostManagementClientImpl.class);
}
