// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.costmanagement.fluent.DimensionsClient;
import com.azure.resourcemanager.costmanagement.fluent.models.DimensionInner;
import com.azure.resourcemanager.costmanagement.models.DimensionsListResult;
import com.azure.resourcemanager.costmanagement.models.ExternalCloudProviderType;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in DimensionsClient. */
public final class DimensionsClientImpl implements DimensionsClient {
    /** The proxy service used to perform REST calls. */
    private final DimensionsService service;

    /** The service client containing this operation class. */
    private final CostManagementClientImpl client;

    /**
     * Initializes an instance of DimensionsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    DimensionsClientImpl(CostManagementClientImpl client) {
        this.service =
            RestProxy.create(DimensionsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for CostManagementClientDimensions to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "CostManagementClient")
    public interface DimensionsService {
        @Headers({"Content-Type: application/json"})
        @Get("/{scope}/providers/Microsoft.CostManagement/dimensions")
        @ExpectedResponses({200, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DimensionsListResult>> list(
            @HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @QueryParam("api-version") String apiVersion,
            @QueryParam("$filter") String filter,
            @QueryParam("$expand") String expand,
            @QueryParam("$skiptoken") String skiptoken,
            @QueryParam("$top") Integer top,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/providers/Microsoft.CostManagement/{externalCloudProviderType}/{externalCloudProviderId}/dimensions")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DimensionsListResult>> byExternalCloudProviderType(
            @HostParam("$host") String endpoint,
            @PathParam("externalCloudProviderType") ExternalCloudProviderType externalCloudProviderType,
            @PathParam("externalCloudProviderId") String externalCloudProviderId,
            @QueryParam("api-version") String apiVersion,
            @QueryParam("$filter") String filter,
            @QueryParam("$expand") String expand,
            @QueryParam("$skiptoken") String skiptoken,
            @QueryParam("$top") Integer top,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Lists the dimensions by the defined scope.
     *
     * @param scope The scope associated with dimension operations. This includes '/subscriptions/{subscriptionId}/' for
     *     subscription scope, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup
     *     scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
     *     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department
     *     scope,
     *     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}'
     *     for EnrollmentAccount scope, '/providers/Microsoft.Management/managementGroups/{managementGroupId}' for
     *     Management Group scope,
     *     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for
     *     billingProfile scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/invoiceSections/{invoiceSectionId}'
     *     for invoiceSection scope, and
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/customers/{customerId}' specific for
     *     partners.
     * @param filter May be used to filter dimensions by properties/category, properties/usageStart,
     *     properties/usageEnd. Supported operators are 'eq','lt', 'gt', 'le', 'ge'.
     * @param expand May be used to expand the properties/data within a dimension category. By default, data is not
     *     included when listing dimensions.
     * @param skiptoken Skiptoken is only used if a previous operation returned a partial result. If a previous response
     *     contains a nextLink element, the value of the nextLink element will include a skiptoken parameter that
     *     specifies a starting point to use for subsequent calls.
     * @param top May be used to limit the number of results to the most recent N dimension data.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of listing dimensions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DimensionInner>> listSinglePageAsync(
        String scope, String filter, String expand, String skiptoken, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .list(
                            this.client.getEndpoint(),
                            scope,
                            this.client.getApiVersion(),
                            filter,
                            expand,
                            skiptoken,
                            top,
                            accept,
                            context))
            .<PagedResponse<DimensionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists the dimensions by the defined scope.
     *
     * @param scope The scope associated with dimension operations. This includes '/subscriptions/{subscriptionId}/' for
     *     subscription scope, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup
     *     scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
     *     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department
     *     scope,
     *     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}'
     *     for EnrollmentAccount scope, '/providers/Microsoft.Management/managementGroups/{managementGroupId}' for
     *     Management Group scope,
     *     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for
     *     billingProfile scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/invoiceSections/{invoiceSectionId}'
     *     for invoiceSection scope, and
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/customers/{customerId}' specific for
     *     partners.
     * @param filter May be used to filter dimensions by properties/category, properties/usageStart,
     *     properties/usageEnd. Supported operators are 'eq','lt', 'gt', 'le', 'ge'.
     * @param expand May be used to expand the properties/data within a dimension category. By default, data is not
     *     included when listing dimensions.
     * @param skiptoken Skiptoken is only used if a previous operation returned a partial result. If a previous response
     *     contains a nextLink element, the value of the nextLink element will include a skiptoken parameter that
     *     specifies a starting point to use for subsequent calls.
     * @param top May be used to limit the number of results to the most recent N dimension data.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of listing dimensions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DimensionInner>> listSinglePageAsync(
        String scope, String filter, String expand, String skiptoken, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(
                this.client.getEndpoint(),
                scope,
                this.client.getApiVersion(),
                filter,
                expand,
                skiptoken,
                top,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null));
    }

    /**
     * Lists the dimensions by the defined scope.
     *
     * @param scope The scope associated with dimension operations. This includes '/subscriptions/{subscriptionId}/' for
     *     subscription scope, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup
     *     scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
     *     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department
     *     scope,
     *     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}'
     *     for EnrollmentAccount scope, '/providers/Microsoft.Management/managementGroups/{managementGroupId}' for
     *     Management Group scope,
     *     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for
     *     billingProfile scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/invoiceSections/{invoiceSectionId}'
     *     for invoiceSection scope, and
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/customers/{customerId}' specific for
     *     partners.
     * @param filter May be used to filter dimensions by properties/category, properties/usageStart,
     *     properties/usageEnd. Supported operators are 'eq','lt', 'gt', 'le', 'ge'.
     * @param expand May be used to expand the properties/data within a dimension category. By default, data is not
     *     included when listing dimensions.
     * @param skiptoken Skiptoken is only used if a previous operation returned a partial result. If a previous response
     *     contains a nextLink element, the value of the nextLink element will include a skiptoken parameter that
     *     specifies a starting point to use for subsequent calls.
     * @param top May be used to limit the number of results to the most recent N dimension data.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of listing dimensions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DimensionInner> listAsync(
        String scope, String filter, String expand, String skiptoken, Integer top) {
        return new PagedFlux<>(() -> listSinglePageAsync(scope, filter, expand, skiptoken, top));
    }

    /**
     * Lists the dimensions by the defined scope.
     *
     * @param scope The scope associated with dimension operations. This includes '/subscriptions/{subscriptionId}/' for
     *     subscription scope, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup
     *     scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
     *     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department
     *     scope,
     *     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}'
     *     for EnrollmentAccount scope, '/providers/Microsoft.Management/managementGroups/{managementGroupId}' for
     *     Management Group scope,
     *     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for
     *     billingProfile scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/invoiceSections/{invoiceSectionId}'
     *     for invoiceSection scope, and
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/customers/{customerId}' specific for
     *     partners.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of listing dimensions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DimensionInner> listAsync(String scope) {
        final String filter = null;
        final String expand = null;
        final String skiptoken = null;
        final Integer top = null;
        return new PagedFlux<>(() -> listSinglePageAsync(scope, filter, expand, skiptoken, top));
    }

    /**
     * Lists the dimensions by the defined scope.
     *
     * @param scope The scope associated with dimension operations. This includes '/subscriptions/{subscriptionId}/' for
     *     subscription scope, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup
     *     scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
     *     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department
     *     scope,
     *     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}'
     *     for EnrollmentAccount scope, '/providers/Microsoft.Management/managementGroups/{managementGroupId}' for
     *     Management Group scope,
     *     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for
     *     billingProfile scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/invoiceSections/{invoiceSectionId}'
     *     for invoiceSection scope, and
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/customers/{customerId}' specific for
     *     partners.
     * @param filter May be used to filter dimensions by properties/category, properties/usageStart,
     *     properties/usageEnd. Supported operators are 'eq','lt', 'gt', 'le', 'ge'.
     * @param expand May be used to expand the properties/data within a dimension category. By default, data is not
     *     included when listing dimensions.
     * @param skiptoken Skiptoken is only used if a previous operation returned a partial result. If a previous response
     *     contains a nextLink element, the value of the nextLink element will include a skiptoken parameter that
     *     specifies a starting point to use for subsequent calls.
     * @param top May be used to limit the number of results to the most recent N dimension data.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of listing dimensions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DimensionInner> listAsync(
        String scope, String filter, String expand, String skiptoken, Integer top, Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(scope, filter, expand, skiptoken, top, context));
    }

    /**
     * Lists the dimensions by the defined scope.
     *
     * @param scope The scope associated with dimension operations. This includes '/subscriptions/{subscriptionId}/' for
     *     subscription scope, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup
     *     scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
     *     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department
     *     scope,
     *     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}'
     *     for EnrollmentAccount scope, '/providers/Microsoft.Management/managementGroups/{managementGroupId}' for
     *     Management Group scope,
     *     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for
     *     billingProfile scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/invoiceSections/{invoiceSectionId}'
     *     for invoiceSection scope, and
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/customers/{customerId}' specific for
     *     partners.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of listing dimensions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DimensionInner> list(String scope) {
        final String filter = null;
        final String expand = null;
        final String skiptoken = null;
        final Integer top = null;
        return new PagedIterable<>(listAsync(scope, filter, expand, skiptoken, top));
    }

    /**
     * Lists the dimensions by the defined scope.
     *
     * @param scope The scope associated with dimension operations. This includes '/subscriptions/{subscriptionId}/' for
     *     subscription scope, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup
     *     scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
     *     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department
     *     scope,
     *     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}'
     *     for EnrollmentAccount scope, '/providers/Microsoft.Management/managementGroups/{managementGroupId}' for
     *     Management Group scope,
     *     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for
     *     billingProfile scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/invoiceSections/{invoiceSectionId}'
     *     for invoiceSection scope, and
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/customers/{customerId}' specific for
     *     partners.
     * @param filter May be used to filter dimensions by properties/category, properties/usageStart,
     *     properties/usageEnd. Supported operators are 'eq','lt', 'gt', 'le', 'ge'.
     * @param expand May be used to expand the properties/data within a dimension category. By default, data is not
     *     included when listing dimensions.
     * @param skiptoken Skiptoken is only used if a previous operation returned a partial result. If a previous response
     *     contains a nextLink element, the value of the nextLink element will include a skiptoken parameter that
     *     specifies a starting point to use for subsequent calls.
     * @param top May be used to limit the number of results to the most recent N dimension data.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of listing dimensions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DimensionInner> list(
        String scope, String filter, String expand, String skiptoken, Integer top, Context context) {
        return new PagedIterable<>(listAsync(scope, filter, expand, skiptoken, top, context));
    }

    /**
     * Lists the dimensions by the external cloud provider type.
     *
     * @param externalCloudProviderType The external cloud provider type associated with dimension/query operations.
     *     This includes 'externalSubscriptions' for linked account and 'externalBillingAccounts' for consolidated
     *     account.
     * @param externalCloudProviderId This can be '{externalSubscriptionId}' for linked account or
     *     '{externalBillingAccountId}' for consolidated account used with dimension/query operations.
     * @param filter May be used to filter dimensions by properties/category, properties/usageStart,
     *     properties/usageEnd. Supported operators are 'eq','lt', 'gt', 'le', 'ge'.
     * @param expand May be used to expand the properties/data within a dimension category. By default, data is not
     *     included when listing dimensions.
     * @param skiptoken Skiptoken is only used if a previous operation returned a partial result. If a previous response
     *     contains a nextLink element, the value of the nextLink element will include a skiptoken parameter that
     *     specifies a starting point to use for subsequent calls.
     * @param top May be used to limit the number of results to the most recent N dimension data.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of listing dimensions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DimensionInner>> byExternalCloudProviderTypeSinglePageAsync(
        ExternalCloudProviderType externalCloudProviderType,
        String externalCloudProviderId,
        String filter,
        String expand,
        String skiptoken,
        Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (externalCloudProviderType == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter externalCloudProviderType is required and cannot be null."));
        }
        if (externalCloudProviderId == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter externalCloudProviderId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .byExternalCloudProviderType(
                            this.client.getEndpoint(),
                            externalCloudProviderType,
                            externalCloudProviderId,
                            this.client.getApiVersion(),
                            filter,
                            expand,
                            skiptoken,
                            top,
                            accept,
                            context))
            .<PagedResponse<DimensionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists the dimensions by the external cloud provider type.
     *
     * @param externalCloudProviderType The external cloud provider type associated with dimension/query operations.
     *     This includes 'externalSubscriptions' for linked account and 'externalBillingAccounts' for consolidated
     *     account.
     * @param externalCloudProviderId This can be '{externalSubscriptionId}' for linked account or
     *     '{externalBillingAccountId}' for consolidated account used with dimension/query operations.
     * @param filter May be used to filter dimensions by properties/category, properties/usageStart,
     *     properties/usageEnd. Supported operators are 'eq','lt', 'gt', 'le', 'ge'.
     * @param expand May be used to expand the properties/data within a dimension category. By default, data is not
     *     included when listing dimensions.
     * @param skiptoken Skiptoken is only used if a previous operation returned a partial result. If a previous response
     *     contains a nextLink element, the value of the nextLink element will include a skiptoken parameter that
     *     specifies a starting point to use for subsequent calls.
     * @param top May be used to limit the number of results to the most recent N dimension data.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of listing dimensions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DimensionInner>> byExternalCloudProviderTypeSinglePageAsync(
        ExternalCloudProviderType externalCloudProviderType,
        String externalCloudProviderId,
        String filter,
        String expand,
        String skiptoken,
        Integer top,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (externalCloudProviderType == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter externalCloudProviderType is required and cannot be null."));
        }
        if (externalCloudProviderId == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter externalCloudProviderId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .byExternalCloudProviderType(
                this.client.getEndpoint(),
                externalCloudProviderType,
                externalCloudProviderId,
                this.client.getApiVersion(),
                filter,
                expand,
                skiptoken,
                top,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null));
    }

    /**
     * Lists the dimensions by the external cloud provider type.
     *
     * @param externalCloudProviderType The external cloud provider type associated with dimension/query operations.
     *     This includes 'externalSubscriptions' for linked account and 'externalBillingAccounts' for consolidated
     *     account.
     * @param externalCloudProviderId This can be '{externalSubscriptionId}' for linked account or
     *     '{externalBillingAccountId}' for consolidated account used with dimension/query operations.
     * @param filter May be used to filter dimensions by properties/category, properties/usageStart,
     *     properties/usageEnd. Supported operators are 'eq','lt', 'gt', 'le', 'ge'.
     * @param expand May be used to expand the properties/data within a dimension category. By default, data is not
     *     included when listing dimensions.
     * @param skiptoken Skiptoken is only used if a previous operation returned a partial result. If a previous response
     *     contains a nextLink element, the value of the nextLink element will include a skiptoken parameter that
     *     specifies a starting point to use for subsequent calls.
     * @param top May be used to limit the number of results to the most recent N dimension data.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of listing dimensions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DimensionInner> byExternalCloudProviderTypeAsync(
        ExternalCloudProviderType externalCloudProviderType,
        String externalCloudProviderId,
        String filter,
        String expand,
        String skiptoken,
        Integer top) {
        return new PagedFlux<>(
            () ->
                byExternalCloudProviderTypeSinglePageAsync(
                    externalCloudProviderType, externalCloudProviderId, filter, expand, skiptoken, top));
    }

    /**
     * Lists the dimensions by the external cloud provider type.
     *
     * @param externalCloudProviderType The external cloud provider type associated with dimension/query operations.
     *     This includes 'externalSubscriptions' for linked account and 'externalBillingAccounts' for consolidated
     *     account.
     * @param externalCloudProviderId This can be '{externalSubscriptionId}' for linked account or
     *     '{externalBillingAccountId}' for consolidated account used with dimension/query operations.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of listing dimensions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DimensionInner> byExternalCloudProviderTypeAsync(
        ExternalCloudProviderType externalCloudProviderType, String externalCloudProviderId) {
        final String filter = null;
        final String expand = null;
        final String skiptoken = null;
        final Integer top = null;
        return new PagedFlux<>(
            () ->
                byExternalCloudProviderTypeSinglePageAsync(
                    externalCloudProviderType, externalCloudProviderId, filter, expand, skiptoken, top));
    }

    /**
     * Lists the dimensions by the external cloud provider type.
     *
     * @param externalCloudProviderType The external cloud provider type associated with dimension/query operations.
     *     This includes 'externalSubscriptions' for linked account and 'externalBillingAccounts' for consolidated
     *     account.
     * @param externalCloudProviderId This can be '{externalSubscriptionId}' for linked account or
     *     '{externalBillingAccountId}' for consolidated account used with dimension/query operations.
     * @param filter May be used to filter dimensions by properties/category, properties/usageStart,
     *     properties/usageEnd. Supported operators are 'eq','lt', 'gt', 'le', 'ge'.
     * @param expand May be used to expand the properties/data within a dimension category. By default, data is not
     *     included when listing dimensions.
     * @param skiptoken Skiptoken is only used if a previous operation returned a partial result. If a previous response
     *     contains a nextLink element, the value of the nextLink element will include a skiptoken parameter that
     *     specifies a starting point to use for subsequent calls.
     * @param top May be used to limit the number of results to the most recent N dimension data.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of listing dimensions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DimensionInner> byExternalCloudProviderTypeAsync(
        ExternalCloudProviderType externalCloudProviderType,
        String externalCloudProviderId,
        String filter,
        String expand,
        String skiptoken,
        Integer top,
        Context context) {
        return new PagedFlux<>(
            () ->
                byExternalCloudProviderTypeSinglePageAsync(
                    externalCloudProviderType, externalCloudProviderId, filter, expand, skiptoken, top, context));
    }

    /**
     * Lists the dimensions by the external cloud provider type.
     *
     * @param externalCloudProviderType The external cloud provider type associated with dimension/query operations.
     *     This includes 'externalSubscriptions' for linked account and 'externalBillingAccounts' for consolidated
     *     account.
     * @param externalCloudProviderId This can be '{externalSubscriptionId}' for linked account or
     *     '{externalBillingAccountId}' for consolidated account used with dimension/query operations.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of listing dimensions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DimensionInner> byExternalCloudProviderType(
        ExternalCloudProviderType externalCloudProviderType, String externalCloudProviderId) {
        final String filter = null;
        final String expand = null;
        final String skiptoken = null;
        final Integer top = null;
        return new PagedIterable<>(
            byExternalCloudProviderTypeAsync(
                externalCloudProviderType, externalCloudProviderId, filter, expand, skiptoken, top));
    }

    /**
     * Lists the dimensions by the external cloud provider type.
     *
     * @param externalCloudProviderType The external cloud provider type associated with dimension/query operations.
     *     This includes 'externalSubscriptions' for linked account and 'externalBillingAccounts' for consolidated
     *     account.
     * @param externalCloudProviderId This can be '{externalSubscriptionId}' for linked account or
     *     '{externalBillingAccountId}' for consolidated account used with dimension/query operations.
     * @param filter May be used to filter dimensions by properties/category, properties/usageStart,
     *     properties/usageEnd. Supported operators are 'eq','lt', 'gt', 'le', 'ge'.
     * @param expand May be used to expand the properties/data within a dimension category. By default, data is not
     *     included when listing dimensions.
     * @param skiptoken Skiptoken is only used if a previous operation returned a partial result. If a previous response
     *     contains a nextLink element, the value of the nextLink element will include a skiptoken parameter that
     *     specifies a starting point to use for subsequent calls.
     * @param top May be used to limit the number of results to the most recent N dimension data.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of listing dimensions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DimensionInner> byExternalCloudProviderType(
        ExternalCloudProviderType externalCloudProviderType,
        String externalCloudProviderId,
        String filter,
        String expand,
        String skiptoken,
        Integer top,
        Context context) {
        return new PagedIterable<>(
            byExternalCloudProviderTypeAsync(
                externalCloudProviderType, externalCloudProviderId, filter, expand, skiptoken, top, context));
    }
}
