// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.costmanagement.fluent.GenerateDetailedCostReportOperationResultsClient;
import com.azure.resourcemanager.costmanagement.fluent.models.GenerateDetailedCostReportOperationResultInner;
import com.azure.resourcemanager.costmanagement.models.GenerateDetailedCostReportOperationResult;
import com.azure.resourcemanager.costmanagement.models.GenerateDetailedCostReportOperationResults;

public final class GenerateDetailedCostReportOperationResultsImpl
    implements GenerateDetailedCostReportOperationResults {
    private static final ClientLogger LOGGER = new ClientLogger(GenerateDetailedCostReportOperationResultsImpl.class);

    private final GenerateDetailedCostReportOperationResultsClient innerClient;

    private final com.azure.resourcemanager.costmanagement.CostManagementManager serviceManager;

    public GenerateDetailedCostReportOperationResultsImpl(
        GenerateDetailedCostReportOperationResultsClient innerClient,
        com.azure.resourcemanager.costmanagement.CostManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public GenerateDetailedCostReportOperationResult get(String operationId, String scope) {
        GenerateDetailedCostReportOperationResultInner inner = this.serviceClient().get(operationId, scope);
        if (inner != null) {
            return new GenerateDetailedCostReportOperationResultImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public GenerateDetailedCostReportOperationResult get(String operationId, String scope, Context context) {
        GenerateDetailedCostReportOperationResultInner inner = this.serviceClient().get(operationId, scope, context);
        if (inner != null) {
            return new GenerateDetailedCostReportOperationResultImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private GenerateDetailedCostReportOperationResultsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.costmanagement.CostManagementManager manager() {
        return this.serviceManager;
    }
}
