// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.costmanagement.fluent.GenerateDetailedCostReportsClient;
import com.azure.resourcemanager.costmanagement.fluent.models.GenerateDetailedCostReportOperationResultInner;
import com.azure.resourcemanager.costmanagement.models.GenerateDetailedCostReportDefinition;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in GenerateDetailedCostReportsClient. */
public final class GenerateDetailedCostReportsClientImpl implements GenerateDetailedCostReportsClient {
    /** The proxy service used to perform REST calls. */
    private final GenerateDetailedCostReportsService service;

    /** The service client containing this operation class. */
    private final CostManagementClientImpl client;

    /**
     * Initializes an instance of GenerateDetailedCostReportsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    GenerateDetailedCostReportsClientImpl(CostManagementClientImpl client) {
        this.service =
            RestProxy
                .create(
                    GenerateDetailedCostReportsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for CostManagementClientGenerateDetailedCostReports to be used by the
     * proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "CostManagementClient")
    public interface GenerateDetailedCostReportsService {
        @Headers({"Content-Type: application/json"})
        @Post("/{scope}/providers/Microsoft.CostManagement/generateDetailedCostReport")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createOperation(
            @HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") GenerateDetailedCostReportDefinition parameters,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Generates the detailed cost report for provided date range, billing period(only enterprise customers) or Invoice
     * ID asynchronously at a certain scope. Call returns a 202 with header Azure-Consumption-AsyncOperation providing a
     * link to the operation created. A call on the operation will provide the status and if the operation is completed
     * the blob file where generated detailed cost report is being stored.
     *
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     *     details, see https://aka.ms/costmgmt/scopes.
     * @param parameters Parameters supplied to the Create detailed cost report operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the long running operation for cost detailed report along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOperationWithResponseAsync(
        String scope, GenerateDetailedCostReportDefinition parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createOperation(
                            this.client.getEndpoint(), scope, this.client.getApiVersion(), parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Generates the detailed cost report for provided date range, billing period(only enterprise customers) or Invoice
     * ID asynchronously at a certain scope. Call returns a 202 with header Azure-Consumption-AsyncOperation providing a
     * link to the operation created. A call on the operation will provide the status and if the operation is completed
     * the blob file where generated detailed cost report is being stored.
     *
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     *     details, see https://aka.ms/costmgmt/scopes.
     * @param parameters Parameters supplied to the Create detailed cost report operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the long running operation for cost detailed report along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOperationWithResponseAsync(
        String scope, GenerateDetailedCostReportDefinition parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .createOperation(
                this.client.getEndpoint(), scope, this.client.getApiVersion(), parameters, accept, context);
    }

    /**
     * Generates the detailed cost report for provided date range, billing period(only enterprise customers) or Invoice
     * ID asynchronously at a certain scope. Call returns a 202 with header Azure-Consumption-AsyncOperation providing a
     * link to the operation created. A call on the operation will provide the status and if the operation is completed
     * the blob file where generated detailed cost report is being stored.
     *
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     *     details, see https://aka.ms/costmgmt/scopes.
     * @param parameters Parameters supplied to the Create detailed cost report operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the result of the long running operation for cost detailed report.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<
            PollResult<GenerateDetailedCostReportOperationResultInner>, GenerateDetailedCostReportOperationResultInner>
        beginCreateOperationAsync(String scope, GenerateDetailedCostReportDefinition parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = createOperationWithResponseAsync(scope, parameters);
        return this
            .client
            .<GenerateDetailedCostReportOperationResultInner, GenerateDetailedCostReportOperationResultInner>
                getLroResult(
                    mono,
                    this.client.getHttpPipeline(),
                    GenerateDetailedCostReportOperationResultInner.class,
                    GenerateDetailedCostReportOperationResultInner.class,
                    this.client.getContext());
    }

    /**
     * Generates the detailed cost report for provided date range, billing period(only enterprise customers) or Invoice
     * ID asynchronously at a certain scope. Call returns a 202 with header Azure-Consumption-AsyncOperation providing a
     * link to the operation created. A call on the operation will provide the status and if the operation is completed
     * the blob file where generated detailed cost report is being stored.
     *
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     *     details, see https://aka.ms/costmgmt/scopes.
     * @param parameters Parameters supplied to the Create detailed cost report operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the result of the long running operation for cost detailed report.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<
            PollResult<GenerateDetailedCostReportOperationResultInner>, GenerateDetailedCostReportOperationResultInner>
        beginCreateOperationAsync(String scope, GenerateDetailedCostReportDefinition parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = createOperationWithResponseAsync(scope, parameters, context);
        return this
            .client
            .<GenerateDetailedCostReportOperationResultInner, GenerateDetailedCostReportOperationResultInner>
                getLroResult(
                    mono,
                    this.client.getHttpPipeline(),
                    GenerateDetailedCostReportOperationResultInner.class,
                    GenerateDetailedCostReportOperationResultInner.class,
                    context);
    }

    /**
     * Generates the detailed cost report for provided date range, billing period(only enterprise customers) or Invoice
     * ID asynchronously at a certain scope. Call returns a 202 with header Azure-Consumption-AsyncOperation providing a
     * link to the operation created. A call on the operation will provide the status and if the operation is completed
     * the blob file where generated detailed cost report is being stored.
     *
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     *     details, see https://aka.ms/costmgmt/scopes.
     * @param parameters Parameters supplied to the Create detailed cost report operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the result of the long running operation for cost detailed report.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<
            PollResult<GenerateDetailedCostReportOperationResultInner>, GenerateDetailedCostReportOperationResultInner>
        beginCreateOperation(String scope, GenerateDetailedCostReportDefinition parameters) {
        return this.beginCreateOperationAsync(scope, parameters).getSyncPoller();
    }

    /**
     * Generates the detailed cost report for provided date range, billing period(only enterprise customers) or Invoice
     * ID asynchronously at a certain scope. Call returns a 202 with header Azure-Consumption-AsyncOperation providing a
     * link to the operation created. A call on the operation will provide the status and if the operation is completed
     * the blob file where generated detailed cost report is being stored.
     *
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     *     details, see https://aka.ms/costmgmt/scopes.
     * @param parameters Parameters supplied to the Create detailed cost report operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the result of the long running operation for cost detailed report.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<
            PollResult<GenerateDetailedCostReportOperationResultInner>, GenerateDetailedCostReportOperationResultInner>
        beginCreateOperation(String scope, GenerateDetailedCostReportDefinition parameters, Context context) {
        return this.beginCreateOperationAsync(scope, parameters, context).getSyncPoller();
    }

    /**
     * Generates the detailed cost report for provided date range, billing period(only enterprise customers) or Invoice
     * ID asynchronously at a certain scope. Call returns a 202 with header Azure-Consumption-AsyncOperation providing a
     * link to the operation created. A call on the operation will provide the status and if the operation is completed
     * the blob file where generated detailed cost report is being stored.
     *
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     *     details, see https://aka.ms/costmgmt/scopes.
     * @param parameters Parameters supplied to the Create detailed cost report operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the long running operation for cost detailed report on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<GenerateDetailedCostReportOperationResultInner> createOperationAsync(
        String scope, GenerateDetailedCostReportDefinition parameters) {
        return beginCreateOperationAsync(scope, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Generates the detailed cost report for provided date range, billing period(only enterprise customers) or Invoice
     * ID asynchronously at a certain scope. Call returns a 202 with header Azure-Consumption-AsyncOperation providing a
     * link to the operation created. A call on the operation will provide the status and if the operation is completed
     * the blob file where generated detailed cost report is being stored.
     *
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     *     details, see https://aka.ms/costmgmt/scopes.
     * @param parameters Parameters supplied to the Create detailed cost report operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the long running operation for cost detailed report on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<GenerateDetailedCostReportOperationResultInner> createOperationAsync(
        String scope, GenerateDetailedCostReportDefinition parameters, Context context) {
        return beginCreateOperationAsync(scope, parameters, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Generates the detailed cost report for provided date range, billing period(only enterprise customers) or Invoice
     * ID asynchronously at a certain scope. Call returns a 202 with header Azure-Consumption-AsyncOperation providing a
     * link to the operation created. A call on the operation will provide the status and if the operation is completed
     * the blob file where generated detailed cost report is being stored.
     *
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     *     details, see https://aka.ms/costmgmt/scopes.
     * @param parameters Parameters supplied to the Create detailed cost report operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the long running operation for cost detailed report.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GenerateDetailedCostReportOperationResultInner createOperation(
        String scope, GenerateDetailedCostReportDefinition parameters) {
        return createOperationAsync(scope, parameters).block();
    }

    /**
     * Generates the detailed cost report for provided date range, billing period(only enterprise customers) or Invoice
     * ID asynchronously at a certain scope. Call returns a 202 with header Azure-Consumption-AsyncOperation providing a
     * link to the operation created. A call on the operation will provide the status and if the operation is completed
     * the blob file where generated detailed cost report is being stored.
     *
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     *     details, see https://aka.ms/costmgmt/scopes.
     * @param parameters Parameters supplied to the Create detailed cost report operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the long running operation for cost detailed report.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GenerateDetailedCostReportOperationResultInner createOperation(
        String scope, GenerateDetailedCostReportDefinition parameters, Context context) {
        return createOperationAsync(scope, parameters, context).block();
    }
}
