// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;

/** Benefit recommendation details. */
@Immutable
public final class AllSavingsBenefitDetails {
    /*
     * The difference between total cost and benefit cost for the 'totalHours' in the look-back period.
     */
    @JsonProperty(value = "overageCost", access = JsonProperty.Access.WRITE_ONLY)
    private BigDecimal overageCost;

    /*
     * The estimated cost with benefit for the 'totalHours' in the look-back period. It's equal to (commitmentAmount *
     * totalHours)
     */
    @JsonProperty(value = "benefitCost", access = JsonProperty.Access.WRITE_ONLY)
    private BigDecimal benefitCost;

    /*
     * Total cost, which is sum of benefit cost and overage cost.
     */
    @JsonProperty(value = "totalCost", access = JsonProperty.Access.WRITE_ONLY)
    private BigDecimal totalCost;

    /*
     * The amount saved for the 'totalHours' in the look-back period, by purchasing the recommended quantity of the
     * benefit.
     */
    @JsonProperty(value = "savingsAmount", access = JsonProperty.Access.WRITE_ONLY)
    private BigDecimal savingsAmount;

    /*
     * The savings in percentage for the 'totalHours' in the look-back period, by purchasing the recommended quantity
     * of benefit.
     */
    @JsonProperty(value = "savingsPercentage", access = JsonProperty.Access.WRITE_ONLY)
    private BigDecimal savingsPercentage;

    /*
     * Estimated benefit coverage percentage for the 'totalHours' in the look-back period, with this commitment.
     */
    @JsonProperty(value = "coveragePercentage", access = JsonProperty.Access.WRITE_ONLY)
    private BigDecimal coveragePercentage;

    /*
     * The commitment amount at the commitmentGranularity.
     */
    @JsonProperty(value = "commitmentAmount", access = JsonProperty.Access.WRITE_ONLY)
    private BigDecimal commitmentAmount;

    /*
     * Estimated average utilization percentage for the 'totalHours' in the look-back period, with this commitment.
     */
    @JsonProperty(value = "averageUtilizationPercentage", access = JsonProperty.Access.WRITE_ONLY)
    private BigDecimal averageUtilizationPercentage;

    /*
     * Estimated unused portion of the 'benefitCost'.
     */
    @JsonProperty(value = "wastageCost", access = JsonProperty.Access.WRITE_ONLY)
    private BigDecimal wastageCost;

    /** Creates an instance of AllSavingsBenefitDetails class. */
    public AllSavingsBenefitDetails() {
    }

    /**
     * Get the overageCost property: The difference between total cost and benefit cost for the 'totalHours' in the
     * look-back period.
     *
     * @return the overageCost value.
     */
    public BigDecimal overageCost() {
        return this.overageCost;
    }

    /**
     * Get the benefitCost property: The estimated cost with benefit for the 'totalHours' in the look-back period. It's
     * equal to (commitmentAmount * totalHours).
     *
     * @return the benefitCost value.
     */
    public BigDecimal benefitCost() {
        return this.benefitCost;
    }

    /**
     * Get the totalCost property: Total cost, which is sum of benefit cost and overage cost.
     *
     * @return the totalCost value.
     */
    public BigDecimal totalCost() {
        return this.totalCost;
    }

    /**
     * Get the savingsAmount property: The amount saved for the 'totalHours' in the look-back period, by purchasing the
     * recommended quantity of the benefit.
     *
     * @return the savingsAmount value.
     */
    public BigDecimal savingsAmount() {
        return this.savingsAmount;
    }

    /**
     * Get the savingsPercentage property: The savings in percentage for the 'totalHours' in the look-back period, by
     * purchasing the recommended quantity of benefit.
     *
     * @return the savingsPercentage value.
     */
    public BigDecimal savingsPercentage() {
        return this.savingsPercentage;
    }

    /**
     * Get the coveragePercentage property: Estimated benefit coverage percentage for the 'totalHours' in the look-back
     * period, with this commitment.
     *
     * @return the coveragePercentage value.
     */
    public BigDecimal coveragePercentage() {
        return this.coveragePercentage;
    }

    /**
     * Get the commitmentAmount property: The commitment amount at the commitmentGranularity.
     *
     * @return the commitmentAmount value.
     */
    public BigDecimal commitmentAmount() {
        return this.commitmentAmount;
    }

    /**
     * Get the averageUtilizationPercentage property: Estimated average utilization percentage for the 'totalHours' in
     * the look-back period, with this commitment.
     *
     * @return the averageUtilizationPercentage value.
     */
    public BigDecimal averageUtilizationPercentage() {
        return this.averageUtilizationPercentage;
    }

    /**
     * Get the wastageCost property: Estimated unused portion of the 'benefitCost'.
     *
     * @return the wastageCost value.
     */
    public BigDecimal wastageCost() {
        return this.wastageCost;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
