// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** The properties of a benefit utilization summary. */
@Fluent
public class BenefitUtilizationSummaryProperties {
    /*
     * ARM SKU name. For example, 'Compute_Savings_Plan' for savings plan.
     */
    @JsonProperty(value = "armSkuName", access = JsonProperty.Access.WRITE_ONLY)
    private String armSkuName;

    /*
     * The benefit ID is the identifier of the benefit.
     */
    @JsonProperty(value = "benefitId", access = JsonProperty.Access.WRITE_ONLY)
    private String benefitId;

    /*
     * The benefit order ID is the identifier for a benefit purchase.
     */
    @JsonProperty(value = "benefitOrderId", access = JsonProperty.Access.WRITE_ONLY)
    private String benefitOrderId;

    /*
     * The benefit type. Supported values: 'SavingsPlan'.
     */
    @JsonProperty(value = "benefitType")
    private BenefitKind benefitType;

    /*
     * Date corresponding to the utilization summary record. If the grain of data is monthly, value for this field will
     * be first day of the month.
     */
    @JsonProperty(value = "usageDate", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime usageDate;

    /** Creates an instance of BenefitUtilizationSummaryProperties class. */
    public BenefitUtilizationSummaryProperties() {
    }

    /**
     * Get the armSkuName property: ARM SKU name. For example, 'Compute_Savings_Plan' for savings plan.
     *
     * @return the armSkuName value.
     */
    public String armSkuName() {
        return this.armSkuName;
    }

    /**
     * Get the benefitId property: The benefit ID is the identifier of the benefit.
     *
     * @return the benefitId value.
     */
    public String benefitId() {
        return this.benefitId;
    }

    /**
     * Get the benefitOrderId property: The benefit order ID is the identifier for a benefit purchase.
     *
     * @return the benefitOrderId value.
     */
    public String benefitOrderId() {
        return this.benefitOrderId;
    }

    /**
     * Get the benefitType property: The benefit type. Supported values: 'SavingsPlan'.
     *
     * @return the benefitType value.
     */
    public BenefitKind benefitType() {
        return this.benefitType;
    }

    /**
     * Set the benefitType property: The benefit type. Supported values: 'SavingsPlan'.
     *
     * @param benefitType the benefitType value to set.
     * @return the BenefitUtilizationSummaryProperties object itself.
     */
    public BenefitUtilizationSummaryProperties withBenefitType(BenefitKind benefitType) {
        this.benefitType = benefitType;
        return this;
    }

    /**
     * Get the usageDate property: Date corresponding to the utilization summary record. If the grain of data is
     * monthly, value for this field will be first day of the month.
     *
     * @return the usageDate value.
     */
    public OffsetDateTime usageDate() {
        return this.usageDate;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
