// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Immutable;
import com.azure.resourcemanager.costmanagement.fluent.models.DimensionInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Result of listing dimensions. It contains a list of available dimensions. */
@Immutable
public final class DimensionsListResult {
    /*
     * The list of dimensions.
     */
    @JsonProperty(value = "value", access = JsonProperty.Access.WRITE_ONLY)
    private List<DimensionInner> value;

    /** Creates an instance of DimensionsListResult class. */
    public DimensionsListResult() {
    }

    /**
     * Get the value property: The list of dimensions.
     *
     * @return the value value.
     */
    public List<DimensionInner> value() {
        return this.value;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
