// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * The export dataset configuration. Allows columns to be selected for the export. If not provided then the export will
 * include all available columns.
 */
@Fluent
public final class ExportDatasetConfiguration {
    /*
     * Array of column names to be included in the export. If not provided then the export will include all available
     * columns. The available columns can vary by customer channel (see examples).
     */
    @JsonProperty(value = "columns")
    private List<String> columns;

    /** Creates an instance of ExportDatasetConfiguration class. */
    public ExportDatasetConfiguration() {
    }

    /**
     * Get the columns property: Array of column names to be included in the export. If not provided then the export
     * will include all available columns. The available columns can vary by customer channel (see examples).
     *
     * @return the columns value.
     */
    public List<String> columns() {
        return this.columns;
    }

    /**
     * Set the columns property: Array of column names to be included in the export. If not provided then the export
     * will include all available columns. The available columns can vary by customer channel (see examples).
     *
     * @param columns the columns value to set.
     * @return the ExportDatasetConfiguration object itself.
     */
    public ExportDatasetConfiguration withColumns(List<String> columns) {
        this.columns = columns;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
