// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * This represents the blob storage account location where exports of costs will be delivered. There are two ways to
 * configure the destination. The approach recommended for most customers is to specify the resourceId of the storage
 * account. This requires a one-time registration of the account's subscription with the Microsoft.CostManagementExports
 * resource provider in order to give Cost Management services access to the storage. When creating an export in the
 * Azure portal this registration is performed automatically but API users may need to register the subscription
 * explicitly (for more information see
 * https://docs.microsoft.com/en-us/azure/azure-resource-manager/resource-manager-supported-services ). Another way to
 * configure the destination is available ONLY to Partners with a Microsoft Partner Agreement plan who are global admins
 * of their billing account. These Partners, instead of specifying the resourceId of a storage account, can specify the
 * storage account name along with a SAS token for the account. This allows exports of costs to a storage account in any
 * tenant. The SAS token should be created for the blob service with Service/Container/Object resource types and with
 * Read/Write/Delete/List/Add/Create permissions (for more information see
 * https://docs.microsoft.com/en-us/azure/cost-management-billing/costs/export-cost-data-storage-account-sas-key ).
 */
@Fluent
public final class ExportDeliveryDestination {
    /*
     * The resource id of the storage account where exports will be delivered. This is not required if a sasToken and
     * storageAccount are specified.
     */
    @JsonProperty(value = "resourceId")
    private String resourceId;

    /*
     * The name of the container where exports will be uploaded. If the container does not exist it will be created.
     */
    @JsonProperty(value = "container", required = true)
    private String container;

    /*
     * The name of the directory where exports will be uploaded.
     */
    @JsonProperty(value = "rootFolderPath")
    private String rootFolderPath;

    /*
     * A SAS token for the storage account. For a restricted set of Azure customers this together with storageAccount
     * can be specified instead of resourceId. Note: the value returned by the API for this property will always be
     * obfuscated. Returning this same obfuscated value will not result in the SAS token being updated. To update this
     * value a new SAS token must be specified.
     */
    @JsonProperty(value = "sasToken")
    private String sasToken;

    /*
     * The storage account where exports will be uploaded. For a restricted set of Azure customers this together with
     * sasToken can be specified instead of resourceId.
     */
    @JsonProperty(value = "storageAccount")
    private String storageAccount;

    /** Creates an instance of ExportDeliveryDestination class. */
    public ExportDeliveryDestination() {
    }

    /**
     * Get the resourceId property: The resource id of the storage account where exports will be delivered. This is not
     * required if a sasToken and storageAccount are specified.
     *
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId property: The resource id of the storage account where exports will be delivered. This is not
     * required if a sasToken and storageAccount are specified.
     *
     * @param resourceId the resourceId value to set.
     * @return the ExportDeliveryDestination object itself.
     */
    public ExportDeliveryDestination withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Get the container property: The name of the container where exports will be uploaded. If the container does not
     * exist it will be created.
     *
     * @return the container value.
     */
    public String container() {
        return this.container;
    }

    /**
     * Set the container property: The name of the container where exports will be uploaded. If the container does not
     * exist it will be created.
     *
     * @param container the container value to set.
     * @return the ExportDeliveryDestination object itself.
     */
    public ExportDeliveryDestination withContainer(String container) {
        this.container = container;
        return this;
    }

    /**
     * Get the rootFolderPath property: The name of the directory where exports will be uploaded.
     *
     * @return the rootFolderPath value.
     */
    public String rootFolderPath() {
        return this.rootFolderPath;
    }

    /**
     * Set the rootFolderPath property: The name of the directory where exports will be uploaded.
     *
     * @param rootFolderPath the rootFolderPath value to set.
     * @return the ExportDeliveryDestination object itself.
     */
    public ExportDeliveryDestination withRootFolderPath(String rootFolderPath) {
        this.rootFolderPath = rootFolderPath;
        return this;
    }

    /**
     * Get the sasToken property: A SAS token for the storage account. For a restricted set of Azure customers this
     * together with storageAccount can be specified instead of resourceId. Note: the value returned by the API for this
     * property will always be obfuscated. Returning this same obfuscated value will not result in the SAS token being
     * updated. To update this value a new SAS token must be specified.
     *
     * @return the sasToken value.
     */
    public String sasToken() {
        return this.sasToken;
    }

    /**
     * Set the sasToken property: A SAS token for the storage account. For a restricted set of Azure customers this
     * together with storageAccount can be specified instead of resourceId. Note: the value returned by the API for this
     * property will always be obfuscated. Returning this same obfuscated value will not result in the SAS token being
     * updated. To update this value a new SAS token must be specified.
     *
     * @param sasToken the sasToken value to set.
     * @return the ExportDeliveryDestination object itself.
     */
    public ExportDeliveryDestination withSasToken(String sasToken) {
        this.sasToken = sasToken;
        return this;
    }

    /**
     * Get the storageAccount property: The storage account where exports will be uploaded. For a restricted set of
     * Azure customers this together with sasToken can be specified instead of resourceId.
     *
     * @return the storageAccount value.
     */
    public String storageAccount() {
        return this.storageAccount;
    }

    /**
     * Set the storageAccount property: The storage account where exports will be uploaded. For a restricted set of
     * Azure customers this together with sasToken can be specified instead of resourceId.
     *
     * @param storageAccount the storageAccount value to set.
     * @return the ExportDeliveryDestination object itself.
     */
    public ExportDeliveryDestination withStorageAccount(String storageAccount) {
        this.storageAccount = storageAccount;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (container() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property container in model ExportDeliveryDestination"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ExportDeliveryDestination.class);
}
