// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The delivery information associated with a export. */
@Fluent
public final class ExportDeliveryInfo {
    /*
     * Has destination for the export being delivered.
     */
    @JsonProperty(value = "destination", required = true)
    private ExportDeliveryDestination destination;

    /** Creates an instance of ExportDeliveryInfo class. */
    public ExportDeliveryInfo() {
    }

    /**
     * Get the destination property: Has destination for the export being delivered.
     *
     * @return the destination value.
     */
    public ExportDeliveryDestination destination() {
        return this.destination;
    }

    /**
     * Set the destination property: Has destination for the export being delivered.
     *
     * @param destination the destination value to set.
     * @return the ExportDeliveryInfo object itself.
     */
    public ExportDeliveryInfo withDestination(ExportDeliveryDestination destination) {
        this.destination = destination;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (destination() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property destination in model ExportDeliveryInfo"));
        } else {
            destination().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ExportDeliveryInfo.class);
}
