// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** The start and end date for recurrence schedule. */
@Fluent
public final class ExportRecurrencePeriod {
    /*
     * The start date of recurrence.
     */
    @JsonProperty(value = "from", required = true)
    private OffsetDateTime from;

    /*
     * The end date of recurrence.
     */
    @JsonProperty(value = "to")
    private OffsetDateTime to;

    /** Creates an instance of ExportRecurrencePeriod class. */
    public ExportRecurrencePeriod() {
    }

    /**
     * Get the from property: The start date of recurrence.
     *
     * @return the from value.
     */
    public OffsetDateTime from() {
        return this.from;
    }

    /**
     * Set the from property: The start date of recurrence.
     *
     * @param from the from value to set.
     * @return the ExportRecurrencePeriod object itself.
     */
    public ExportRecurrencePeriod withFrom(OffsetDateTime from) {
        this.from = from;
        return this;
    }

    /**
     * Get the to property: The end date of recurrence.
     *
     * @return the to value.
     */
    public OffsetDateTime to() {
        return this.to;
    }

    /**
     * Set the to property: The end date of recurrence.
     *
     * @param to the to value to set.
     * @return the ExportRecurrencePeriod object itself.
     */
    public ExportRecurrencePeriod withTo(OffsetDateTime to) {
        this.to = to;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (from() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property from in model ExportRecurrencePeriod"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ExportRecurrencePeriod.class);
}
