// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The configuration of dataset in the forecast. */
@Fluent
public final class ForecastDatasetConfiguration {
    /*
     * Array of column names to be included in the forecast. Any valid forecast column name is allowed. If not
     * provided, then forecast includes all columns.
     */
    @JsonProperty(value = "columns")
    private List<String> columns;

    /** Creates an instance of ForecastDatasetConfiguration class. */
    public ForecastDatasetConfiguration() {
    }

    /**
     * Get the columns property: Array of column names to be included in the forecast. Any valid forecast column name is
     * allowed. If not provided, then forecast includes all columns.
     *
     * @return the columns value.
     */
    public List<String> columns() {
        return this.columns;
    }

    /**
     * Set the columns property: Array of column names to be included in the forecast. Any valid forecast column name is
     * allowed. If not provided, then forecast includes all columns.
     *
     * @param columns the columns value to set.
     * @return the ForecastDatasetConfiguration object itself.
     */
    public ForecastDatasetConfiguration withColumns(List<String> columns) {
        this.columns = columns;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
