// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.resourcemanager.costmanagement.fluent.models.ForecastResultInner;
import java.util.List;
import java.util.Map;

/** An immutable client-side representation of ForecastResult. */
public interface ForecastResult {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     *
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     *
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     *
     * @return the type value.
     */
    String type();

    /**
     * Gets the location property: The geo-location where the resource lives.
     *
     * @return the location value.
     */
    String location();

    /**
     * Gets the tags property: Resource tags.
     *
     * @return the tags value.
     */
    Map<String, String> tags();

    /**
     * Gets the sku property: SKU of the resource.
     *
     * @return the sku value.
     */
    String sku();

    /**
     * Gets the etag property: ETag of the resource.
     *
     * @return the etag value.
     */
    String etag();

    /**
     * Gets the nextLink property: The link (url) to the next page of results.
     *
     * @return the nextLink value.
     */
    String nextLink();

    /**
     * Gets the columns property: Array of columns.
     *
     * @return the columns value.
     */
    List<ForecastColumn> columns();

    /**
     * Gets the rows property: Array of rows.
     *
     * @return the rows value.
     */
    List<List<Object>> rows();

    /**
     * Gets the inner com.azure.resourcemanager.costmanagement.fluent.models.ForecastResultInner object.
     *
     * @return the inner object.
     */
    ForecastResultInner innerModel();
}
