// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.costmanagement.fluent.models.BenefitUtilizationSummaryInner;
import com.azure.resourcemanager.costmanagement.fluent.models.IncludedQuantityUtilizationSummaryProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.math.BigDecimal;
import java.time.OffsetDateTime;

/** Included Quantity utilization summary resource. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "kind")
@JsonTypeName("IncludedQuantity")
@Fluent
public final class IncludedQuantityUtilizationSummary extends BenefitUtilizationSummaryInner {
    /*
     * Included Quantity utilization summary properties.
     */
    @JsonProperty(value = "properties")
    private IncludedQuantityUtilizationSummaryProperties innerProperties;

    /** Creates an instance of IncludedQuantityUtilizationSummary class. */
    public IncludedQuantityUtilizationSummary() {
    }

    /**
     * Get the innerProperties property: Included Quantity utilization summary properties.
     *
     * @return the innerProperties value.
     */
    private IncludedQuantityUtilizationSummaryProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the utilizationPercentage property: This is the utilized percentage for the benefit ID.
     *
     * @return the utilizationPercentage value.
     */
    public BigDecimal utilizationPercentage() {
        return this.innerProperties() == null ? null : this.innerProperties().utilizationPercentage();
    }

    /**
     * Get the armSkuName property: ARM SKU name. For example, 'Compute_Savings_Plan' for savings plan.
     *
     * @return the armSkuName value.
     */
    public String armSkuName() {
        return this.innerProperties() == null ? null : this.innerProperties().armSkuName();
    }

    /**
     * Get the benefitId property: The benefit ID is the identifier of the benefit.
     *
     * @return the benefitId value.
     */
    public String benefitId() {
        return this.innerProperties() == null ? null : this.innerProperties().benefitId();
    }

    /**
     * Get the benefitOrderId property: The benefit order ID is the identifier for a benefit purchase.
     *
     * @return the benefitOrderId value.
     */
    public String benefitOrderId() {
        return this.innerProperties() == null ? null : this.innerProperties().benefitOrderId();
    }

    /**
     * Get the benefitType property: The benefit type. Supported values: 'SavingsPlan'.
     *
     * @return the benefitType value.
     */
    public BenefitKind benefitType() {
        return this.innerProperties() == null ? null : this.innerProperties().benefitType();
    }

    /**
     * Set the benefitType property: The benefit type. Supported values: 'SavingsPlan'.
     *
     * @param benefitType the benefitType value to set.
     * @return the IncludedQuantityUtilizationSummary object itself.
     */
    public IncludedQuantityUtilizationSummary withBenefitType(BenefitKind benefitType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IncludedQuantityUtilizationSummaryProperties();
        }
        this.innerProperties().withBenefitType(benefitType);
        return this;
    }

    /**
     * Get the usageDate property: Date corresponding to the utilization summary record. If the grain of data is
     * monthly, value for this field will be first day of the month.
     *
     * @return the usageDate value.
     */
    public OffsetDateTime usageDate() {
        return this.innerProperties() == null ? null : this.innerProperties().usageDate();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
