// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Each KPI must contain a 'type' and 'enabled' key. */
@Fluent
public final class KpiProperties {
    /*
     * KPI type (Forecast, Budget).
     */
    @JsonProperty(value = "type")
    private KpiType type;

    /*
     * ID of resource related to metric (budget).
     */
    @JsonProperty(value = "id")
    private String id;

    /*
     * show the KPI in the UI?
     */
    @JsonProperty(value = "enabled")
    private Boolean enabled;

    /** Creates an instance of KpiProperties class. */
    public KpiProperties() {
    }

    /**
     * Get the type property: KPI type (Forecast, Budget).
     *
     * @return the type value.
     */
    public KpiType type() {
        return this.type;
    }

    /**
     * Set the type property: KPI type (Forecast, Budget).
     *
     * @param type the type value to set.
     * @return the KpiProperties object itself.
     */
    public KpiProperties withType(KpiType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the id property: ID of resource related to metric (budget).
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: ID of resource related to metric (budget).
     *
     * @param id the id value to set.
     * @return the KpiProperties object itself.
     */
    public KpiProperties withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the enabled property: show the KPI in the UI?.
     *
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: show the KPI in the UI?.
     *
     * @param enabled the enabled value to set.
     * @return the KpiProperties object itself.
     */
    public KpiProperties withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
