// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * The CSV file from the reportUrl blob link consists of reservation usage data with the following schema at daily
 * granularity.
 */
public final class ReservationReportSchema extends ExpandableStringEnum<ReservationReportSchema> {
    /** Static value InstanceFlexibilityGroup for ReservationReportSchema. */
    public static final ReservationReportSchema INSTANCE_FLEXIBILITY_GROUP = fromString("InstanceFlexibilityGroup");

    /** Static value InstanceFlexibilityRatio for ReservationReportSchema. */
    public static final ReservationReportSchema INSTANCE_FLEXIBILITY_RATIO = fromString("InstanceFlexibilityRatio");

    /** Static value InstanceId for ReservationReportSchema. */
    public static final ReservationReportSchema INSTANCE_ID = fromString("InstanceId");

    /** Static value Kind for ReservationReportSchema. */
    public static final ReservationReportSchema KIND = fromString("Kind");

    /** Static value ReservationId for ReservationReportSchema. */
    public static final ReservationReportSchema RESERVATION_ID = fromString("ReservationId");

    /** Static value ReservationOrderId for ReservationReportSchema. */
    public static final ReservationReportSchema RESERVATION_ORDER_ID = fromString("ReservationOrderId");

    /** Static value ReservedHours for ReservationReportSchema. */
    public static final ReservationReportSchema RESERVED_HOURS = fromString("ReservedHours");

    /** Static value SkuName for ReservationReportSchema. */
    public static final ReservationReportSchema SKU_NAME = fromString("SkuName");

    /** Static value TotalReservedQuantity for ReservationReportSchema. */
    public static final ReservationReportSchema TOTAL_RESERVED_QUANTITY = fromString("TotalReservedQuantity");

    /** Static value UsageDate for ReservationReportSchema. */
    public static final ReservationReportSchema USAGE_DATE = fromString("UsageDate");

    /** Static value UsedHours for ReservationReportSchema. */
    public static final ReservationReportSchema USED_HOURS = fromString("UsedHours");

    /**
     * Creates a new instance of ReservationReportSchema value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ReservationReportSchema() {
    }

    /**
     * Creates or finds a ReservationReportSchema from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding ReservationReportSchema.
     */
    @JsonCreator
    public static ReservationReportSchema fromString(String name) {
        return fromString(name, ReservationReportSchema.class);
    }

    /**
     * Gets known ReservationReportSchema values.
     *
     * @return known ReservationReportSchema values.
     */
    public static Collection<ReservationReportSchema> values() {
        return values(ReservationReportSchema.class);
    }
}
