// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The Resource model definition. */
@Fluent
public class ScheduledActionProxyResource extends ProxyResource {
    /*
     * Resource Etag. For update calls, eTag is optional and can be specified to achieve optimistic concurrency. Fetch
     * the resource's eTag by doing a 'GET' call first and then including the latest eTag as part of the request body
     * or 'If-Match' header while performing the update. For create calls, eTag is not required.
     */
    @JsonProperty(value = "eTag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /*
     * Kind of the scheduled action.
     */
    @JsonProperty(value = "kind")
    private ScheduledActionKind kind;

    /*
     * Kind of the scheduled action.
     */
    @JsonProperty(value = "systemData", access = JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    /** Creates an instance of ScheduledActionProxyResource class. */
    public ScheduledActionProxyResource() {
    }

    /**
     * Get the etag property: Resource Etag. For update calls, eTag is optional and can be specified to achieve
     * optimistic concurrency. Fetch the resource's eTag by doing a 'GET' call first and then including the latest eTag
     * as part of the request body or 'If-Match' header while performing the update. For create calls, eTag is not
     * required.
     *
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the kind property: Kind of the scheduled action.
     *
     * @return the kind value.
     */
    public ScheduledActionKind kind() {
        return this.kind;
    }

    /**
     * Set the kind property: Kind of the scheduled action.
     *
     * @param kind the kind value to set.
     * @return the ScheduledActionProxyResource object itself.
     */
    public ScheduledActionProxyResource withKind(ScheduledActionKind kind) {
        this.kind = kind;
        return this;
    }

    /**
     * Get the systemData property: Kind of the scheduled action.
     *
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
