// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.costmanagement.fluent.models.ScheduledActionInner;

/** Resource collection API of ScheduledActions. */
public interface ScheduledActions {
    /**
     * List all private scheduled actions.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scheduled actions list result as paginated response with {@link PagedIterable}.
     */
    PagedIterable<ScheduledAction> list();

    /**
     * List all private scheduled actions.
     *
     * @param filter May be used to filter scheduled actions by properties/viewId. Supported operator is 'eq'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scheduled actions list result as paginated response with {@link PagedIterable}.
     */
    PagedIterable<ScheduledAction> list(String filter, Context context);

    /**
     * List all shared scheduled actions within the given scope.
     *
     * @param scope The scope associated with scheduled action operations. This includes
     *     'subscriptions/{subscriptionId}' for subscription scope,
     *     'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department
     *     scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for
     *     EnrollmentAccount scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for
     *     BillingProfile scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for
     *     InvoiceSection scope,
     *     'providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for External
     *     Billing Account scope and
     *     'providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for External
     *     Subscription scope. Note: Insight Alerts are only available on subscription scope.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scheduled actions list result as paginated response with {@link PagedIterable}.
     */
    PagedIterable<ScheduledAction> listByScope(String scope);

    /**
     * List all shared scheduled actions within the given scope.
     *
     * @param scope The scope associated with scheduled action operations. This includes
     *     'subscriptions/{subscriptionId}' for subscription scope,
     *     'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department
     *     scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for
     *     EnrollmentAccount scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for
     *     BillingProfile scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for
     *     InvoiceSection scope,
     *     'providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for External
     *     Billing Account scope and
     *     'providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for External
     *     Subscription scope. Note: Insight Alerts are only available on subscription scope.
     * @param filter May be used to filter scheduled actions by properties/viewId. Supported operator is 'eq'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scheduled actions list result as paginated response with {@link PagedIterable}.
     */
    PagedIterable<ScheduledAction> listByScope(String scope, String filter, Context context);

    /**
     * Create or update a private scheduled action.
     *
     * @param name Scheduled action name.
     * @param scheduledAction Scheduled action to be created or updated.
     * @param ifMatch ETag of the Entity. Not required when creating an entity. Optional when updating an entity and can
     *     be specified to achieve optimistic concurrency.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scheduled action definition along with {@link Response}.
     */
    Response<ScheduledAction> createOrUpdateWithResponse(
        String name, ScheduledActionInner scheduledAction, String ifMatch, Context context);

    /**
     * Create or update a private scheduled action.
     *
     * @param name Scheduled action name.
     * @param scheduledAction Scheduled action to be created or updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scheduled action definition.
     */
    ScheduledAction createOrUpdate(String name, ScheduledActionInner scheduledAction);

    /**
     * Get the private scheduled action by name.
     *
     * @param name Scheduled action name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the private scheduled action by name along with {@link Response}.
     */
    Response<ScheduledAction> getWithResponse(String name, Context context);

    /**
     * Get the private scheduled action by name.
     *
     * @param name Scheduled action name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the private scheduled action by name.
     */
    ScheduledAction get(String name);

    /**
     * Delete a private scheduled action.
     *
     * @param name Scheduled action name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> deleteWithResponse(String name, Context context);

    /**
     * Delete a private scheduled action.
     *
     * @param name Scheduled action name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void delete(String name);

    /**
     * Get the shared scheduled action from the given scope by name.
     *
     * @param scope The scope associated with scheduled action operations. This includes
     *     'subscriptions/{subscriptionId}' for subscription scope,
     *     'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department
     *     scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for
     *     EnrollmentAccount scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for
     *     BillingProfile scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for
     *     InvoiceSection scope,
     *     'providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for External
     *     Billing Account scope and
     *     'providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for External
     *     Subscription scope. Note: Insight Alerts are only available on subscription scope.
     * @param name Scheduled action name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the shared scheduled action from the given scope by name along with {@link Response}.
     */
    Response<ScheduledAction> getByScopeWithResponse(String scope, String name, Context context);

    /**
     * Get the shared scheduled action from the given scope by name.
     *
     * @param scope The scope associated with scheduled action operations. This includes
     *     'subscriptions/{subscriptionId}' for subscription scope,
     *     'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department
     *     scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for
     *     EnrollmentAccount scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for
     *     BillingProfile scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for
     *     InvoiceSection scope,
     *     'providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for External
     *     Billing Account scope and
     *     'providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for External
     *     Subscription scope. Note: Insight Alerts are only available on subscription scope.
     * @param name Scheduled action name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the shared scheduled action from the given scope by name.
     */
    ScheduledAction getByScope(String scope, String name);

    /**
     * Delete a scheduled action within the given scope.
     *
     * @param scope The scope associated with scheduled action operations. This includes
     *     'subscriptions/{subscriptionId}' for subscription scope,
     *     'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department
     *     scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for
     *     EnrollmentAccount scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for
     *     BillingProfile scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for
     *     InvoiceSection scope,
     *     'providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for External
     *     Billing Account scope and
     *     'providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for External
     *     Subscription scope. Note: Insight Alerts are only available on subscription scope.
     * @param name Scheduled action name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> deleteByScopeWithResponse(String scope, String name, Context context);

    /**
     * Delete a scheduled action within the given scope.
     *
     * @param scope The scope associated with scheduled action operations. This includes
     *     'subscriptions/{subscriptionId}' for subscription scope,
     *     'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department
     *     scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for
     *     EnrollmentAccount scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for
     *     BillingProfile scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for
     *     InvoiceSection scope,
     *     'providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for External
     *     Billing Account scope and
     *     'providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for External
     *     Subscription scope. Note: Insight Alerts are only available on subscription scope.
     * @param name Scheduled action name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void deleteByScope(String scope, String name);

    /**
     * Processes a private scheduled action.
     *
     * @param name Scheduled action name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> runWithResponse(String name, Context context);

    /**
     * Processes a private scheduled action.
     *
     * @param name Scheduled action name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void run(String name);

    /**
     * Runs a shared scheduled action within the given scope.
     *
     * @param scope The scope associated with scheduled action operations. This includes
     *     'subscriptions/{subscriptionId}' for subscription scope,
     *     'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department
     *     scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for
     *     EnrollmentAccount scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for
     *     BillingProfile scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for
     *     InvoiceSection scope,
     *     'providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for External
     *     Billing Account scope and
     *     'providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for External
     *     Subscription scope. Note: Insight Alerts are only available on subscription scope.
     * @param name Scheduled action name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> runByScopeWithResponse(String scope, String name, Context context);

    /**
     * Runs a shared scheduled action within the given scope.
     *
     * @param scope The scope associated with scheduled action operations. This includes
     *     'subscriptions/{subscriptionId}' for subscription scope,
     *     'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department
     *     scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for
     *     EnrollmentAccount scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for
     *     BillingProfile scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for
     *     InvoiceSection scope,
     *     'providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for External
     *     Billing Account scope and
     *     'providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for External
     *     Subscription scope. Note: Insight Alerts are only available on subscription scope.
     * @param name Scheduled action name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void runByScope(String scope, String name);

    /**
     * Checks availability and correctness of the name for a scheduled action.
     *
     * @param checkNameAvailabilityRequest Scheduled action to be created or updated.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the check availability result along with {@link Response}.
     */
    Response<CheckNameAvailabilityResponse> checkNameAvailabilityWithResponse(
        CheckNameAvailabilityRequest checkNameAvailabilityRequest, Context context);

    /**
     * Checks availability and correctness of the name for a scheduled action.
     *
     * @param checkNameAvailabilityRequest Scheduled action to be created or updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the check availability result.
     */
    CheckNameAvailabilityResponse checkNameAvailability(CheckNameAvailabilityRequest checkNameAvailabilityRequest);

    /**
     * Checks availability and correctness of the name for a scheduled action within the given scope.
     *
     * @param scope The scope associated with scheduled action operations. This includes
     *     'subscriptions/{subscriptionId}' for subscription scope,
     *     'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department
     *     scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for
     *     EnrollmentAccount scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for
     *     BillingProfile scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for
     *     InvoiceSection scope,
     *     'providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for External
     *     Billing Account scope and
     *     'providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for External
     *     Subscription scope. Note: Insight Alerts are only available on subscription scope.
     * @param checkNameAvailabilityRequest Scheduled action to be created or updated.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the check availability result along with {@link Response}.
     */
    Response<CheckNameAvailabilityResponse> checkNameAvailabilityByScopeWithResponse(
        String scope, CheckNameAvailabilityRequest checkNameAvailabilityRequest, Context context);

    /**
     * Checks availability and correctness of the name for a scheduled action within the given scope.
     *
     * @param scope The scope associated with scheduled action operations. This includes
     *     'subscriptions/{subscriptionId}' for subscription scope,
     *     'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department
     *     scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for
     *     EnrollmentAccount scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for
     *     BillingProfile scope,
     *     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for
     *     InvoiceSection scope,
     *     'providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for External
     *     Billing Account scope and
     *     'providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for External
     *     Subscription scope. Note: Insight Alerts are only available on subscription scope.
     * @param checkNameAvailabilityRequest Scheduled action to be created or updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the check availability result.
     */
    CheckNameAvailabilityResponse checkNameAvailabilityByScope(
        String scope, CheckNameAvailabilityRequest checkNameAvailabilityRequest);

    /**
     * Get the shared scheduled action from the given scope by name.
     *
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the shared scheduled action from the given scope by name along with {@link Response}.
     */
    ScheduledAction getById(String id);

    /**
     * Get the shared scheduled action from the given scope by name.
     *
     * @param id the resource ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the shared scheduled action from the given scope by name along with {@link Response}.
     */
    Response<ScheduledAction> getByIdWithResponse(String id, Context context);

    /**
     * Delete a scheduled action within the given scope.
     *
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void deleteById(String id);

    /**
     * Delete a scheduled action within the given scope.
     *
     * @param id the resource ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> deleteByIdWithResponse(String id, Context context);

    /**
     * Begins definition for a new ScheduledAction resource.
     *
     * @param name resource name.
     * @return the first stage of the new ScheduledAction definition.
     */
    ScheduledAction.DefinitionStages.Blank define(String name);
}
