// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Immutable;
import com.azure.resourcemanager.costmanagement.fluent.models.ViewInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Result of listing views. It contains a list of available views. */
@Immutable
public final class ViewListResult {
    /*
     * The list of views.
     */
    @JsonProperty(value = "value", access = JsonProperty.Access.WRITE_ONLY)
    private List<ViewInner> value;

    /*
     * The link (url) to the next page of results.
     */
    @JsonProperty(value = "nextLink", access = JsonProperty.Access.WRITE_ONLY)
    private String nextLink;

    /** Creates an instance of ViewListResult class. */
    public ViewListResult() {
    }

    /**
     * Get the value property: The list of views.
     *
     * @return the value value.
     */
    public List<ViewInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: The link (url) to the next page of results.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
