// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.AlertPropertiesDefinition;
import com.azure.resourcemanager.costmanagement.models.AlertPropertiesDetails;
import com.azure.resourcemanager.costmanagement.models.AlertSource;
import com.azure.resourcemanager.costmanagement.models.AlertStatus;
import java.io.IOException;

/**
 * Alert properties.
 */
@Fluent
public final class AlertProperties implements JsonSerializable<AlertProperties> {
    /*
     * defines the type of alert
     */
    private AlertPropertiesDefinition definition;

    /*
     * Alert description
     */
    private String description;

    /*
     * Source of alert
     */
    private AlertSource source;

    /*
     * Alert details
     */
    private AlertPropertiesDetails details;

    /*
     * related budget
     */
    private String costEntityId;

    /*
     * alert status
     */
    private AlertStatus status;

    /*
     * dateTime in which alert was created
     */
    private String creationTime;

    /*
     * dateTime in which alert was closed
     */
    private String closeTime;

    /*
     * dateTime in which alert was last modified
     */
    private String modificationTime;

    /*
     * User who last modified the alert
     */
    private String statusModificationUsername;

    /*
     * dateTime in which the alert status was last modified
     */
    private String statusModificationTime;

    /**
     * Creates an instance of AlertProperties class.
     */
    public AlertProperties() {
    }

    /**
     * Get the definition property: defines the type of alert.
     * 
     * @return the definition value.
     */
    public AlertPropertiesDefinition definition() {
        return this.definition;
    }

    /**
     * Set the definition property: defines the type of alert.
     * 
     * @param definition the definition value to set.
     * @return the AlertProperties object itself.
     */
    public AlertProperties withDefinition(AlertPropertiesDefinition definition) {
        this.definition = definition;
        return this;
    }

    /**
     * Get the description property: Alert description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Alert description.
     * 
     * @param description the description value to set.
     * @return the AlertProperties object itself.
     */
    public AlertProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the source property: Source of alert.
     * 
     * @return the source value.
     */
    public AlertSource source() {
        return this.source;
    }

    /**
     * Set the source property: Source of alert.
     * 
     * @param source the source value to set.
     * @return the AlertProperties object itself.
     */
    public AlertProperties withSource(AlertSource source) {
        this.source = source;
        return this;
    }

    /**
     * Get the details property: Alert details.
     * 
     * @return the details value.
     */
    public AlertPropertiesDetails details() {
        return this.details;
    }

    /**
     * Set the details property: Alert details.
     * 
     * @param details the details value to set.
     * @return the AlertProperties object itself.
     */
    public AlertProperties withDetails(AlertPropertiesDetails details) {
        this.details = details;
        return this;
    }

    /**
     * Get the costEntityId property: related budget.
     * 
     * @return the costEntityId value.
     */
    public String costEntityId() {
        return this.costEntityId;
    }

    /**
     * Set the costEntityId property: related budget.
     * 
     * @param costEntityId the costEntityId value to set.
     * @return the AlertProperties object itself.
     */
    public AlertProperties withCostEntityId(String costEntityId) {
        this.costEntityId = costEntityId;
        return this;
    }

    /**
     * Get the status property: alert status.
     * 
     * @return the status value.
     */
    public AlertStatus status() {
        return this.status;
    }

    /**
     * Set the status property: alert status.
     * 
     * @param status the status value to set.
     * @return the AlertProperties object itself.
     */
    public AlertProperties withStatus(AlertStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the creationTime property: dateTime in which alert was created.
     * 
     * @return the creationTime value.
     */
    public String creationTime() {
        return this.creationTime;
    }

    /**
     * Set the creationTime property: dateTime in which alert was created.
     * 
     * @param creationTime the creationTime value to set.
     * @return the AlertProperties object itself.
     */
    public AlertProperties withCreationTime(String creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    /**
     * Get the closeTime property: dateTime in which alert was closed.
     * 
     * @return the closeTime value.
     */
    public String closeTime() {
        return this.closeTime;
    }

    /**
     * Set the closeTime property: dateTime in which alert was closed.
     * 
     * @param closeTime the closeTime value to set.
     * @return the AlertProperties object itself.
     */
    public AlertProperties withCloseTime(String closeTime) {
        this.closeTime = closeTime;
        return this;
    }

    /**
     * Get the modificationTime property: dateTime in which alert was last modified.
     * 
     * @return the modificationTime value.
     */
    public String modificationTime() {
        return this.modificationTime;
    }

    /**
     * Set the modificationTime property: dateTime in which alert was last modified.
     * 
     * @param modificationTime the modificationTime value to set.
     * @return the AlertProperties object itself.
     */
    public AlertProperties withModificationTime(String modificationTime) {
        this.modificationTime = modificationTime;
        return this;
    }

    /**
     * Get the statusModificationUsername property: User who last modified the alert.
     * 
     * @return the statusModificationUsername value.
     */
    public String statusModificationUsername() {
        return this.statusModificationUsername;
    }

    /**
     * Set the statusModificationUsername property: User who last modified the alert.
     * 
     * @param statusModificationUsername the statusModificationUsername value to set.
     * @return the AlertProperties object itself.
     */
    public AlertProperties withStatusModificationUsername(String statusModificationUsername) {
        this.statusModificationUsername = statusModificationUsername;
        return this;
    }

    /**
     * Get the statusModificationTime property: dateTime in which the alert status was last modified.
     * 
     * @return the statusModificationTime value.
     */
    public String statusModificationTime() {
        return this.statusModificationTime;
    }

    /**
     * Set the statusModificationTime property: dateTime in which the alert status was last modified.
     * 
     * @param statusModificationTime the statusModificationTime value to set.
     * @return the AlertProperties object itself.
     */
    public AlertProperties withStatusModificationTime(String statusModificationTime) {
        this.statusModificationTime = statusModificationTime;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (definition() != null) {
            definition().validate();
        }
        if (details() != null) {
            details().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("definition", this.definition);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("source", this.source == null ? null : this.source.toString());
        jsonWriter.writeJsonField("details", this.details);
        jsonWriter.writeStringField("costEntityId", this.costEntityId);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("creationTime", this.creationTime);
        jsonWriter.writeStringField("closeTime", this.closeTime);
        jsonWriter.writeStringField("modificationTime", this.modificationTime);
        jsonWriter.writeStringField("statusModificationUserName", this.statusModificationUsername);
        jsonWriter.writeStringField("statusModificationTime", this.statusModificationTime);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AlertProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AlertProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the AlertProperties.
     */
    public static AlertProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AlertProperties deserializedAlertProperties = new AlertProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("definition".equals(fieldName)) {
                    deserializedAlertProperties.definition = AlertPropertiesDefinition.fromJson(reader);
                } else if ("description".equals(fieldName)) {
                    deserializedAlertProperties.description = reader.getString();
                } else if ("source".equals(fieldName)) {
                    deserializedAlertProperties.source = AlertSource.fromString(reader.getString());
                } else if ("details".equals(fieldName)) {
                    deserializedAlertProperties.details = AlertPropertiesDetails.fromJson(reader);
                } else if ("costEntityId".equals(fieldName)) {
                    deserializedAlertProperties.costEntityId = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedAlertProperties.status = AlertStatus.fromString(reader.getString());
                } else if ("creationTime".equals(fieldName)) {
                    deserializedAlertProperties.creationTime = reader.getString();
                } else if ("closeTime".equals(fieldName)) {
                    deserializedAlertProperties.closeTime = reader.getString();
                } else if ("modificationTime".equals(fieldName)) {
                    deserializedAlertProperties.modificationTime = reader.getString();
                } else if ("statusModificationUserName".equals(fieldName)) {
                    deserializedAlertProperties.statusModificationUsername = reader.getString();
                } else if ("statusModificationTime".equals(fieldName)) {
                    deserializedAlertProperties.statusModificationTime = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAlertProperties;
        });
    }
}
