// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Result of alerts.
 */
@Immutable
public final class AlertsResultInner implements JsonSerializable<AlertsResultInner> {
    /*
     * List of alerts.
     */
    private List<AlertInner> value;

    /*
     * URL to get the next set of alerts results if there are any.
     */
    private String nextLink;

    /**
     * Creates an instance of AlertsResultInner class.
     */
    public AlertsResultInner() {
    }

    /**
     * Get the value property: List of alerts.
     * 
     * @return the value value.
     */
    public List<AlertInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: URL to get the next set of alerts results if there are any.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AlertsResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AlertsResultInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the AlertsResultInner.
     */
    public static AlertsResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AlertsResultInner deserializedAlertsResultInner = new AlertsResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<AlertInner> value = reader.readArray(reader1 -> AlertInner.fromJson(reader1));
                    deserializedAlertsResultInner.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedAlertsResultInner.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAlertsResultInner;
        });
    }
}
