// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.BenefitKind;
import com.azure.resourcemanager.costmanagement.models.IncludedQuantityUtilizationSummary;
import com.azure.resourcemanager.costmanagement.models.SavingsPlanUtilizationSummary;
import java.io.IOException;

/**
 * Benefit utilization summary resource.
 */
@Immutable
public class BenefitUtilizationSummaryInner extends ProxyResource {
    /*
     * Supported values: 'SavingsPlan'.
     */
    private BenefitKind kind = BenefitKind.fromString("BenefitUtilizationSummary");

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of BenefitUtilizationSummaryInner class.
     */
    public BenefitUtilizationSummaryInner() {
    }

    /**
     * Get the kind property: Supported values: 'SavingsPlan'.
     * 
     * @return the kind value.
     */
    public BenefitKind kind() {
        return this.kind;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BenefitUtilizationSummaryInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BenefitUtilizationSummaryInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the BenefitUtilizationSummaryInner.
     */
    public static BenefitUtilizationSummaryInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                readerToUse.nextToken(); // Prepare for reading
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("kind".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("IncludedQuantity".equals(discriminatorValue)) {
                    return IncludedQuantityUtilizationSummary.fromJson(readerToUse.reset());
                } else if ("SavingsPlan".equals(discriminatorValue)) {
                    return SavingsPlanUtilizationSummary.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    static BenefitUtilizationSummaryInner fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BenefitUtilizationSummaryInner deserializedBenefitUtilizationSummaryInner
                = new BenefitUtilizationSummaryInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedBenefitUtilizationSummaryInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedBenefitUtilizationSummaryInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedBenefitUtilizationSummaryInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedBenefitUtilizationSummaryInner.kind = BenefitKind.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBenefitUtilizationSummaryInner;
        });
    }
}
