// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.BlobInfo;
import com.azure.resourcemanager.costmanagement.models.CostDetailsDataFormat;
import com.azure.resourcemanager.costmanagement.models.CostDetailsStatusType;
import com.azure.resourcemanager.costmanagement.models.GenerateCostDetailsReportRequestDefinition;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * The result of the long running operation for cost details Api.
 */
@Fluent
public final class CostDetailsOperationResultsInner implements JsonSerializable<CostDetailsOperationResultsInner> {
    /*
     * The id of the long running operation.
     */
    private String id;

    /*
     * The name of the long running operation.
     */
    private String name;

    /*
     * The type of the long running operation.
     */
    private String type;

    /*
     * The status of the cost details operation
     */
    private CostDetailsStatusType status;

    /*
     * The manifest of the report generated by the operation.
     */
    private ReportManifest innerManifest;

    /*
     * The time at which report URL becomes invalid/expires in UTC e.g. 2020-12-08T05:55:59.4394737Z.
     */
    private OffsetDateTime validTill;

    /*
     * The details of the error.
     */
    private ManagementError error;

    /**
     * Creates an instance of CostDetailsOperationResultsInner class.
     */
    public CostDetailsOperationResultsInner() {
    }

    /**
     * Get the id property: The id of the long running operation.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The id of the long running operation.
     * 
     * @param id the id value to set.
     * @return the CostDetailsOperationResultsInner object itself.
     */
    public CostDetailsOperationResultsInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name property: The name of the long running operation.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the long running operation.
     * 
     * @param name the name value to set.
     * @return the CostDetailsOperationResultsInner object itself.
     */
    public CostDetailsOperationResultsInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: The type of the long running operation.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: The type of the long running operation.
     * 
     * @param type the type value to set.
     * @return the CostDetailsOperationResultsInner object itself.
     */
    public CostDetailsOperationResultsInner withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the status property: The status of the cost details operation.
     * 
     * @return the status value.
     */
    public CostDetailsStatusType status() {
        return this.status;
    }

    /**
     * Set the status property: The status of the cost details operation.
     * 
     * @param status the status value to set.
     * @return the CostDetailsOperationResultsInner object itself.
     */
    public CostDetailsOperationResultsInner withStatus(CostDetailsStatusType status) {
        this.status = status;
        return this;
    }

    /**
     * Get the innerManifest property: The manifest of the report generated by the operation.
     * 
     * @return the innerManifest value.
     */
    private ReportManifest innerManifest() {
        return this.innerManifest;
    }

    /**
     * Get the validTill property: The time at which report URL becomes invalid/expires in UTC e.g.
     * 2020-12-08T05:55:59.4394737Z.
     * 
     * @return the validTill value.
     */
    public OffsetDateTime validTill() {
        return this.validTill;
    }

    /**
     * Set the validTill property: The time at which report URL becomes invalid/expires in UTC e.g.
     * 2020-12-08T05:55:59.4394737Z.
     * 
     * @param validTill the validTill value to set.
     * @return the CostDetailsOperationResultsInner object itself.
     */
    public CostDetailsOperationResultsInner withValidTill(OffsetDateTime validTill) {
        this.validTill = validTill;
        return this;
    }

    /**
     * Get the error property: The details of the error.
     * 
     * @return the error value.
     */
    public ManagementError error() {
        return this.error;
    }

    /**
     * Set the error property: The details of the error.
     * 
     * @param error the error value to set.
     * @return the CostDetailsOperationResultsInner object itself.
     */
    public CostDetailsOperationResultsInner withError(ManagementError error) {
        this.error = error;
        return this;
    }

    /**
     * Get the manifestVersion property: The Manifest version.
     * 
     * @return the manifestVersion value.
     */
    public String manifestVersion() {
        return this.innerManifest() == null ? null : this.innerManifest().manifestVersion();
    }

    /**
     * Set the manifestVersion property: The Manifest version.
     * 
     * @param manifestVersion the manifestVersion value to set.
     * @return the CostDetailsOperationResultsInner object itself.
     */
    public CostDetailsOperationResultsInner withManifestVersion(String manifestVersion) {
        if (this.innerManifest() == null) {
            this.innerManifest = new ReportManifest();
        }
        this.innerManifest().withManifestVersion(manifestVersion);
        return this;
    }

    /**
     * Get the dataFormat property: The data format of the report.
     * 
     * @return the dataFormat value.
     */
    public CostDetailsDataFormat dataFormat() {
        return this.innerManifest() == null ? null : this.innerManifest().dataFormat();
    }

    /**
     * Set the dataFormat property: The data format of the report.
     * 
     * @param dataFormat the dataFormat value to set.
     * @return the CostDetailsOperationResultsInner object itself.
     */
    public CostDetailsOperationResultsInner withDataFormat(CostDetailsDataFormat dataFormat) {
        if (this.innerManifest() == null) {
            this.innerManifest = new ReportManifest();
        }
        this.innerManifest().withDataFormat(dataFormat);
        return this;
    }

    /**
     * Get the byteCount property: The total number of bytes in all blobs.
     * 
     * @return the byteCount value.
     */
    public Long byteCount() {
        return this.innerManifest() == null ? null : this.innerManifest().byteCount();
    }

    /**
     * Set the byteCount property: The total number of bytes in all blobs.
     * 
     * @param byteCount the byteCount value to set.
     * @return the CostDetailsOperationResultsInner object itself.
     */
    public CostDetailsOperationResultsInner withByteCount(Long byteCount) {
        if (this.innerManifest() == null) {
            this.innerManifest = new ReportManifest();
        }
        this.innerManifest().withByteCount(byteCount);
        return this;
    }

    /**
     * Get the blobCount property: The total number of blobs.
     * 
     * @return the blobCount value.
     */
    public Integer blobCount() {
        return this.innerManifest() == null ? null : this.innerManifest().blobCount();
    }

    /**
     * Set the blobCount property: The total number of blobs.
     * 
     * @param blobCount the blobCount value to set.
     * @return the CostDetailsOperationResultsInner object itself.
     */
    public CostDetailsOperationResultsInner withBlobCount(Integer blobCount) {
        if (this.innerManifest() == null) {
            this.innerManifest = new ReportManifest();
        }
        this.innerManifest().withBlobCount(blobCount);
        return this;
    }

    /**
     * Get the compressData property: Is the data in compressed format.
     * 
     * @return the compressData value.
     */
    public Boolean compressData() {
        return this.innerManifest() == null ? null : this.innerManifest().compressData();
    }

    /**
     * Set the compressData property: Is the data in compressed format.
     * 
     * @param compressData the compressData value to set.
     * @return the CostDetailsOperationResultsInner object itself.
     */
    public CostDetailsOperationResultsInner withCompressData(Boolean compressData) {
        if (this.innerManifest() == null) {
            this.innerManifest = new ReportManifest();
        }
        this.innerManifest().withCompressData(compressData);
        return this;
    }

    /**
     * Get the blobs property: List of blob information generated by this operation.
     * 
     * @return the blobs value.
     */
    public List<BlobInfo> blobs() {
        return this.innerManifest() == null ? null : this.innerManifest().blobs();
    }

    /**
     * Set the blobs property: List of blob information generated by this operation.
     * 
     * @param blobs the blobs value to set.
     * @return the CostDetailsOperationResultsInner object itself.
     */
    public CostDetailsOperationResultsInner withBlobs(List<BlobInfo> blobs) {
        if (this.innerManifest() == null) {
            this.innerManifest = new ReportManifest();
        }
        this.innerManifest().withBlobs(blobs);
        return this;
    }

    /**
     * Get the requestScope property: The request scope of the request.
     * 
     * @return the requestScope value.
     */
    public String requestScope() {
        return this.innerManifest() == null ? null : this.innerManifest().requestScope();
    }

    /**
     * Set the requestScope property: The request scope of the request.
     * 
     * @param requestScope the requestScope value to set.
     * @return the CostDetailsOperationResultsInner object itself.
     */
    public CostDetailsOperationResultsInner withRequestScope(String requestScope) {
        if (this.innerManifest() == null) {
            this.innerManifest = new ReportManifest();
        }
        this.innerManifest().withRequestScope(requestScope);
        return this;
    }

    /**
     * Get the requestBody property: The request payload body provided in Cost Details call.
     * 
     * @return the requestBody value.
     */
    public GenerateCostDetailsReportRequestDefinition requestBody() {
        return this.innerManifest() == null ? null : this.innerManifest().requestBody();
    }

    /**
     * Set the requestBody property: The request payload body provided in Cost Details call.
     * 
     * @param requestBody the requestBody value to set.
     * @return the CostDetailsOperationResultsInner object itself.
     */
    public CostDetailsOperationResultsInner withRequestBody(GenerateCostDetailsReportRequestDefinition requestBody) {
        if (this.innerManifest() == null) {
            this.innerManifest = new ReportManifest();
        }
        this.innerManifest().withRequestBody(requestBody);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerManifest() != null) {
            innerManifest().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeJsonField("manifest", this.innerManifest);
        jsonWriter.writeStringField("validTill",
            this.validTill == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.validTill));
        jsonWriter.writeJsonField("error", this.error);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CostDetailsOperationResultsInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CostDetailsOperationResultsInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CostDetailsOperationResultsInner.
     */
    public static CostDetailsOperationResultsInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CostDetailsOperationResultsInner deserializedCostDetailsOperationResultsInner
                = new CostDetailsOperationResultsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedCostDetailsOperationResultsInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedCostDetailsOperationResultsInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedCostDetailsOperationResultsInner.type = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedCostDetailsOperationResultsInner.status
                        = CostDetailsStatusType.fromString(reader.getString());
                } else if ("manifest".equals(fieldName)) {
                    deserializedCostDetailsOperationResultsInner.innerManifest = ReportManifest.fromJson(reader);
                } else if ("validTill".equals(fieldName)) {
                    deserializedCostDetailsOperationResultsInner.validTill = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("error".equals(fieldName)) {
                    deserializedCostDetailsOperationResultsInner.error = ManagementError.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCostDetailsOperationResultsInner;
        });
    }
}
