// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.CostManagementResource;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

/**
 * List of Dimension.
 */
@Fluent
public final class DimensionInner extends CostManagementResource {
    /*
     * Dimension properties.
     */
    private DimensionProperties innerProperties;

    /*
     * ETag of the resource.
     */
    private String etag;

    /*
     * SKU of the resource.
     */
    private String sku;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of DimensionInner class.
     */
    public DimensionInner() {
    }

    /**
     * Get the innerProperties property: Dimension properties.
     * 
     * @return the innerProperties value.
     */
    private DimensionProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the etag property: ETag of the resource.
     * 
     * @return the etag value.
     */
    @Override
    public String etag() {
        return this.etag;
    }

    /**
     * Get the sku property: SKU of the resource.
     * 
     * @return the sku value.
     */
    @Override
    public String sku() {
        return this.sku;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DimensionInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DimensionInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the description property: Dimension description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Get the filterEnabled property: Filter enabled.
     * 
     * @return the filterEnabled value.
     */
    public Boolean filterEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().filterEnabled();
    }

    /**
     * Get the groupingEnabled property: Grouping enabled.
     * 
     * @return the groupingEnabled value.
     */
    public Boolean groupingEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().groupingEnabled();
    }

    /**
     * Get the data property: Dimension data.
     * 
     * @return the data value.
     */
    public List<String> data() {
        return this.innerProperties() == null ? null : this.innerProperties().data();
    }

    /**
     * Set the data property: Dimension data.
     * 
     * @param data the data value to set.
     * @return the DimensionInner object itself.
     */
    public DimensionInner withData(List<String> data) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DimensionProperties();
        }
        this.innerProperties().withData(data);
        return this;
    }

    /**
     * Get the total property: Total number of data for the dimension.
     * 
     * @return the total value.
     */
    public Integer total() {
        return this.innerProperties() == null ? null : this.innerProperties().total();
    }

    /**
     * Get the category property: Dimension category.
     * 
     * @return the category value.
     */
    public String category() {
        return this.innerProperties() == null ? null : this.innerProperties().category();
    }

    /**
     * Get the usageStart property: Usage start.
     * 
     * @return the usageStart value.
     */
    public OffsetDateTime usageStart() {
        return this.innerProperties() == null ? null : this.innerProperties().usageStart();
    }

    /**
     * Get the usageEnd property: Usage end.
     * 
     * @return the usageEnd value.
     */
    public OffsetDateTime usageEnd() {
        return this.innerProperties() == null ? null : this.innerProperties().usageEnd();
    }

    /**
     * Get the nextLink property: The link (url) to the next page of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.innerProperties() == null ? null : this.innerProperties().nextLink();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DimensionInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DimensionInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DimensionInner.
     */
    public static DimensionInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DimensionInner deserializedDimensionInner = new DimensionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedDimensionInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedDimensionInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedDimensionInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedDimensionInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDimensionInner.withTags(tags);
                } else if ("sku".equals(fieldName)) {
                    deserializedDimensionInner.sku = reader.getString();
                } else if ("eTag".equals(fieldName)) {
                    deserializedDimensionInner.etag = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedDimensionInner.innerProperties = DimensionProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDimensionInner;
        });
    }
}
