// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * The URL to download the generated report.
 */
@Fluent
public final class DownloadUrlInner implements JsonSerializable<DownloadUrlInner> {
    /*
     * The time at which report URL becomes invalid/expires in UTC e.g. 2020-12-08T05:55:59.4394737Z.
     */
    private OffsetDateTime expiryTime;

    /*
     * The time at which report URL becomes invalid/expires in UTC e.g. 2020-12-08T05:55:59.4394737Z.
     */
    private OffsetDateTime validTill;

    /*
     * The URL to download the generated report.
     */
    private String downloadUrl;

    /**
     * Creates an instance of DownloadUrlInner class.
     */
    public DownloadUrlInner() {
    }

    /**
     * Get the expiryTime property: The time at which report URL becomes invalid/expires in UTC e.g.
     * 2020-12-08T05:55:59.4394737Z.
     * 
     * @return the expiryTime value.
     */
    public OffsetDateTime expiryTime() {
        return this.expiryTime;
    }

    /**
     * Get the validTill property: The time at which report URL becomes invalid/expires in UTC e.g.
     * 2020-12-08T05:55:59.4394737Z.
     * 
     * @return the validTill value.
     */
    public OffsetDateTime validTill() {
        return this.validTill;
    }

    /**
     * Set the validTill property: The time at which report URL becomes invalid/expires in UTC e.g.
     * 2020-12-08T05:55:59.4394737Z.
     * 
     * @param validTill the validTill value to set.
     * @return the DownloadUrlInner object itself.
     */
    public DownloadUrlInner withValidTill(OffsetDateTime validTill) {
        this.validTill = validTill;
        return this;
    }

    /**
     * Get the downloadUrl property: The URL to download the generated report.
     * 
     * @return the downloadUrl value.
     */
    public String downloadUrl() {
        return this.downloadUrl;
    }

    /**
     * Set the downloadUrl property: The URL to download the generated report.
     * 
     * @param downloadUrl the downloadUrl value to set.
     * @return the DownloadUrlInner object itself.
     */
    public DownloadUrlInner withDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("validTill",
            this.validTill == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.validTill));
        jsonWriter.writeStringField("downloadUrl", this.downloadUrl);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DownloadUrlInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DownloadUrlInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the DownloadUrlInner.
     */
    public static DownloadUrlInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DownloadUrlInner deserializedDownloadUrlInner = new DownloadUrlInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("expiryTime".equals(fieldName)) {
                    deserializedDownloadUrlInner.expiryTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("validTill".equals(fieldName)) {
                    deserializedDownloadUrlInner.validTill = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("downloadUrl".equals(fieldName)) {
                    deserializedDownloadUrlInner.downloadUrl = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDownloadUrlInner;
        });
    }
}
