// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Result of listing the run history of an export.
 */
@Immutable
public final class ExportExecutionListResultInner implements JsonSerializable<ExportExecutionListResultInner> {
    /*
     * A list of export runs.
     */
    private List<ExportRunInner> value;

    /**
     * Creates an instance of ExportExecutionListResultInner class.
     */
    public ExportExecutionListResultInner() {
    }

    /**
     * Get the value property: A list of export runs.
     * 
     * @return the value value.
     */
    public List<ExportRunInner> value() {
        return this.value;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExportExecutionListResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExportExecutionListResultInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExportExecutionListResultInner.
     */
    public static ExportExecutionListResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExportExecutionListResultInner deserializedExportExecutionListResultInner
                = new ExportExecutionListResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ExportRunInner> value = reader.readArray(reader1 -> ExportRunInner.fromJson(reader1));
                    deserializedExportExecutionListResultInner.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExportExecutionListResultInner;
        });
    }
}
