// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.ExecutionStatus;
import com.azure.resourcemanager.costmanagement.models.ExecutionType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * The properties of the export run.
 */
@Fluent
public final class ExportRunPropertiesInner implements JsonSerializable<ExportRunPropertiesInner> {
    /*
     * The type of the export run.
     */
    private ExecutionType executionType;

    /*
     * The last known status of the export run.
     */
    private ExecutionStatus status;

    /*
     * The identifier for the entity that triggered the export. For on-demand runs it is the user email. For scheduled
     * runs it is 'System'.
     */
    private String submittedBy;

    /*
     * The time when export was queued to be run.
     */
    private OffsetDateTime submittedTime;

    /*
     * The time when export was picked up to be run.
     */
    private OffsetDateTime processingStartTime;

    /*
     * The time when the export run finished.
     */
    private OffsetDateTime processingEndTime;

    /*
     * The name of the exported file.
     */
    private String fileName;

    /*
     * The export settings that were in effect for this run.
     */
    private CommonExportPropertiesInner runSettings;

    /*
     * The details of any error.
     */
    private ManagementError error;

    /**
     * Creates an instance of ExportRunPropertiesInner class.
     */
    public ExportRunPropertiesInner() {
    }

    /**
     * Get the executionType property: The type of the export run.
     * 
     * @return the executionType value.
     */
    public ExecutionType executionType() {
        return this.executionType;
    }

    /**
     * Set the executionType property: The type of the export run.
     * 
     * @param executionType the executionType value to set.
     * @return the ExportRunPropertiesInner object itself.
     */
    public ExportRunPropertiesInner withExecutionType(ExecutionType executionType) {
        this.executionType = executionType;
        return this;
    }

    /**
     * Get the status property: The last known status of the export run.
     * 
     * @return the status value.
     */
    public ExecutionStatus status() {
        return this.status;
    }

    /**
     * Set the status property: The last known status of the export run.
     * 
     * @param status the status value to set.
     * @return the ExportRunPropertiesInner object itself.
     */
    public ExportRunPropertiesInner withStatus(ExecutionStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the submittedBy property: The identifier for the entity that triggered the export. For on-demand runs it is
     * the user email. For scheduled runs it is 'System'.
     * 
     * @return the submittedBy value.
     */
    public String submittedBy() {
        return this.submittedBy;
    }

    /**
     * Set the submittedBy property: The identifier for the entity that triggered the export. For on-demand runs it is
     * the user email. For scheduled runs it is 'System'.
     * 
     * @param submittedBy the submittedBy value to set.
     * @return the ExportRunPropertiesInner object itself.
     */
    public ExportRunPropertiesInner withSubmittedBy(String submittedBy) {
        this.submittedBy = submittedBy;
        return this;
    }

    /**
     * Get the submittedTime property: The time when export was queued to be run.
     * 
     * @return the submittedTime value.
     */
    public OffsetDateTime submittedTime() {
        return this.submittedTime;
    }

    /**
     * Set the submittedTime property: The time when export was queued to be run.
     * 
     * @param submittedTime the submittedTime value to set.
     * @return the ExportRunPropertiesInner object itself.
     */
    public ExportRunPropertiesInner withSubmittedTime(OffsetDateTime submittedTime) {
        this.submittedTime = submittedTime;
        return this;
    }

    /**
     * Get the processingStartTime property: The time when export was picked up to be run.
     * 
     * @return the processingStartTime value.
     */
    public OffsetDateTime processingStartTime() {
        return this.processingStartTime;
    }

    /**
     * Set the processingStartTime property: The time when export was picked up to be run.
     * 
     * @param processingStartTime the processingStartTime value to set.
     * @return the ExportRunPropertiesInner object itself.
     */
    public ExportRunPropertiesInner withProcessingStartTime(OffsetDateTime processingStartTime) {
        this.processingStartTime = processingStartTime;
        return this;
    }

    /**
     * Get the processingEndTime property: The time when the export run finished.
     * 
     * @return the processingEndTime value.
     */
    public OffsetDateTime processingEndTime() {
        return this.processingEndTime;
    }

    /**
     * Set the processingEndTime property: The time when the export run finished.
     * 
     * @param processingEndTime the processingEndTime value to set.
     * @return the ExportRunPropertiesInner object itself.
     */
    public ExportRunPropertiesInner withProcessingEndTime(OffsetDateTime processingEndTime) {
        this.processingEndTime = processingEndTime;
        return this;
    }

    /**
     * Get the fileName property: The name of the exported file.
     * 
     * @return the fileName value.
     */
    public String fileName() {
        return this.fileName;
    }

    /**
     * Set the fileName property: The name of the exported file.
     * 
     * @param fileName the fileName value to set.
     * @return the ExportRunPropertiesInner object itself.
     */
    public ExportRunPropertiesInner withFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    /**
     * Get the runSettings property: The export settings that were in effect for this run.
     * 
     * @return the runSettings value.
     */
    public CommonExportPropertiesInner runSettings() {
        return this.runSettings;
    }

    /**
     * Set the runSettings property: The export settings that were in effect for this run.
     * 
     * @param runSettings the runSettings value to set.
     * @return the ExportRunPropertiesInner object itself.
     */
    public ExportRunPropertiesInner withRunSettings(CommonExportPropertiesInner runSettings) {
        this.runSettings = runSettings;
        return this;
    }

    /**
     * Get the error property: The details of any error.
     * 
     * @return the error value.
     */
    public ManagementError error() {
        return this.error;
    }

    /**
     * Set the error property: The details of any error.
     * 
     * @param error the error value to set.
     * @return the ExportRunPropertiesInner object itself.
     */
    public ExportRunPropertiesInner withError(ManagementError error) {
        this.error = error;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (runSettings() != null) {
            runSettings().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("executionType", this.executionType == null ? null : this.executionType.toString());
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("submittedBy", this.submittedBy);
        jsonWriter.writeStringField("submittedTime",
            this.submittedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.submittedTime));
        jsonWriter.writeStringField("processingStartTime",
            this.processingStartTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.processingStartTime));
        jsonWriter.writeStringField("processingEndTime",
            this.processingEndTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.processingEndTime));
        jsonWriter.writeStringField("fileName", this.fileName);
        jsonWriter.writeJsonField("runSettings", this.runSettings);
        jsonWriter.writeJsonField("error", this.error);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExportRunPropertiesInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExportRunPropertiesInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExportRunPropertiesInner.
     */
    public static ExportRunPropertiesInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExportRunPropertiesInner deserializedExportRunPropertiesInner = new ExportRunPropertiesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("executionType".equals(fieldName)) {
                    deserializedExportRunPropertiesInner.executionType = ExecutionType.fromString(reader.getString());
                } else if ("status".equals(fieldName)) {
                    deserializedExportRunPropertiesInner.status = ExecutionStatus.fromString(reader.getString());
                } else if ("submittedBy".equals(fieldName)) {
                    deserializedExportRunPropertiesInner.submittedBy = reader.getString();
                } else if ("submittedTime".equals(fieldName)) {
                    deserializedExportRunPropertiesInner.submittedTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("processingStartTime".equals(fieldName)) {
                    deserializedExportRunPropertiesInner.processingStartTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("processingEndTime".equals(fieldName)) {
                    deserializedExportRunPropertiesInner.processingEndTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("fileName".equals(fieldName)) {
                    deserializedExportRunPropertiesInner.fileName = reader.getString();
                } else if ("runSettings".equals(fieldName)) {
                    deserializedExportRunPropertiesInner.runSettings = CommonExportPropertiesInner.fromJson(reader);
                } else if ("error".equals(fieldName)) {
                    deserializedExportRunPropertiesInner.error = ManagementError.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExportRunPropertiesInner;
        });
    }
}
