// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.ForecastColumn;
import java.io.IOException;
import java.util.List;

/**
 * Forecast properties.
 */
@Fluent
public final class ForecastProperties implements JsonSerializable<ForecastProperties> {
    /*
     * The link (url) to the next page of results.
     */
    private String nextLink;

    /*
     * Array of columns
     */
    private List<ForecastColumn> columns;

    /*
     * Array of rows
     */
    private List<List<Object>> rows;

    /**
     * Creates an instance of ForecastProperties class.
     */
    public ForecastProperties() {
    }

    /**
     * Get the nextLink property: The link (url) to the next page of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The link (url) to the next page of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ForecastProperties object itself.
     */
    public ForecastProperties withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Get the columns property: Array of columns.
     * 
     * @return the columns value.
     */
    public List<ForecastColumn> columns() {
        return this.columns;
    }

    /**
     * Set the columns property: Array of columns.
     * 
     * @param columns the columns value to set.
     * @return the ForecastProperties object itself.
     */
    public ForecastProperties withColumns(List<ForecastColumn> columns) {
        this.columns = columns;
        return this;
    }

    /**
     * Get the rows property: Array of rows.
     * 
     * @return the rows value.
     */
    public List<List<Object>> rows() {
        return this.rows;
    }

    /**
     * Set the rows property: Array of rows.
     * 
     * @param rows the rows value to set.
     * @return the ForecastProperties object itself.
     */
    public ForecastProperties withRows(List<List<Object>> rows) {
        this.rows = rows;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (columns() != null) {
            columns().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("columns", this.columns, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("rows", this.rows,
            (writer, element) -> writer.writeArray(element, (writer1, element1) -> writer1.writeUntyped(element1)));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ForecastProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ForecastProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ForecastProperties.
     */
    public static ForecastProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ForecastProperties deserializedForecastProperties = new ForecastProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("nextLink".equals(fieldName)) {
                    deserializedForecastProperties.nextLink = reader.getString();
                } else if ("columns".equals(fieldName)) {
                    List<ForecastColumn> columns = reader.readArray(reader1 -> ForecastColumn.fromJson(reader1));
                    deserializedForecastProperties.columns = columns;
                } else if ("rows".equals(fieldName)) {
                    List<List<Object>> rows
                        = reader.readArray(reader1 -> reader1.readArray(reader2 -> reader2.readUntyped()));
                    deserializedForecastProperties.rows = rows;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedForecastProperties;
        });
    }
}
