// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.BenefitKind;
import com.azure.resourcemanager.costmanagement.models.BenefitUtilizationSummaryProperties;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;

/**
 * Included Quantity utilization summary properties.
 */
@Fluent
public final class IncludedQuantityUtilizationSummaryProperties extends BenefitUtilizationSummaryProperties {
    /*
     * This is the utilized percentage for the benefit ID.
     */
    private BigDecimal utilizationPercentage;

    /*
     * Date corresponding to the utilization summary record. If the grain of data is monthly, value for this field will
     * be first day of the month.
     */
    private OffsetDateTime usageDate;

    /*
     * The benefit order ID is the identifier for a benefit purchase.
     */
    private String benefitOrderId;

    /*
     * The benefit ID is the identifier of the benefit.
     */
    private String benefitId;

    /*
     * ARM SKU name. For example, 'Compute_Savings_Plan' for savings plan.
     */
    private String armSkuName;

    /**
     * Creates an instance of IncludedQuantityUtilizationSummaryProperties class.
     */
    public IncludedQuantityUtilizationSummaryProperties() {
    }

    /**
     * Get the utilizationPercentage property: This is the utilized percentage for the benefit ID.
     * 
     * @return the utilizationPercentage value.
     */
    public BigDecimal utilizationPercentage() {
        return this.utilizationPercentage;
    }

    /**
     * Get the usageDate property: Date corresponding to the utilization summary record. If the grain of data is
     * monthly, value for this field will be first day of the month.
     * 
     * @return the usageDate value.
     */
    @Override
    public OffsetDateTime usageDate() {
        return this.usageDate;
    }

    /**
     * Get the benefitOrderId property: The benefit order ID is the identifier for a benefit purchase.
     * 
     * @return the benefitOrderId value.
     */
    @Override
    public String benefitOrderId() {
        return this.benefitOrderId;
    }

    /**
     * Get the benefitId property: The benefit ID is the identifier of the benefit.
     * 
     * @return the benefitId value.
     */
    @Override
    public String benefitId() {
        return this.benefitId;
    }

    /**
     * Get the armSkuName property: ARM SKU name. For example, 'Compute_Savings_Plan' for savings plan.
     * 
     * @return the armSkuName value.
     */
    @Override
    public String armSkuName() {
        return this.armSkuName;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public IncludedQuantityUtilizationSummaryProperties withBenefitType(BenefitKind benefitType) {
        super.withBenefitType(benefitType);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("benefitType", benefitType() == null ? null : benefitType().toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IncludedQuantityUtilizationSummaryProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IncludedQuantityUtilizationSummaryProperties if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the IncludedQuantityUtilizationSummaryProperties.
     */
    public static IncludedQuantityUtilizationSummaryProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IncludedQuantityUtilizationSummaryProperties deserializedIncludedQuantityUtilizationSummaryProperties
                = new IncludedQuantityUtilizationSummaryProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("armSkuName".equals(fieldName)) {
                    deserializedIncludedQuantityUtilizationSummaryProperties.armSkuName = reader.getString();
                } else if ("benefitId".equals(fieldName)) {
                    deserializedIncludedQuantityUtilizationSummaryProperties.benefitId = reader.getString();
                } else if ("benefitOrderId".equals(fieldName)) {
                    deserializedIncludedQuantityUtilizationSummaryProperties.benefitOrderId = reader.getString();
                } else if ("benefitType".equals(fieldName)) {
                    deserializedIncludedQuantityUtilizationSummaryProperties
                        .withBenefitType(BenefitKind.fromString(reader.getString()));
                } else if ("usageDate".equals(fieldName)) {
                    deserializedIncludedQuantityUtilizationSummaryProperties.usageDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("utilizationPercentage".equals(fieldName)) {
                    deserializedIncludedQuantityUtilizationSummaryProperties.utilizationPercentage
                        = reader.getNullable(nonNullReader -> new BigDecimal(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIncludedQuantityUtilizationSummaryProperties;
        });
    }
}
