// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.BlobInfo;
import com.azure.resourcemanager.costmanagement.models.CostDetailsDataFormat;
import com.azure.resourcemanager.costmanagement.models.GenerateCostDetailsReportRequestDefinition;
import java.io.IOException;
import java.util.List;

/**
 * The manifest of the report generated by the operation.
 */
@Fluent
public final class ReportManifest implements JsonSerializable<ReportManifest> {
    /*
     * The Manifest version.
     */
    private String manifestVersion;

    /*
     * The data format of the report
     */
    private CostDetailsDataFormat dataFormat;

    /*
     * The total number of bytes in all blobs.
     */
    private Long byteCount;

    /*
     * The total number of blobs.
     */
    private Integer blobCount;

    /*
     * Is the data in compressed format.
     */
    private Boolean compressData;

    /*
     * The context of the Cost Details request.
     */
    private RequestContext innerRequestContext;

    /*
     * List of blob information generated by this operation.
     */
    private List<BlobInfo> blobs;

    /**
     * Creates an instance of ReportManifest class.
     */
    public ReportManifest() {
    }

    /**
     * Get the manifestVersion property: The Manifest version.
     * 
     * @return the manifestVersion value.
     */
    public String manifestVersion() {
        return this.manifestVersion;
    }

    /**
     * Set the manifestVersion property: The Manifest version.
     * 
     * @param manifestVersion the manifestVersion value to set.
     * @return the ReportManifest object itself.
     */
    public ReportManifest withManifestVersion(String manifestVersion) {
        this.manifestVersion = manifestVersion;
        return this;
    }

    /**
     * Get the dataFormat property: The data format of the report.
     * 
     * @return the dataFormat value.
     */
    public CostDetailsDataFormat dataFormat() {
        return this.dataFormat;
    }

    /**
     * Set the dataFormat property: The data format of the report.
     * 
     * @param dataFormat the dataFormat value to set.
     * @return the ReportManifest object itself.
     */
    public ReportManifest withDataFormat(CostDetailsDataFormat dataFormat) {
        this.dataFormat = dataFormat;
        return this;
    }

    /**
     * Get the byteCount property: The total number of bytes in all blobs.
     * 
     * @return the byteCount value.
     */
    public Long byteCount() {
        return this.byteCount;
    }

    /**
     * Set the byteCount property: The total number of bytes in all blobs.
     * 
     * @param byteCount the byteCount value to set.
     * @return the ReportManifest object itself.
     */
    public ReportManifest withByteCount(Long byteCount) {
        this.byteCount = byteCount;
        return this;
    }

    /**
     * Get the blobCount property: The total number of blobs.
     * 
     * @return the blobCount value.
     */
    public Integer blobCount() {
        return this.blobCount;
    }

    /**
     * Set the blobCount property: The total number of blobs.
     * 
     * @param blobCount the blobCount value to set.
     * @return the ReportManifest object itself.
     */
    public ReportManifest withBlobCount(Integer blobCount) {
        this.blobCount = blobCount;
        return this;
    }

    /**
     * Get the compressData property: Is the data in compressed format.
     * 
     * @return the compressData value.
     */
    public Boolean compressData() {
        return this.compressData;
    }

    /**
     * Set the compressData property: Is the data in compressed format.
     * 
     * @param compressData the compressData value to set.
     * @return the ReportManifest object itself.
     */
    public ReportManifest withCompressData(Boolean compressData) {
        this.compressData = compressData;
        return this;
    }

    /**
     * Get the innerRequestContext property: The context of the Cost Details request.
     * 
     * @return the innerRequestContext value.
     */
    private RequestContext innerRequestContext() {
        return this.innerRequestContext;
    }

    /**
     * Get the blobs property: List of blob information generated by this operation.
     * 
     * @return the blobs value.
     */
    public List<BlobInfo> blobs() {
        return this.blobs;
    }

    /**
     * Set the blobs property: List of blob information generated by this operation.
     * 
     * @param blobs the blobs value to set.
     * @return the ReportManifest object itself.
     */
    public ReportManifest withBlobs(List<BlobInfo> blobs) {
        this.blobs = blobs;
        return this;
    }

    /**
     * Get the requestScope property: The request scope of the request.
     * 
     * @return the requestScope value.
     */
    public String requestScope() {
        return this.innerRequestContext() == null ? null : this.innerRequestContext().requestScope();
    }

    /**
     * Set the requestScope property: The request scope of the request.
     * 
     * @param requestScope the requestScope value to set.
     * @return the ReportManifest object itself.
     */
    public ReportManifest withRequestScope(String requestScope) {
        if (this.innerRequestContext() == null) {
            this.innerRequestContext = new RequestContext();
        }
        this.innerRequestContext().withRequestScope(requestScope);
        return this;
    }

    /**
     * Get the requestBody property: The request payload body provided in Cost Details call.
     * 
     * @return the requestBody value.
     */
    public GenerateCostDetailsReportRequestDefinition requestBody() {
        return this.innerRequestContext() == null ? null : this.innerRequestContext().requestBody();
    }

    /**
     * Set the requestBody property: The request payload body provided in Cost Details call.
     * 
     * @param requestBody the requestBody value to set.
     * @return the ReportManifest object itself.
     */
    public ReportManifest withRequestBody(GenerateCostDetailsReportRequestDefinition requestBody) {
        if (this.innerRequestContext() == null) {
            this.innerRequestContext = new RequestContext();
        }
        this.innerRequestContext().withRequestBody(requestBody);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerRequestContext() != null) {
            innerRequestContext().validate();
        }
        if (blobs() != null) {
            blobs().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("manifestVersion", this.manifestVersion);
        jsonWriter.writeStringField("dataFormat", this.dataFormat == null ? null : this.dataFormat.toString());
        jsonWriter.writeNumberField("byteCount", this.byteCount);
        jsonWriter.writeNumberField("blobCount", this.blobCount);
        jsonWriter.writeBooleanField("compressData", this.compressData);
        jsonWriter.writeJsonField("requestContext", this.innerRequestContext);
        jsonWriter.writeArrayField("blobs", this.blobs, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ReportManifest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ReportManifest if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ReportManifest.
     */
    public static ReportManifest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ReportManifest deserializedReportManifest = new ReportManifest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("manifestVersion".equals(fieldName)) {
                    deserializedReportManifest.manifestVersion = reader.getString();
                } else if ("dataFormat".equals(fieldName)) {
                    deserializedReportManifest.dataFormat = CostDetailsDataFormat.fromString(reader.getString());
                } else if ("byteCount".equals(fieldName)) {
                    deserializedReportManifest.byteCount = reader.getNullable(JsonReader::getLong);
                } else if ("blobCount".equals(fieldName)) {
                    deserializedReportManifest.blobCount = reader.getNullable(JsonReader::getInt);
                } else if ("compressData".equals(fieldName)) {
                    deserializedReportManifest.compressData = reader.getNullable(JsonReader::getBoolean);
                } else if ("requestContext".equals(fieldName)) {
                    deserializedReportManifest.innerRequestContext = RequestContext.fromJson(reader);
                } else if ("blobs".equals(fieldName)) {
                    List<BlobInfo> blobs = reader.readArray(reader1 -> BlobInfo.fromJson(reader1));
                    deserializedReportManifest.blobs = blobs;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedReportManifest;
        });
    }
}
