// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.ReservationReportSchema;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * The URL to download the generated report.
 */
@Fluent
public final class ReportUrl implements JsonSerializable<ReportUrl> {
    /*
     * The CSV file from the reportUrl blob link consists of reservation usage data with the following schema at daily
     * granularity
     */
    private ReservationReportSchema reportUrl;

    /*
     * The time at which report URL becomes invalid.
     */
    private OffsetDateTime validUntil;

    /**
     * Creates an instance of ReportUrl class.
     */
    public ReportUrl() {
    }

    /**
     * Get the reportUrl property: The CSV file from the reportUrl blob link consists of reservation usage data with the
     * following schema at daily granularity.
     * 
     * @return the reportUrl value.
     */
    public ReservationReportSchema reportUrl() {
        return this.reportUrl;
    }

    /**
     * Set the reportUrl property: The CSV file from the reportUrl blob link consists of reservation usage data with the
     * following schema at daily granularity.
     * 
     * @param reportUrl the reportUrl value to set.
     * @return the ReportUrl object itself.
     */
    public ReportUrl withReportUrl(ReservationReportSchema reportUrl) {
        this.reportUrl = reportUrl;
        return this;
    }

    /**
     * Get the validUntil property: The time at which report URL becomes invalid.
     * 
     * @return the validUntil value.
     */
    public OffsetDateTime validUntil() {
        return this.validUntil;
    }

    /**
     * Set the validUntil property: The time at which report URL becomes invalid.
     * 
     * @param validUntil the validUntil value to set.
     * @return the ReportUrl object itself.
     */
    public ReportUrl withValidUntil(OffsetDateTime validUntil) {
        this.validUntil = validUntil;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reportUrl", this.reportUrl == null ? null : this.reportUrl.toString());
        jsonWriter.writeStringField("validUntil",
            this.validUntil == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.validUntil));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ReportUrl from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ReportUrl if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the ReportUrl.
     */
    public static ReportUrl fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ReportUrl deserializedReportUrl = new ReportUrl();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("reportUrl".equals(fieldName)) {
                    deserializedReportUrl.reportUrl = ReservationReportSchema.fromString(reader.getString());
                } else if ("validUntil".equals(fieldName)) {
                    deserializedReportUrl.validUntil = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedReportUrl;
        });
    }
}
