// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.FileDestination;
import com.azure.resourcemanager.costmanagement.models.NotificationProperties;
import com.azure.resourcemanager.costmanagement.models.ScheduleProperties;
import com.azure.resourcemanager.costmanagement.models.ScheduledActionKind;
import com.azure.resourcemanager.costmanagement.models.ScheduledActionProxyResource;
import com.azure.resourcemanager.costmanagement.models.ScheduledActionStatus;
import java.io.IOException;

/**
 * Scheduled action definition.
 */
@Fluent
public final class ScheduledActionInner extends ScheduledActionProxyResource {
    /*
     * The properties of the scheduled action.
     */
    private ScheduledActionProperties innerProperties;

    /*
     * Kind of the scheduled action.
     */
    private SystemData systemData;

    /*
     * Resource Etag. For update calls, eTag is optional and can be specified to achieve optimistic concurrency. Fetch
     * the resource's eTag by doing a 'GET' call first and then including the latest eTag as part of the request body or
     * 'If-Match' header while performing the update. For create calls, eTag is not required.
     */
    private String etag;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ScheduledActionInner class.
     */
    public ScheduledActionInner() {
    }

    /**
     * Get the innerProperties property: The properties of the scheduled action.
     * 
     * @return the innerProperties value.
     */
    private ScheduledActionProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Kind of the scheduled action.
     * 
     * @return the systemData value.
     */
    @Override
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the etag property: Resource Etag. For update calls, eTag is optional and can be specified to achieve
     * optimistic concurrency. Fetch the resource's eTag by doing a 'GET' call first and then including the latest eTag
     * as part of the request body or 'If-Match' header while performing the update. For create calls, eTag is not
     * required.
     * 
     * @return the etag value.
     */
    @Override
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ScheduledActionInner withKind(ScheduledActionKind kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the displayName property: Scheduled action name.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    /**
     * Set the displayName property: Scheduled action name.
     * 
     * @param displayName the displayName value to set.
     * @return the ScheduledActionInner object itself.
     */
    public ScheduledActionInner withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledActionProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    /**
     * Get the fileDestination property: Destination format of the view data. This is optional.
     * 
     * @return the fileDestination value.
     */
    public FileDestination fileDestination() {
        return this.innerProperties() == null ? null : this.innerProperties().fileDestination();
    }

    /**
     * Set the fileDestination property: Destination format of the view data. This is optional.
     * 
     * @param fileDestination the fileDestination value to set.
     * @return the ScheduledActionInner object itself.
     */
    public ScheduledActionInner withFileDestination(FileDestination fileDestination) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledActionProperties();
        }
        this.innerProperties().withFileDestination(fileDestination);
        return this;
    }

    /**
     * Get the notification property: Notification properties based on scheduled action kind.
     * 
     * @return the notification value.
     */
    public NotificationProperties notification() {
        return this.innerProperties() == null ? null : this.innerProperties().notification();
    }

    /**
     * Set the notification property: Notification properties based on scheduled action kind.
     * 
     * @param notification the notification value to set.
     * @return the ScheduledActionInner object itself.
     */
    public ScheduledActionInner withNotification(NotificationProperties notification) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledActionProperties();
        }
        this.innerProperties().withNotification(notification);
        return this;
    }

    /**
     * Get the notificationEmail property: Email address of the point of contact that should get the unsubscribe
     * requests and notification emails.
     * 
     * @return the notificationEmail value.
     */
    public String notificationEmail() {
        return this.innerProperties() == null ? null : this.innerProperties().notificationEmail();
    }

    /**
     * Set the notificationEmail property: Email address of the point of contact that should get the unsubscribe
     * requests and notification emails.
     * 
     * @param notificationEmail the notificationEmail value to set.
     * @return the ScheduledActionInner object itself.
     */
    public ScheduledActionInner withNotificationEmail(String notificationEmail) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledActionProperties();
        }
        this.innerProperties().withNotificationEmail(notificationEmail);
        return this;
    }

    /**
     * Get the schedule property: Schedule of the scheduled action.
     * 
     * @return the schedule value.
     */
    public ScheduleProperties schedule() {
        return this.innerProperties() == null ? null : this.innerProperties().schedule();
    }

    /**
     * Set the schedule property: Schedule of the scheduled action.
     * 
     * @param schedule the schedule value to set.
     * @return the ScheduledActionInner object itself.
     */
    public ScheduledActionInner withSchedule(ScheduleProperties schedule) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledActionProperties();
        }
        this.innerProperties().withSchedule(schedule);
        return this;
    }

    /**
     * Get the scope property: Cost Management scope like 'subscriptions/{subscriptionId}' for subscription scope,
     * 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope,
     * 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
     * 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope,
     * 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for
     * EnrollmentAccount scope,
     * 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for
     * BillingProfile scope,
     * 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for
     * InvoiceSection scope, '/providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}'
     * for ExternalBillingAccount scope, and
     * '/providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for ExternalSubscription
     * scope.
     * 
     * @return the scope value.
     */
    public String scope() {
        return this.innerProperties() == null ? null : this.innerProperties().scope();
    }

    /**
     * Set the scope property: Cost Management scope like 'subscriptions/{subscriptionId}' for subscription scope,
     * 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope,
     * 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
     * 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope,
     * 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for
     * EnrollmentAccount scope,
     * 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for
     * BillingProfile scope,
     * 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for
     * InvoiceSection scope, '/providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}'
     * for ExternalBillingAccount scope, and
     * '/providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for ExternalSubscription
     * scope.
     * 
     * @param scope the scope value to set.
     * @return the ScheduledActionInner object itself.
     */
    public ScheduledActionInner withScope(String scope) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledActionProperties();
        }
        this.innerProperties().withScope(scope);
        return this;
    }

    /**
     * Get the status property: Status of the scheduled action.
     * 
     * @return the status value.
     */
    public ScheduledActionStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Set the status property: Status of the scheduled action.
     * 
     * @param status the status value to set.
     * @return the ScheduledActionInner object itself.
     */
    public ScheduledActionInner withStatus(ScheduledActionStatus status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledActionProperties();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    /**
     * Get the viewId property: Cost analysis viewId used for scheduled action. For example,
     * '/providers/Microsoft.CostManagement/views/swaggerExample'.
     * 
     * @return the viewId value.
     */
    public String viewId() {
        return this.innerProperties() == null ? null : this.innerProperties().viewId();
    }

    /**
     * Set the viewId property: Cost analysis viewId used for scheduled action. For example,
     * '/providers/Microsoft.CostManagement/views/swaggerExample'.
     * 
     * @param viewId the viewId value to set.
     * @return the ScheduledActionInner object itself.
     */
    public ScheduledActionInner withViewId(String viewId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledActionProperties();
        }
        this.innerProperties().withViewId(viewId);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind() == null ? null : kind().toString());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ScheduledActionInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ScheduledActionInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ScheduledActionInner.
     */
    public static ScheduledActionInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ScheduledActionInner deserializedScheduledActionInner = new ScheduledActionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedScheduledActionInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedScheduledActionInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedScheduledActionInner.type = reader.getString();
                } else if ("eTag".equals(fieldName)) {
                    deserializedScheduledActionInner.etag = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedScheduledActionInner.withKind(ScheduledActionKind.fromString(reader.getString()));
                } else if ("systemData".equals(fieldName)) {
                    deserializedScheduledActionInner.systemData = SystemData.fromJson(reader);
                } else if ("properties".equals(fieldName)) {
                    deserializedScheduledActionInner.innerProperties = ScheduledActionProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedScheduledActionInner;
        });
    }
}
