// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.costmanagement.fluent.BenefitRecommendationsClient;
import com.azure.resourcemanager.costmanagement.fluent.models.BenefitRecommendationModelInner;
import com.azure.resourcemanager.costmanagement.models.BenefitRecommendationModel;
import com.azure.resourcemanager.costmanagement.models.BenefitRecommendations;

public final class BenefitRecommendationsImpl implements BenefitRecommendations {
    private static final ClientLogger LOGGER = new ClientLogger(BenefitRecommendationsImpl.class);

    private final BenefitRecommendationsClient innerClient;

    private final com.azure.resourcemanager.costmanagement.CostManagementManager serviceManager;

    public BenefitRecommendationsImpl(BenefitRecommendationsClient innerClient,
        com.azure.resourcemanager.costmanagement.CostManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<BenefitRecommendationModel> list(String billingScope) {
        PagedIterable<BenefitRecommendationModelInner> inner = this.serviceClient().list(billingScope);
        return ResourceManagerUtils.mapPage(inner,
            inner1 -> new BenefitRecommendationModelImpl(inner1, this.manager()));
    }

    public PagedIterable<BenefitRecommendationModel> list(String billingScope, String filter, String orderby,
        String expand, Context context) {
        PagedIterable<BenefitRecommendationModelInner> inner
            = this.serviceClient().list(billingScope, filter, orderby, expand, context);
        return ResourceManagerUtils.mapPage(inner,
            inner1 -> new BenefitRecommendationModelImpl(inner1, this.manager()));
    }

    private BenefitRecommendationsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.costmanagement.CostManagementManager manager() {
        return this.serviceManager;
    }
}
