// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.costmanagement.fluent.BenefitUtilizationSummariesClient;
import com.azure.resourcemanager.costmanagement.fluent.models.BenefitUtilizationSummaryInner;
import com.azure.resourcemanager.costmanagement.models.BenefitUtilizationSummariesListResult;
import com.azure.resourcemanager.costmanagement.models.GrainParameter;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in BenefitUtilizationSummariesClient.
 */
public final class BenefitUtilizationSummariesClientImpl implements BenefitUtilizationSummariesClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final BenefitUtilizationSummariesService service;

    /**
     * The service client containing this operation class.
     */
    private final CostManagementClientImpl client;

    /**
     * Initializes an instance of BenefitUtilizationSummariesClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    BenefitUtilizationSummariesClientImpl(CostManagementClientImpl client) {
        this.service = RestProxy.create(BenefitUtilizationSummariesService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for CostManagementClientBenefitUtilizationSummaries to be used by the
     * proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "CostManagementClient")
    public interface BenefitUtilizationSummariesService {
        @Headers({ "Content-Type: application/json" })
        @Get("/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/providers/Microsoft.CostManagement/benefitUtilizationSummaries")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<BenefitUtilizationSummariesListResult>> listByBillingAccountId(
            @HostParam("$host") String endpoint, @QueryParam("api-version") String apiVersion,
            @PathParam("billingAccountId") String billingAccountId,
            @QueryParam("grainParameter") GrainParameter grainParameter, @QueryParam("filter") String filter,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/providers/Microsoft.CostManagement/benefitUtilizationSummaries")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<BenefitUtilizationSummariesListResult>> listByBillingProfileId(
            @HostParam("$host") String endpoint, @QueryParam("api-version") String apiVersion,
            @PathParam("billingAccountId") String billingAccountId,
            @PathParam("billingProfileId") String billingProfileId,
            @QueryParam("grainParameter") GrainParameter grainParameter, @QueryParam("filter") String filter,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/providers/Microsoft.BillingBenefits/savingsPlanOrders/{savingsPlanOrderId}/providers/Microsoft.CostManagement/benefitUtilizationSummaries")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<BenefitUtilizationSummariesListResult>> listBySavingsPlanOrder(
            @HostParam("$host") String endpoint, @QueryParam("api-version") String apiVersion,
            @QueryParam("$filter") String filter, @QueryParam("grainParameter") GrainParameter grainParameter,
            @PathParam("savingsPlanOrderId") String savingsPlanOrderId, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/providers/Microsoft.BillingBenefits/savingsPlanOrders/{savingsPlanOrderId}/savingsPlans/{savingsPlanId}/providers/Microsoft.CostManagement/benefitUtilizationSummaries")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<BenefitUtilizationSummariesListResult>> listBySavingsPlanId(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @QueryParam("$filter") String filter,
            @QueryParam("grainParameter") GrainParameter grainParameter,
            @PathParam("savingsPlanOrderId") String savingsPlanOrderId,
            @PathParam("savingsPlanId") String savingsPlanId, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<BenefitUtilizationSummariesListResult>> listByBillingAccountIdNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<BenefitUtilizationSummariesListResult>> listByBillingProfileIdNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<BenefitUtilizationSummariesListResult>> listBySavingsPlanOrderNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<BenefitUtilizationSummariesListResult>> listBySavingsPlanIdNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Lists savings plan utilization summaries for the enterprise agreement scope. Supported at grain values: 'Daily'
     * and 'Monthly'.
     * 
     * @param billingAccountId Billing account ID.
     * @param grainParameter Grain.
     * @param filter Supports filtering by properties/benefitId, properties/benefitOrderId and properties/usageDate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitUtilizationSummaryInner>>
        listByBillingAccountIdSinglePageAsync(String billingAccountId, GrainParameter grainParameter, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (billingAccountId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter billingAccountId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByBillingAccountId(this.client.getEndpoint(),
                this.client.getApiVersion(), billingAccountId, grainParameter, filter, accept, context))
            .<PagedResponse<BenefitUtilizationSummaryInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists savings plan utilization summaries for the enterprise agreement scope. Supported at grain values: 'Daily'
     * and 'Monthly'.
     * 
     * @param billingAccountId Billing account ID.
     * @param grainParameter Grain.
     * @param filter Supports filtering by properties/benefitId, properties/benefitOrderId and properties/usageDate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitUtilizationSummaryInner>> listByBillingAccountIdSinglePageAsync(
        String billingAccountId, GrainParameter grainParameter, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (billingAccountId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter billingAccountId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByBillingAccountId(this.client.getEndpoint(), this.client.getApiVersion(), billingAccountId,
                grainParameter, filter, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists savings plan utilization summaries for the enterprise agreement scope. Supported at grain values: 'Daily'
     * and 'Monthly'.
     * 
     * @param billingAccountId Billing account ID.
     * @param grainParameter Grain.
     * @param filter Supports filtering by properties/benefitId, properties/benefitOrderId and properties/usageDate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<BenefitUtilizationSummaryInner> listByBillingAccountIdAsync(String billingAccountId,
        GrainParameter grainParameter, String filter) {
        return new PagedFlux<>(() -> listByBillingAccountIdSinglePageAsync(billingAccountId, grainParameter, filter),
            nextLink -> listByBillingAccountIdNextSinglePageAsync(nextLink));
    }

    /**
     * Lists savings plan utilization summaries for the enterprise agreement scope. Supported at grain values: 'Daily'
     * and 'Monthly'.
     * 
     * @param billingAccountId Billing account ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<BenefitUtilizationSummaryInner> listByBillingAccountIdAsync(String billingAccountId) {
        final GrainParameter grainParameter = null;
        final String filter = null;
        return new PagedFlux<>(() -> listByBillingAccountIdSinglePageAsync(billingAccountId, grainParameter, filter),
            nextLink -> listByBillingAccountIdNextSinglePageAsync(nextLink));
    }

    /**
     * Lists savings plan utilization summaries for the enterprise agreement scope. Supported at grain values: 'Daily'
     * and 'Monthly'.
     * 
     * @param billingAccountId Billing account ID.
     * @param grainParameter Grain.
     * @param filter Supports filtering by properties/benefitId, properties/benefitOrderId and properties/usageDate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<BenefitUtilizationSummaryInner> listByBillingAccountIdAsync(String billingAccountId,
        GrainParameter grainParameter, String filter, Context context) {
        return new PagedFlux<>(
            () -> listByBillingAccountIdSinglePageAsync(billingAccountId, grainParameter, filter, context),
            nextLink -> listByBillingAccountIdNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists savings plan utilization summaries for the enterprise agreement scope. Supported at grain values: 'Daily'
     * and 'Monthly'.
     * 
     * @param billingAccountId Billing account ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BenefitUtilizationSummaryInner> listByBillingAccountId(String billingAccountId) {
        final GrainParameter grainParameter = null;
        final String filter = null;
        return new PagedIterable<>(listByBillingAccountIdAsync(billingAccountId, grainParameter, filter));
    }

    /**
     * Lists savings plan utilization summaries for the enterprise agreement scope. Supported at grain values: 'Daily'
     * and 'Monthly'.
     * 
     * @param billingAccountId Billing account ID.
     * @param grainParameter Grain.
     * @param filter Supports filtering by properties/benefitId, properties/benefitOrderId and properties/usageDate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BenefitUtilizationSummaryInner> listByBillingAccountId(String billingAccountId,
        GrainParameter grainParameter, String filter, Context context) {
        return new PagedIterable<>(listByBillingAccountIdAsync(billingAccountId, grainParameter, filter, context));
    }

    /**
     * Lists savings plan utilization summaries for billing profile. Supported at grain values: 'Daily' and 'Monthly'.
     * 
     * @param billingAccountId Billing account ID.
     * @param billingProfileId Billing profile ID.
     * @param grainParameter Grain.
     * @param filter Supports filtering by properties/benefitId, properties/benefitOrderId and properties/usageDate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitUtilizationSummaryInner>> listByBillingProfileIdSinglePageAsync(
        String billingAccountId, String billingProfileId, GrainParameter grainParameter, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (billingAccountId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter billingAccountId is required and cannot be null."));
        }
        if (billingProfileId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter billingProfileId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listByBillingProfileId(this.client.getEndpoint(), this.client.getApiVersion(),
                    billingAccountId, billingProfileId, grainParameter, filter, accept, context))
            .<PagedResponse<BenefitUtilizationSummaryInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists savings plan utilization summaries for billing profile. Supported at grain values: 'Daily' and 'Monthly'.
     * 
     * @param billingAccountId Billing account ID.
     * @param billingProfileId Billing profile ID.
     * @param grainParameter Grain.
     * @param filter Supports filtering by properties/benefitId, properties/benefitOrderId and properties/usageDate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitUtilizationSummaryInner>> listByBillingProfileIdSinglePageAsync(
        String billingAccountId, String billingProfileId, GrainParameter grainParameter, String filter,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (billingAccountId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter billingAccountId is required and cannot be null."));
        }
        if (billingProfileId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter billingProfileId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByBillingProfileId(this.client.getEndpoint(), this.client.getApiVersion(), billingAccountId,
                billingProfileId, grainParameter, filter, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists savings plan utilization summaries for billing profile. Supported at grain values: 'Daily' and 'Monthly'.
     * 
     * @param billingAccountId Billing account ID.
     * @param billingProfileId Billing profile ID.
     * @param grainParameter Grain.
     * @param filter Supports filtering by properties/benefitId, properties/benefitOrderId and properties/usageDate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<BenefitUtilizationSummaryInner> listByBillingProfileIdAsync(String billingAccountId,
        String billingProfileId, GrainParameter grainParameter, String filter) {
        return new PagedFlux<>(
            () -> listByBillingProfileIdSinglePageAsync(billingAccountId, billingProfileId, grainParameter, filter),
            nextLink -> listByBillingProfileIdNextSinglePageAsync(nextLink));
    }

    /**
     * Lists savings plan utilization summaries for billing profile. Supported at grain values: 'Daily' and 'Monthly'.
     * 
     * @param billingAccountId Billing account ID.
     * @param billingProfileId Billing profile ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<BenefitUtilizationSummaryInner> listByBillingProfileIdAsync(String billingAccountId,
        String billingProfileId) {
        final GrainParameter grainParameter = null;
        final String filter = null;
        return new PagedFlux<>(
            () -> listByBillingProfileIdSinglePageAsync(billingAccountId, billingProfileId, grainParameter, filter),
            nextLink -> listByBillingProfileIdNextSinglePageAsync(nextLink));
    }

    /**
     * Lists savings plan utilization summaries for billing profile. Supported at grain values: 'Daily' and 'Monthly'.
     * 
     * @param billingAccountId Billing account ID.
     * @param billingProfileId Billing profile ID.
     * @param grainParameter Grain.
     * @param filter Supports filtering by properties/benefitId, properties/benefitOrderId and properties/usageDate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<BenefitUtilizationSummaryInner> listByBillingProfileIdAsync(String billingAccountId,
        String billingProfileId, GrainParameter grainParameter, String filter, Context context) {
        return new PagedFlux<>(() -> listByBillingProfileIdSinglePageAsync(billingAccountId, billingProfileId,
            grainParameter, filter, context), nextLink -> listByBillingProfileIdNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists savings plan utilization summaries for billing profile. Supported at grain values: 'Daily' and 'Monthly'.
     * 
     * @param billingAccountId Billing account ID.
     * @param billingProfileId Billing profile ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BenefitUtilizationSummaryInner> listByBillingProfileId(String billingAccountId,
        String billingProfileId) {
        final GrainParameter grainParameter = null;
        final String filter = null;
        return new PagedIterable<>(
            listByBillingProfileIdAsync(billingAccountId, billingProfileId, grainParameter, filter));
    }

    /**
     * Lists savings plan utilization summaries for billing profile. Supported at grain values: 'Daily' and 'Monthly'.
     * 
     * @param billingAccountId Billing account ID.
     * @param billingProfileId Billing profile ID.
     * @param grainParameter Grain.
     * @param filter Supports filtering by properties/benefitId, properties/benefitOrderId and properties/usageDate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BenefitUtilizationSummaryInner> listByBillingProfileId(String billingAccountId,
        String billingProfileId, GrainParameter grainParameter, String filter, Context context) {
        return new PagedIterable<>(
            listByBillingProfileIdAsync(billingAccountId, billingProfileId, grainParameter, filter, context));
    }

    /**
     * Lists the savings plan utilization summaries for daily or monthly grain.
     * 
     * @param savingsPlanOrderId Savings plan order ID.
     * @param filter Supports filtering by properties/usageDate.
     * @param grainParameter Grain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitUtilizationSummaryInner>>
        listBySavingsPlanOrderSinglePageAsync(String savingsPlanOrderId, String filter, GrainParameter grainParameter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (savingsPlanOrderId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter savingsPlanOrderId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listBySavingsPlanOrder(this.client.getEndpoint(),
                this.client.getApiVersion(), filter, grainParameter, savingsPlanOrderId, accept, context))
            .<PagedResponse<BenefitUtilizationSummaryInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists the savings plan utilization summaries for daily or monthly grain.
     * 
     * @param savingsPlanOrderId Savings plan order ID.
     * @param filter Supports filtering by properties/usageDate.
     * @param grainParameter Grain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitUtilizationSummaryInner>> listBySavingsPlanOrderSinglePageAsync(
        String savingsPlanOrderId, String filter, GrainParameter grainParameter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (savingsPlanOrderId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter savingsPlanOrderId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listBySavingsPlanOrder(this.client.getEndpoint(), this.client.getApiVersion(), filter, grainParameter,
                savingsPlanOrderId, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists the savings plan utilization summaries for daily or monthly grain.
     * 
     * @param savingsPlanOrderId Savings plan order ID.
     * @param filter Supports filtering by properties/usageDate.
     * @param grainParameter Grain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<BenefitUtilizationSummaryInner> listBySavingsPlanOrderAsync(String savingsPlanOrderId,
        String filter, GrainParameter grainParameter) {
        return new PagedFlux<>(() -> listBySavingsPlanOrderSinglePageAsync(savingsPlanOrderId, filter, grainParameter),
            nextLink -> listBySavingsPlanOrderNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the savings plan utilization summaries for daily or monthly grain.
     * 
     * @param savingsPlanOrderId Savings plan order ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<BenefitUtilizationSummaryInner> listBySavingsPlanOrderAsync(String savingsPlanOrderId) {
        final String filter = null;
        final GrainParameter grainParameter = null;
        return new PagedFlux<>(() -> listBySavingsPlanOrderSinglePageAsync(savingsPlanOrderId, filter, grainParameter),
            nextLink -> listBySavingsPlanOrderNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the savings plan utilization summaries for daily or monthly grain.
     * 
     * @param savingsPlanOrderId Savings plan order ID.
     * @param filter Supports filtering by properties/usageDate.
     * @param grainParameter Grain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<BenefitUtilizationSummaryInner> listBySavingsPlanOrderAsync(String savingsPlanOrderId,
        String filter, GrainParameter grainParameter, Context context) {
        return new PagedFlux<>(
            () -> listBySavingsPlanOrderSinglePageAsync(savingsPlanOrderId, filter, grainParameter, context),
            nextLink -> listBySavingsPlanOrderNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists the savings plan utilization summaries for daily or monthly grain.
     * 
     * @param savingsPlanOrderId Savings plan order ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BenefitUtilizationSummaryInner> listBySavingsPlanOrder(String savingsPlanOrderId) {
        final String filter = null;
        final GrainParameter grainParameter = null;
        return new PagedIterable<>(listBySavingsPlanOrderAsync(savingsPlanOrderId, filter, grainParameter));
    }

    /**
     * Lists the savings plan utilization summaries for daily or monthly grain.
     * 
     * @param savingsPlanOrderId Savings plan order ID.
     * @param filter Supports filtering by properties/usageDate.
     * @param grainParameter Grain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BenefitUtilizationSummaryInner> listBySavingsPlanOrder(String savingsPlanOrderId,
        String filter, GrainParameter grainParameter, Context context) {
        return new PagedIterable<>(listBySavingsPlanOrderAsync(savingsPlanOrderId, filter, grainParameter, context));
    }

    /**
     * Lists the savings plan utilization summaries for daily or monthly grain.
     * 
     * @param savingsPlanOrderId Savings plan order ID.
     * @param savingsPlanId Savings plan ID.
     * @param filter Supports filtering by properties/usageDate.
     * @param grainParameter Grain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitUtilizationSummaryInner>> listBySavingsPlanIdSinglePageAsync(
        String savingsPlanOrderId, String savingsPlanId, String filter, GrainParameter grainParameter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (savingsPlanOrderId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter savingsPlanOrderId is required and cannot be null."));
        }
        if (savingsPlanId == null) {
            return Mono.error(new IllegalArgumentException("Parameter savingsPlanId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listBySavingsPlanId(this.client.getEndpoint(), this.client.getApiVersion(),
                filter, grainParameter, savingsPlanOrderId, savingsPlanId, accept, context))
            .<PagedResponse<BenefitUtilizationSummaryInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists the savings plan utilization summaries for daily or monthly grain.
     * 
     * @param savingsPlanOrderId Savings plan order ID.
     * @param savingsPlanId Savings plan ID.
     * @param filter Supports filtering by properties/usageDate.
     * @param grainParameter Grain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitUtilizationSummaryInner>> listBySavingsPlanIdSinglePageAsync(
        String savingsPlanOrderId, String savingsPlanId, String filter, GrainParameter grainParameter,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (savingsPlanOrderId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter savingsPlanOrderId is required and cannot be null."));
        }
        if (savingsPlanId == null) {
            return Mono.error(new IllegalArgumentException("Parameter savingsPlanId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listBySavingsPlanId(this.client.getEndpoint(), this.client.getApiVersion(), filter, grainParameter,
                savingsPlanOrderId, savingsPlanId, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists the savings plan utilization summaries for daily or monthly grain.
     * 
     * @param savingsPlanOrderId Savings plan order ID.
     * @param savingsPlanId Savings plan ID.
     * @param filter Supports filtering by properties/usageDate.
     * @param grainParameter Grain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<BenefitUtilizationSummaryInner> listBySavingsPlanIdAsync(String savingsPlanOrderId,
        String savingsPlanId, String filter, GrainParameter grainParameter) {
        return new PagedFlux<>(
            () -> listBySavingsPlanIdSinglePageAsync(savingsPlanOrderId, savingsPlanId, filter, grainParameter),
            nextLink -> listBySavingsPlanIdNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the savings plan utilization summaries for daily or monthly grain.
     * 
     * @param savingsPlanOrderId Savings plan order ID.
     * @param savingsPlanId Savings plan ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<BenefitUtilizationSummaryInner> listBySavingsPlanIdAsync(String savingsPlanOrderId,
        String savingsPlanId) {
        final String filter = null;
        final GrainParameter grainParameter = null;
        return new PagedFlux<>(
            () -> listBySavingsPlanIdSinglePageAsync(savingsPlanOrderId, savingsPlanId, filter, grainParameter),
            nextLink -> listBySavingsPlanIdNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the savings plan utilization summaries for daily or monthly grain.
     * 
     * @param savingsPlanOrderId Savings plan order ID.
     * @param savingsPlanId Savings plan ID.
     * @param filter Supports filtering by properties/usageDate.
     * @param grainParameter Grain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<BenefitUtilizationSummaryInner> listBySavingsPlanIdAsync(String savingsPlanOrderId,
        String savingsPlanId, String filter, GrainParameter grainParameter, Context context) {
        return new PagedFlux<>(() -> listBySavingsPlanIdSinglePageAsync(savingsPlanOrderId, savingsPlanId, filter,
            grainParameter, context), nextLink -> listBySavingsPlanIdNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists the savings plan utilization summaries for daily or monthly grain.
     * 
     * @param savingsPlanOrderId Savings plan order ID.
     * @param savingsPlanId Savings plan ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BenefitUtilizationSummaryInner> listBySavingsPlanId(String savingsPlanOrderId,
        String savingsPlanId) {
        final String filter = null;
        final GrainParameter grainParameter = null;
        return new PagedIterable<>(listBySavingsPlanIdAsync(savingsPlanOrderId, savingsPlanId, filter, grainParameter));
    }

    /**
     * Lists the savings plan utilization summaries for daily or monthly grain.
     * 
     * @param savingsPlanOrderId Savings plan order ID.
     * @param savingsPlanId Savings plan ID.
     * @param filter Supports filtering by properties/usageDate.
     * @param grainParameter Grain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BenefitUtilizationSummaryInner> listBySavingsPlanId(String savingsPlanOrderId,
        String savingsPlanId, String filter, GrainParameter grainParameter, Context context) {
        return new PagedIterable<>(
            listBySavingsPlanIdAsync(savingsPlanOrderId, savingsPlanId, filter, grainParameter, context));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitUtilizationSummaryInner>>
        listByBillingAccountIdNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listByBillingAccountIdNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<BenefitUtilizationSummaryInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitUtilizationSummaryInner>>
        listByBillingAccountIdNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByBillingAccountIdNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitUtilizationSummaryInner>>
        listByBillingProfileIdNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listByBillingProfileIdNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<BenefitUtilizationSummaryInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitUtilizationSummaryInner>>
        listByBillingProfileIdNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByBillingProfileIdNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitUtilizationSummaryInner>>
        listBySavingsPlanOrderNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listBySavingsPlanOrderNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<BenefitUtilizationSummaryInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitUtilizationSummaryInner>>
        listBySavingsPlanOrderNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listBySavingsPlanOrderNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitUtilizationSummaryInner>>
        listBySavingsPlanIdNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listBySavingsPlanIdNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<BenefitUtilizationSummaryInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitUtilizationSummaryInner>> listBySavingsPlanIdNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listBySavingsPlanIdNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
