// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.costmanagement.fluent.GenerateCostDetailsReportsClient;
import com.azure.resourcemanager.costmanagement.fluent.models.CostDetailsOperationResultsInner;
import com.azure.resourcemanager.costmanagement.models.GenerateCostDetailsReportRequestDefinition;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in GenerateCostDetailsReportsClient.
 */
public final class GenerateCostDetailsReportsClientImpl implements GenerateCostDetailsReportsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final GenerateCostDetailsReportsService service;

    /**
     * The service client containing this operation class.
     */
    private final CostManagementClientImpl client;

    /**
     * Initializes an instance of GenerateCostDetailsReportsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    GenerateCostDetailsReportsClientImpl(CostManagementClientImpl client) {
        this.service = RestProxy.create(GenerateCostDetailsReportsService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for CostManagementClientGenerateCostDetailsReports to be used by the
     * proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "CostManagementClient")
    public interface GenerateCostDetailsReportsService {
        @Headers({ "Content-Type: application/json" })
        @Post("/{scope}/providers/Microsoft.CostManagement/generateCostDetailsReport")
        @ExpectedResponses({ 200, 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createOperation(@HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") GenerateCostDetailsReportRequestDefinition parameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/{scope}/providers/Microsoft.CostManagement/costDetailsOperationResults/{operationId}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> getOperationResults(@HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope, @PathParam("operationId") String operationId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * This API is the replacement for all previously release Usage Details APIs. Request to generate a cost details
     * report for the provided date range, billing period (Only enterprise customers) or Invoice Id asynchronously at a
     * certain scope. The initial call to request a report will return a 202 with a 'Location' and 'Retry-After' header.
     * The 'Location' header will provide the endpoint to poll to get the result of the report generation. The
     * 'Retry-After' provides the duration to wait before polling for the generated report. A call to poll the report
     * operation will provide a 202 response with a 'Location' header if the operation is still in progress. Once the
     * report generation operation completes, the polling endpoint will provide a 200 response along with details on the
     * report blob(s) that are available for download. The details on the file(s) available for download will be
     * available in the polling response body. To Understand cost details (formerly known as usage details) fields found
     * in files ,see https://learn.microsoft.com/azure/cost-management-billing/automate/understand-usage-details-fields.
     * 
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @param parameters Parameters supplied to the Create cost details operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the long running operation for cost details Api along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOperationWithResponseAsync(String scope,
        GenerateCostDetailsReportRequestDefinition parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOperation(this.client.getEndpoint(), scope,
                this.client.getApiVersion(), parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * This API is the replacement for all previously release Usage Details APIs. Request to generate a cost details
     * report for the provided date range, billing period (Only enterprise customers) or Invoice Id asynchronously at a
     * certain scope. The initial call to request a report will return a 202 with a 'Location' and 'Retry-After' header.
     * The 'Location' header will provide the endpoint to poll to get the result of the report generation. The
     * 'Retry-After' provides the duration to wait before polling for the generated report. A call to poll the report
     * operation will provide a 202 response with a 'Location' header if the operation is still in progress. Once the
     * report generation operation completes, the polling endpoint will provide a 200 response along with details on the
     * report blob(s) that are available for download. The details on the file(s) available for download will be
     * available in the polling response body. To Understand cost details (formerly known as usage details) fields found
     * in files ,see https://learn.microsoft.com/azure/cost-management-billing/automate/understand-usage-details-fields.
     * 
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @param parameters Parameters supplied to the Create cost details operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the long running operation for cost details Api along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOperationWithResponseAsync(String scope,
        GenerateCostDetailsReportRequestDefinition parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOperation(this.client.getEndpoint(), scope, this.client.getApiVersion(), parameters,
            accept, context);
    }

    /**
     * This API is the replacement for all previously release Usage Details APIs. Request to generate a cost details
     * report for the provided date range, billing period (Only enterprise customers) or Invoice Id asynchronously at a
     * certain scope. The initial call to request a report will return a 202 with a 'Location' and 'Retry-After' header.
     * The 'Location' header will provide the endpoint to poll to get the result of the report generation. The
     * 'Retry-After' provides the duration to wait before polling for the generated report. A call to poll the report
     * operation will provide a 202 response with a 'Location' header if the operation is still in progress. Once the
     * report generation operation completes, the polling endpoint will provide a 200 response along with details on the
     * report blob(s) that are available for download. The details on the file(s) available for download will be
     * available in the polling response body. To Understand cost details (formerly known as usage details) fields found
     * in files ,see https://learn.microsoft.com/azure/cost-management-billing/automate/understand-usage-details-fields.
     * 
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @param parameters Parameters supplied to the Create cost details operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the result of the long running operation for cost details Api.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CostDetailsOperationResultsInner>, CostDetailsOperationResultsInner>
        beginCreateOperationAsync(String scope, GenerateCostDetailsReportRequestDefinition parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = createOperationWithResponseAsync(scope, parameters);
        return this.client.<CostDetailsOperationResultsInner, CostDetailsOperationResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), CostDetailsOperationResultsInner.class,
            CostDetailsOperationResultsInner.class, this.client.getContext());
    }

    /**
     * This API is the replacement for all previously release Usage Details APIs. Request to generate a cost details
     * report for the provided date range, billing period (Only enterprise customers) or Invoice Id asynchronously at a
     * certain scope. The initial call to request a report will return a 202 with a 'Location' and 'Retry-After' header.
     * The 'Location' header will provide the endpoint to poll to get the result of the report generation. The
     * 'Retry-After' provides the duration to wait before polling for the generated report. A call to poll the report
     * operation will provide a 202 response with a 'Location' header if the operation is still in progress. Once the
     * report generation operation completes, the polling endpoint will provide a 200 response along with details on the
     * report blob(s) that are available for download. The details on the file(s) available for download will be
     * available in the polling response body. To Understand cost details (formerly known as usage details) fields found
     * in files ,see https://learn.microsoft.com/azure/cost-management-billing/automate/understand-usage-details-fields.
     * 
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @param parameters Parameters supplied to the Create cost details operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the result of the long running operation for cost details Api.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CostDetailsOperationResultsInner>, CostDetailsOperationResultsInner>
        beginCreateOperationAsync(String scope, GenerateCostDetailsReportRequestDefinition parameters,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = createOperationWithResponseAsync(scope, parameters, context);
        return this.client.<CostDetailsOperationResultsInner, CostDetailsOperationResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), CostDetailsOperationResultsInner.class,
            CostDetailsOperationResultsInner.class, context);
    }

    /**
     * This API is the replacement for all previously release Usage Details APIs. Request to generate a cost details
     * report for the provided date range, billing period (Only enterprise customers) or Invoice Id asynchronously at a
     * certain scope. The initial call to request a report will return a 202 with a 'Location' and 'Retry-After' header.
     * The 'Location' header will provide the endpoint to poll to get the result of the report generation. The
     * 'Retry-After' provides the duration to wait before polling for the generated report. A call to poll the report
     * operation will provide a 202 response with a 'Location' header if the operation is still in progress. Once the
     * report generation operation completes, the polling endpoint will provide a 200 response along with details on the
     * report blob(s) that are available for download. The details on the file(s) available for download will be
     * available in the polling response body. To Understand cost details (formerly known as usage details) fields found
     * in files ,see https://learn.microsoft.com/azure/cost-management-billing/automate/understand-usage-details-fields.
     * 
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @param parameters Parameters supplied to the Create cost details operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the result of the long running operation for cost details Api.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CostDetailsOperationResultsInner>, CostDetailsOperationResultsInner>
        beginCreateOperation(String scope, GenerateCostDetailsReportRequestDefinition parameters) {
        return this.beginCreateOperationAsync(scope, parameters).getSyncPoller();
    }

    /**
     * This API is the replacement for all previously release Usage Details APIs. Request to generate a cost details
     * report for the provided date range, billing period (Only enterprise customers) or Invoice Id asynchronously at a
     * certain scope. The initial call to request a report will return a 202 with a 'Location' and 'Retry-After' header.
     * The 'Location' header will provide the endpoint to poll to get the result of the report generation. The
     * 'Retry-After' provides the duration to wait before polling for the generated report. A call to poll the report
     * operation will provide a 202 response with a 'Location' header if the operation is still in progress. Once the
     * report generation operation completes, the polling endpoint will provide a 200 response along with details on the
     * report blob(s) that are available for download. The details on the file(s) available for download will be
     * available in the polling response body. To Understand cost details (formerly known as usage details) fields found
     * in files ,see https://learn.microsoft.com/azure/cost-management-billing/automate/understand-usage-details-fields.
     * 
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @param parameters Parameters supplied to the Create cost details operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the result of the long running operation for cost details Api.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CostDetailsOperationResultsInner>, CostDetailsOperationResultsInner>
        beginCreateOperation(String scope, GenerateCostDetailsReportRequestDefinition parameters, Context context) {
        return this.beginCreateOperationAsync(scope, parameters, context).getSyncPoller();
    }

    /**
     * This API is the replacement for all previously release Usage Details APIs. Request to generate a cost details
     * report for the provided date range, billing period (Only enterprise customers) or Invoice Id asynchronously at a
     * certain scope. The initial call to request a report will return a 202 with a 'Location' and 'Retry-After' header.
     * The 'Location' header will provide the endpoint to poll to get the result of the report generation. The
     * 'Retry-After' provides the duration to wait before polling for the generated report. A call to poll the report
     * operation will provide a 202 response with a 'Location' header if the operation is still in progress. Once the
     * report generation operation completes, the polling endpoint will provide a 200 response along with details on the
     * report blob(s) that are available for download. The details on the file(s) available for download will be
     * available in the polling response body. To Understand cost details (formerly known as usage details) fields found
     * in files ,see https://learn.microsoft.com/azure/cost-management-billing/automate/understand-usage-details-fields.
     * 
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @param parameters Parameters supplied to the Create cost details operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the long running operation for cost details Api on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<CostDetailsOperationResultsInner> createOperationAsync(String scope,
        GenerateCostDetailsReportRequestDefinition parameters) {
        return beginCreateOperationAsync(scope, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * This API is the replacement for all previously release Usage Details APIs. Request to generate a cost details
     * report for the provided date range, billing period (Only enterprise customers) or Invoice Id asynchronously at a
     * certain scope. The initial call to request a report will return a 202 with a 'Location' and 'Retry-After' header.
     * The 'Location' header will provide the endpoint to poll to get the result of the report generation. The
     * 'Retry-After' provides the duration to wait before polling for the generated report. A call to poll the report
     * operation will provide a 202 response with a 'Location' header if the operation is still in progress. Once the
     * report generation operation completes, the polling endpoint will provide a 200 response along with details on the
     * report blob(s) that are available for download. The details on the file(s) available for download will be
     * available in the polling response body. To Understand cost details (formerly known as usage details) fields found
     * in files ,see https://learn.microsoft.com/azure/cost-management-billing/automate/understand-usage-details-fields.
     * 
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @param parameters Parameters supplied to the Create cost details operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the long running operation for cost details Api on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<CostDetailsOperationResultsInner> createOperationAsync(String scope,
        GenerateCostDetailsReportRequestDefinition parameters, Context context) {
        return beginCreateOperationAsync(scope, parameters, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * This API is the replacement for all previously release Usage Details APIs. Request to generate a cost details
     * report for the provided date range, billing period (Only enterprise customers) or Invoice Id asynchronously at a
     * certain scope. The initial call to request a report will return a 202 with a 'Location' and 'Retry-After' header.
     * The 'Location' header will provide the endpoint to poll to get the result of the report generation. The
     * 'Retry-After' provides the duration to wait before polling for the generated report. A call to poll the report
     * operation will provide a 202 response with a 'Location' header if the operation is still in progress. Once the
     * report generation operation completes, the polling endpoint will provide a 200 response along with details on the
     * report blob(s) that are available for download. The details on the file(s) available for download will be
     * available in the polling response body. To Understand cost details (formerly known as usage details) fields found
     * in files ,see https://learn.microsoft.com/azure/cost-management-billing/automate/understand-usage-details-fields.
     * 
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @param parameters Parameters supplied to the Create cost details operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the long running operation for cost details Api.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CostDetailsOperationResultsInner createOperation(String scope,
        GenerateCostDetailsReportRequestDefinition parameters) {
        return createOperationAsync(scope, parameters).block();
    }

    /**
     * This API is the replacement for all previously release Usage Details APIs. Request to generate a cost details
     * report for the provided date range, billing period (Only enterprise customers) or Invoice Id asynchronously at a
     * certain scope. The initial call to request a report will return a 202 with a 'Location' and 'Retry-After' header.
     * The 'Location' header will provide the endpoint to poll to get the result of the report generation. The
     * 'Retry-After' provides the duration to wait before polling for the generated report. A call to poll the report
     * operation will provide a 202 response with a 'Location' header if the operation is still in progress. Once the
     * report generation operation completes, the polling endpoint will provide a 200 response along with details on the
     * report blob(s) that are available for download. The details on the file(s) available for download will be
     * available in the polling response body. To Understand cost details (formerly known as usage details) fields found
     * in files ,see https://learn.microsoft.com/azure/cost-management-billing/automate/understand-usage-details-fields.
     * 
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @param parameters Parameters supplied to the Create cost details operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the long running operation for cost details Api.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CostDetailsOperationResultsInner createOperation(String scope,
        GenerateCostDetailsReportRequestDefinition parameters, Context context) {
        return createOperationAsync(scope, parameters, context).block();
    }

    /**
     * Get the result of the specified operation. This link is provided in the CostDetails creation request response
     * Location header.
     * 
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @param operationId The target operation Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the specified operation along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> getOperationResultsWithResponseAsync(String scope, String operationId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getOperationResults(this.client.getEndpoint(), scope, operationId,
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the result of the specified operation. This link is provided in the CostDetails creation request response
     * Location header.
     * 
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @param operationId The target operation Id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the specified operation along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> getOperationResultsWithResponseAsync(String scope, String operationId,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getOperationResults(this.client.getEndpoint(), scope, operationId, this.client.getApiVersion(),
            accept, context);
    }

    /**
     * Get the result of the specified operation. This link is provided in the CostDetails creation request response
     * Location header.
     * 
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @param operationId The target operation Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the result of the specified operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CostDetailsOperationResultsInner>, CostDetailsOperationResultsInner>
        beginGetOperationResultsAsync(String scope, String operationId) {
        Mono<Response<Flux<ByteBuffer>>> mono = getOperationResultsWithResponseAsync(scope, operationId);
        return this.client.<CostDetailsOperationResultsInner, CostDetailsOperationResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), CostDetailsOperationResultsInner.class,
            CostDetailsOperationResultsInner.class, this.client.getContext());
    }

    /**
     * Get the result of the specified operation. This link is provided in the CostDetails creation request response
     * Location header.
     * 
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @param operationId The target operation Id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the result of the specified operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CostDetailsOperationResultsInner>, CostDetailsOperationResultsInner>
        beginGetOperationResultsAsync(String scope, String operationId, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = getOperationResultsWithResponseAsync(scope, operationId, context);
        return this.client.<CostDetailsOperationResultsInner, CostDetailsOperationResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), CostDetailsOperationResultsInner.class,
            CostDetailsOperationResultsInner.class, context);
    }

    /**
     * Get the result of the specified operation. This link is provided in the CostDetails creation request response
     * Location header.
     * 
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @param operationId The target operation Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the result of the specified operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CostDetailsOperationResultsInner>, CostDetailsOperationResultsInner>
        beginGetOperationResults(String scope, String operationId) {
        return this.beginGetOperationResultsAsync(scope, operationId).getSyncPoller();
    }

    /**
     * Get the result of the specified operation. This link is provided in the CostDetails creation request response
     * Location header.
     * 
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @param operationId The target operation Id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the result of the specified operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CostDetailsOperationResultsInner>, CostDetailsOperationResultsInner>
        beginGetOperationResults(String scope, String operationId, Context context) {
        return this.beginGetOperationResultsAsync(scope, operationId, context).getSyncPoller();
    }

    /**
     * Get the result of the specified operation. This link is provided in the CostDetails creation request response
     * Location header.
     * 
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @param operationId The target operation Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the specified operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<CostDetailsOperationResultsInner> getOperationResultsAsync(String scope, String operationId) {
        return beginGetOperationResultsAsync(scope, operationId).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Get the result of the specified operation. This link is provided in the CostDetails creation request response
     * Location header.
     * 
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @param operationId The target operation Id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the specified operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<CostDetailsOperationResultsInner> getOperationResultsAsync(String scope, String operationId,
        Context context) {
        return beginGetOperationResultsAsync(scope, operationId, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Get the result of the specified operation. This link is provided in the CostDetails creation request response
     * Location header.
     * 
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @param operationId The target operation Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the specified operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CostDetailsOperationResultsInner getOperationResults(String scope, String operationId) {
        return getOperationResultsAsync(scope, operationId).block();
    }

    /**
     * Get the result of the specified operation. This link is provided in the CostDetails creation request response
     * Location header.
     * 
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @param operationId The target operation Id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the specified operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CostDetailsOperationResultsInner getOperationResults(String scope, String operationId, Context context) {
        return getOperationResultsAsync(scope, operationId, context).block();
    }
}
