// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.costmanagement.fluent.GenerateCostDetailsReportsClient;
import com.azure.resourcemanager.costmanagement.fluent.models.CostDetailsOperationResultsInner;
import com.azure.resourcemanager.costmanagement.models.CostDetailsOperationResults;
import com.azure.resourcemanager.costmanagement.models.GenerateCostDetailsReportRequestDefinition;
import com.azure.resourcemanager.costmanagement.models.GenerateCostDetailsReports;

public final class GenerateCostDetailsReportsImpl implements GenerateCostDetailsReports {
    private static final ClientLogger LOGGER = new ClientLogger(GenerateCostDetailsReportsImpl.class);

    private final GenerateCostDetailsReportsClient innerClient;

    private final com.azure.resourcemanager.costmanagement.CostManagementManager serviceManager;

    public GenerateCostDetailsReportsImpl(GenerateCostDetailsReportsClient innerClient,
        com.azure.resourcemanager.costmanagement.CostManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public CostDetailsOperationResults createOperation(String scope,
        GenerateCostDetailsReportRequestDefinition parameters) {
        CostDetailsOperationResultsInner inner = this.serviceClient().createOperation(scope, parameters);
        if (inner != null) {
            return new CostDetailsOperationResultsImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public CostDetailsOperationResults createOperation(String scope,
        GenerateCostDetailsReportRequestDefinition parameters, Context context) {
        CostDetailsOperationResultsInner inner = this.serviceClient().createOperation(scope, parameters, context);
        if (inner != null) {
            return new CostDetailsOperationResultsImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public CostDetailsOperationResults getOperationResults(String scope, String operationId) {
        CostDetailsOperationResultsInner inner = this.serviceClient().getOperationResults(scope, operationId);
        if (inner != null) {
            return new CostDetailsOperationResultsImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public CostDetailsOperationResults getOperationResults(String scope, String operationId, Context context) {
        CostDetailsOperationResultsInner inner = this.serviceClient().getOperationResults(scope, operationId, context);
        if (inner != null) {
            return new CostDetailsOperationResultsImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private GenerateCostDetailsReportsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.costmanagement.CostManagementManager manager() {
        return this.serviceManager;
    }
}
