// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.costmanagement.fluent.GenerateDetailedCostReportOperationResultsClient;
import com.azure.resourcemanager.costmanagement.fluent.models.GenerateDetailedCostReportOperationResultInner;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in
 * GenerateDetailedCostReportOperationResultsClient.
 */
public final class GenerateDetailedCostReportOperationResultsClientImpl
    implements GenerateDetailedCostReportOperationResultsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final GenerateDetailedCostReportOperationResultsService service;

    /**
     * The service client containing this operation class.
     */
    private final CostManagementClientImpl client;

    /**
     * Initializes an instance of GenerateDetailedCostReportOperationResultsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    GenerateDetailedCostReportOperationResultsClientImpl(CostManagementClientImpl client) {
        this.service = RestProxy.create(GenerateDetailedCostReportOperationResultsService.class,
            client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for CostManagementClientGenerateDetailedCostReportOperationResults to be
     * used by the proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "CostManagementClient")
    public interface GenerateDetailedCostReportOperationResultsService {
        @Headers({ "Content-Type: application/json" })
        @Get("/{scope}/providers/Microsoft.CostManagement/operationResults/{operationId}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> get(@HostParam("$host") String endpoint,
            @PathParam("operationId") String operationId, @PathParam(value = "scope", encoded = true) String scope,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Gets the result of the specified operation. The link with this operationId is provided as a response header of
     * the initial request.
     * 
     * @param operationId The target operation Id.
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the specified operation along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> getWithResponseAsync(String operationId, String scope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), operationId, scope,
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the result of the specified operation. The link with this operationId is provided as a response header of
     * the initial request.
     * 
     * @param operationId The target operation Id.
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the specified operation along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> getWithResponseAsync(String operationId, String scope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), operationId, scope, this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the result of the specified operation. The link with this operationId is provided as a response header of
     * the initial request.
     * 
     * @param operationId The target operation Id.
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the result of the specified operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private
        PollerFlux<PollResult<GenerateDetailedCostReportOperationResultInner>, GenerateDetailedCostReportOperationResultInner>
        beginGetAsync(String operationId, String scope) {
        Mono<Response<Flux<ByteBuffer>>> mono = getWithResponseAsync(operationId, scope);
        return this.client
            .<GenerateDetailedCostReportOperationResultInner, GenerateDetailedCostReportOperationResultInner>getLroResult(
                mono, this.client.getHttpPipeline(), GenerateDetailedCostReportOperationResultInner.class,
                GenerateDetailedCostReportOperationResultInner.class, this.client.getContext());
    }

    /**
     * Gets the result of the specified operation. The link with this operationId is provided as a response header of
     * the initial request.
     * 
     * @param operationId The target operation Id.
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the result of the specified operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private
        PollerFlux<PollResult<GenerateDetailedCostReportOperationResultInner>, GenerateDetailedCostReportOperationResultInner>
        beginGetAsync(String operationId, String scope, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = getWithResponseAsync(operationId, scope, context);
        return this.client
            .<GenerateDetailedCostReportOperationResultInner, GenerateDetailedCostReportOperationResultInner>getLroResult(
                mono, this.client.getHttpPipeline(), GenerateDetailedCostReportOperationResultInner.class,
                GenerateDetailedCostReportOperationResultInner.class, context);
    }

    /**
     * Gets the result of the specified operation. The link with this operationId is provided as a response header of
     * the initial request.
     * 
     * @param operationId The target operation Id.
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the result of the specified operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public
        SyncPoller<PollResult<GenerateDetailedCostReportOperationResultInner>, GenerateDetailedCostReportOperationResultInner>
        beginGet(String operationId, String scope) {
        return this.beginGetAsync(operationId, scope).getSyncPoller();
    }

    /**
     * Gets the result of the specified operation. The link with this operationId is provided as a response header of
     * the initial request.
     * 
     * @param operationId The target operation Id.
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the result of the specified operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public
        SyncPoller<PollResult<GenerateDetailedCostReportOperationResultInner>, GenerateDetailedCostReportOperationResultInner>
        beginGet(String operationId, String scope, Context context) {
        return this.beginGetAsync(operationId, scope, context).getSyncPoller();
    }

    /**
     * Gets the result of the specified operation. The link with this operationId is provided as a response header of
     * the initial request.
     * 
     * @param operationId The target operation Id.
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the specified operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<GenerateDetailedCostReportOperationResultInner> getAsync(String operationId, String scope) {
        return beginGetAsync(operationId, scope).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Gets the result of the specified operation. The link with this operationId is provided as a response header of
     * the initial request.
     * 
     * @param operationId The target operation Id.
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the specified operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<GenerateDetailedCostReportOperationResultInner> getAsync(String operationId, String scope,
        Context context) {
        return beginGetAsync(operationId, scope, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Gets the result of the specified operation. The link with this operationId is provided as a response header of
     * the initial request.
     * 
     * @param operationId The target operation Id.
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the specified operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GenerateDetailedCostReportOperationResultInner get(String operationId, String scope) {
        return getAsync(operationId, scope).block();
    }

    /**
     * Gets the result of the specified operation. The link with this operationId is provided as a response header of
     * the initial request.
     * 
     * @param operationId The target operation Id.
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the specified operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GenerateDetailedCostReportOperationResultInner get(String operationId, String scope, Context context) {
        return getAsync(operationId, scope, context).block();
    }
}
