// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.costmanagement.fluent.GenerateDetailedCostReportOperationStatusClient;
import com.azure.resourcemanager.costmanagement.fluent.models.GenerateDetailedCostReportOperationStatusesInner;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in
 * GenerateDetailedCostReportOperationStatusClient.
 */
public final class GenerateDetailedCostReportOperationStatusClientImpl
    implements GenerateDetailedCostReportOperationStatusClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final GenerateDetailedCostReportOperationStatusService service;

    /**
     * The service client containing this operation class.
     */
    private final CostManagementClientImpl client;

    /**
     * Initializes an instance of GenerateDetailedCostReportOperationStatusClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    GenerateDetailedCostReportOperationStatusClientImpl(CostManagementClientImpl client) {
        this.service = RestProxy.create(GenerateDetailedCostReportOperationStatusService.class,
            client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for CostManagementClientGenerateDetailedCostReportOperationStatus to be
     * used by the proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "CostManagementClient")
    public interface GenerateDetailedCostReportOperationStatusService {
        @Headers({ "Content-Type: application/json" })
        @Get("/{scope}/providers/Microsoft.CostManagement/operationStatus/{operationId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<GenerateDetailedCostReportOperationStatusesInner>> get(@HostParam("$host") String endpoint,
            @PathParam("operationId") String operationId, @PathParam(value = "scope", encoded = true) String scope,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Get the status of the specified operation. This link is provided in the GenerateDetailedCostReport creation
     * request response header.
     * 
     * @param operationId The target operation Id.
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the status of the specified operation along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<GenerateDetailedCostReportOperationStatusesInner>> getWithResponseAsync(String operationId,
        String scope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), operationId, scope,
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the status of the specified operation. This link is provided in the GenerateDetailedCostReport creation
     * request response header.
     * 
     * @param operationId The target operation Id.
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the status of the specified operation along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<GenerateDetailedCostReportOperationStatusesInner>> getWithResponseAsync(String operationId,
        String scope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), operationId, scope, this.client.getApiVersion(), accept, context);
    }

    /**
     * Get the status of the specified operation. This link is provided in the GenerateDetailedCostReport creation
     * request response header.
     * 
     * @param operationId The target operation Id.
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the status of the specified operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<GenerateDetailedCostReportOperationStatusesInner> getAsync(String operationId, String scope) {
        return getWithResponseAsync(operationId, scope).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get the status of the specified operation. This link is provided in the GenerateDetailedCostReport creation
     * request response header.
     * 
     * @param operationId The target operation Id.
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the status of the specified operation along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<GenerateDetailedCostReportOperationStatusesInner> getWithResponse(String operationId, String scope,
        Context context) {
        return getWithResponseAsync(operationId, scope, context).block();
    }

    /**
     * Get the status of the specified operation. This link is provided in the GenerateDetailedCostReport creation
     * request response header.
     * 
     * @param operationId The target operation Id.
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     * details, see https://aka.ms/costmgmt/scopes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the status of the specified operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GenerateDetailedCostReportOperationStatusesInner get(String operationId, String scope) {
        return getWithResponse(operationId, scope, Context.NONE).getValue();
    }
}
