// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.costmanagement.fluent.GenerateDetailedCostReportOperationStatusClient;
import com.azure.resourcemanager.costmanagement.fluent.models.GenerateDetailedCostReportOperationStatusesInner;
import com.azure.resourcemanager.costmanagement.models.GenerateDetailedCostReportOperationStatus;
import com.azure.resourcemanager.costmanagement.models.GenerateDetailedCostReportOperationStatuses;

public final class GenerateDetailedCostReportOperationStatusImpl implements GenerateDetailedCostReportOperationStatus {
    private static final ClientLogger LOGGER = new ClientLogger(GenerateDetailedCostReportOperationStatusImpl.class);

    private final GenerateDetailedCostReportOperationStatusClient innerClient;

    private final com.azure.resourcemanager.costmanagement.CostManagementManager serviceManager;

    public GenerateDetailedCostReportOperationStatusImpl(GenerateDetailedCostReportOperationStatusClient innerClient,
        com.azure.resourcemanager.costmanagement.CostManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<GenerateDetailedCostReportOperationStatuses> getWithResponse(String operationId, String scope,
        Context context) {
        Response<GenerateDetailedCostReportOperationStatusesInner> inner
            = this.serviceClient().getWithResponse(operationId, scope, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new GenerateDetailedCostReportOperationStatusesImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public GenerateDetailedCostReportOperationStatuses get(String operationId, String scope) {
        GenerateDetailedCostReportOperationStatusesInner inner = this.serviceClient().get(operationId, scope);
        if (inner != null) {
            return new GenerateDetailedCostReportOperationStatusesImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private GenerateDetailedCostReportOperationStatusClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.costmanagement.CostManagementManager manager() {
        return this.serviceManager;
    }
}
