// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.costmanagement.fluent.GenerateDetailedCostReportsClient;
import com.azure.resourcemanager.costmanagement.fluent.models.GenerateDetailedCostReportOperationResultInner;
import com.azure.resourcemanager.costmanagement.models.GenerateDetailedCostReportDefinition;
import com.azure.resourcemanager.costmanagement.models.GenerateDetailedCostReportOperationResult;
import com.azure.resourcemanager.costmanagement.models.GenerateDetailedCostReports;

public final class GenerateDetailedCostReportsImpl implements GenerateDetailedCostReports {
    private static final ClientLogger LOGGER = new ClientLogger(GenerateDetailedCostReportsImpl.class);

    private final GenerateDetailedCostReportsClient innerClient;

    private final com.azure.resourcemanager.costmanagement.CostManagementManager serviceManager;

    public GenerateDetailedCostReportsImpl(GenerateDetailedCostReportsClient innerClient,
        com.azure.resourcemanager.costmanagement.CostManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public GenerateDetailedCostReportOperationResult createOperation(String scope,
        GenerateDetailedCostReportDefinition parameters) {
        GenerateDetailedCostReportOperationResultInner inner = this.serviceClient().createOperation(scope, parameters);
        if (inner != null) {
            return new GenerateDetailedCostReportOperationResultImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public GenerateDetailedCostReportOperationResult createOperation(String scope,
        GenerateDetailedCostReportDefinition parameters, Context context) {
        GenerateDetailedCostReportOperationResultInner inner
            = this.serviceClient().createOperation(scope, parameters, context);
        if (inner != null) {
            return new GenerateDetailedCostReportOperationResultImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private GenerateDetailedCostReportsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.costmanagement.CostManagementManager manager() {
        return this.serviceManager;
    }
}
