// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.costmanagement.fluent.GenerateReservationDetailsReportsClient;
import com.azure.resourcemanager.costmanagement.fluent.models.OperationStatusInner;
import com.azure.resourcemanager.costmanagement.models.GenerateReservationDetailsReports;
import com.azure.resourcemanager.costmanagement.models.OperationStatus;

public final class GenerateReservationDetailsReportsImpl implements GenerateReservationDetailsReports {
    private static final ClientLogger LOGGER = new ClientLogger(GenerateReservationDetailsReportsImpl.class);

    private final GenerateReservationDetailsReportsClient innerClient;

    private final com.azure.resourcemanager.costmanagement.CostManagementManager serviceManager;

    public GenerateReservationDetailsReportsImpl(GenerateReservationDetailsReportsClient innerClient,
        com.azure.resourcemanager.costmanagement.CostManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public OperationStatus byBillingAccountId(String billingAccountId, String startDate, String endDate) {
        OperationStatusInner inner = this.serviceClient().byBillingAccountId(billingAccountId, startDate, endDate);
        if (inner != null) {
            return new OperationStatusImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public OperationStatus byBillingAccountId(String billingAccountId, String startDate, String endDate,
        Context context) {
        OperationStatusInner inner
            = this.serviceClient().byBillingAccountId(billingAccountId, startDate, endDate, context);
        if (inner != null) {
            return new OperationStatusImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public OperationStatus byBillingProfileId(String billingAccountId, String billingProfileId, String startDate,
        String endDate) {
        OperationStatusInner inner
            = this.serviceClient().byBillingProfileId(billingAccountId, billingProfileId, startDate, endDate);
        if (inner != null) {
            return new OperationStatusImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public OperationStatus byBillingProfileId(String billingAccountId, String billingProfileId, String startDate,
        String endDate, Context context) {
        OperationStatusInner inner
            = this.serviceClient().byBillingProfileId(billingAccountId, billingProfileId, startDate, endDate, context);
        if (inner != null) {
            return new OperationStatusImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private GenerateReservationDetailsReportsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.costmanagement.CostManagementManager manager() {
        return this.serviceManager;
    }
}
