// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.costmanagement.fluent.PriceSheetsClient;
import com.azure.resourcemanager.costmanagement.fluent.models.DownloadUrlInner;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in PriceSheetsClient.
 */
public final class PriceSheetsClientImpl implements PriceSheetsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final PriceSheetsService service;

    /**
     * The service client containing this operation class.
     */
    private final CostManagementClientImpl client;

    /**
     * Initializes an instance of PriceSheetsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    PriceSheetsClientImpl(CostManagementClientImpl client) {
        this.service
            = RestProxy.create(PriceSheetsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for CostManagementClientPriceSheets to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "CostManagementClient")
    public interface PriceSheetsService {
        @Headers({ "Content-Type: application/json" })
        @Post("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoices/{invoiceName}/providers/Microsoft.CostManagement/pricesheets/default/download")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> download(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("billingAccountName") String billingAccountName,
            @PathParam("billingProfileName") String billingProfileName, @PathParam("invoiceName") String invoiceName,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/providers/Microsoft.CostManagement/pricesheets/default/download")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> downloadByBillingProfile(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("billingAccountName") String billingAccountName,
            @PathParam("billingProfileName") String billingProfileName, @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Gets a URL to download the pricesheet for an invoice. The operation is supported for billing accounts with
     * agreement type Microsoft Partner Agreement or Microsoft Customer Agreement.
     * 
     * @param billingAccountName The ID that uniquely identifies a billing account.
     * @param billingProfileName The ID that uniquely identifies a billing profile.
     * @param invoiceName The ID that uniquely identifies an invoice.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a URL to download the pricesheet for an invoice along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> downloadWithResponseAsync(String billingAccountName,
        String billingProfileName, String invoiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (billingAccountName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter billingAccountName is required and cannot be null."));
        }
        if (billingProfileName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter billingProfileName is required and cannot be null."));
        }
        if (invoiceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter invoiceName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.download(this.client.getEndpoint(), this.client.getApiVersion(),
                billingAccountName, billingProfileName, invoiceName, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a URL to download the pricesheet for an invoice. The operation is supported for billing accounts with
     * agreement type Microsoft Partner Agreement or Microsoft Customer Agreement.
     * 
     * @param billingAccountName The ID that uniquely identifies a billing account.
     * @param billingProfileName The ID that uniquely identifies a billing profile.
     * @param invoiceName The ID that uniquely identifies an invoice.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a URL to download the pricesheet for an invoice along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> downloadWithResponseAsync(String billingAccountName,
        String billingProfileName, String invoiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (billingAccountName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter billingAccountName is required and cannot be null."));
        }
        if (billingProfileName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter billingProfileName is required and cannot be null."));
        }
        if (invoiceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter invoiceName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.download(this.client.getEndpoint(), this.client.getApiVersion(), billingAccountName,
            billingProfileName, invoiceName, accept, context);
    }

    /**
     * Gets a URL to download the pricesheet for an invoice. The operation is supported for billing accounts with
     * agreement type Microsoft Partner Agreement or Microsoft Customer Agreement.
     * 
     * @param billingAccountName The ID that uniquely identifies a billing account.
     * @param billingProfileName The ID that uniquely identifies a billing profile.
     * @param invoiceName The ID that uniquely identifies an invoice.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of a URL to download the pricesheet for an invoice.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DownloadUrlInner>, DownloadUrlInner> beginDownloadAsync(String billingAccountName,
        String billingProfileName, String invoiceName) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = downloadWithResponseAsync(billingAccountName, billingProfileName, invoiceName);
        return this.client.<DownloadUrlInner, DownloadUrlInner>getLroResult(mono, this.client.getHttpPipeline(),
            DownloadUrlInner.class, DownloadUrlInner.class, this.client.getContext());
    }

    /**
     * Gets a URL to download the pricesheet for an invoice. The operation is supported for billing accounts with
     * agreement type Microsoft Partner Agreement or Microsoft Customer Agreement.
     * 
     * @param billingAccountName The ID that uniquely identifies a billing account.
     * @param billingProfileName The ID that uniquely identifies a billing profile.
     * @param invoiceName The ID that uniquely identifies an invoice.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of a URL to download the pricesheet for an invoice.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DownloadUrlInner>, DownloadUrlInner> beginDownloadAsync(String billingAccountName,
        String billingProfileName, String invoiceName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = downloadWithResponseAsync(billingAccountName, billingProfileName, invoiceName, context);
        return this.client.<DownloadUrlInner, DownloadUrlInner>getLroResult(mono, this.client.getHttpPipeline(),
            DownloadUrlInner.class, DownloadUrlInner.class, context);
    }

    /**
     * Gets a URL to download the pricesheet for an invoice. The operation is supported for billing accounts with
     * agreement type Microsoft Partner Agreement or Microsoft Customer Agreement.
     * 
     * @param billingAccountName The ID that uniquely identifies a billing account.
     * @param billingProfileName The ID that uniquely identifies a billing profile.
     * @param invoiceName The ID that uniquely identifies an invoice.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a URL to download the pricesheet for an invoice.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DownloadUrlInner>, DownloadUrlInner> beginDownload(String billingAccountName,
        String billingProfileName, String invoiceName) {
        return this.beginDownloadAsync(billingAccountName, billingProfileName, invoiceName).getSyncPoller();
    }

    /**
     * Gets a URL to download the pricesheet for an invoice. The operation is supported for billing accounts with
     * agreement type Microsoft Partner Agreement or Microsoft Customer Agreement.
     * 
     * @param billingAccountName The ID that uniquely identifies a billing account.
     * @param billingProfileName The ID that uniquely identifies a billing profile.
     * @param invoiceName The ID that uniquely identifies an invoice.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a URL to download the pricesheet for an invoice.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DownloadUrlInner>, DownloadUrlInner> beginDownload(String billingAccountName,
        String billingProfileName, String invoiceName, Context context) {
        return this.beginDownloadAsync(billingAccountName, billingProfileName, invoiceName, context).getSyncPoller();
    }

    /**
     * Gets a URL to download the pricesheet for an invoice. The operation is supported for billing accounts with
     * agreement type Microsoft Partner Agreement or Microsoft Customer Agreement.
     * 
     * @param billingAccountName The ID that uniquely identifies a billing account.
     * @param billingProfileName The ID that uniquely identifies a billing profile.
     * @param invoiceName The ID that uniquely identifies an invoice.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a URL to download the pricesheet for an invoice on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DownloadUrlInner> downloadAsync(String billingAccountName, String billingProfileName,
        String invoiceName) {
        return beginDownloadAsync(billingAccountName, billingProfileName, invoiceName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Gets a URL to download the pricesheet for an invoice. The operation is supported for billing accounts with
     * agreement type Microsoft Partner Agreement or Microsoft Customer Agreement.
     * 
     * @param billingAccountName The ID that uniquely identifies a billing account.
     * @param billingProfileName The ID that uniquely identifies a billing profile.
     * @param invoiceName The ID that uniquely identifies an invoice.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a URL to download the pricesheet for an invoice on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DownloadUrlInner> downloadAsync(String billingAccountName, String billingProfileName,
        String invoiceName, Context context) {
        return beginDownloadAsync(billingAccountName, billingProfileName, invoiceName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Gets a URL to download the pricesheet for an invoice. The operation is supported for billing accounts with
     * agreement type Microsoft Partner Agreement or Microsoft Customer Agreement.
     * 
     * @param billingAccountName The ID that uniquely identifies a billing account.
     * @param billingProfileName The ID that uniquely identifies a billing profile.
     * @param invoiceName The ID that uniquely identifies an invoice.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a URL to download the pricesheet for an invoice.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DownloadUrlInner download(String billingAccountName, String billingProfileName, String invoiceName) {
        return downloadAsync(billingAccountName, billingProfileName, invoiceName).block();
    }

    /**
     * Gets a URL to download the pricesheet for an invoice. The operation is supported for billing accounts with
     * agreement type Microsoft Partner Agreement or Microsoft Customer Agreement.
     * 
     * @param billingAccountName The ID that uniquely identifies a billing account.
     * @param billingProfileName The ID that uniquely identifies a billing profile.
     * @param invoiceName The ID that uniquely identifies an invoice.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a URL to download the pricesheet for an invoice.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DownloadUrlInner download(String billingAccountName, String billingProfileName, String invoiceName,
        Context context) {
        return downloadAsync(billingAccountName, billingProfileName, invoiceName, context).block();
    }

    /**
     * Gets a URL to download the current month's pricesheet for a billing profile. The operation is supported for
     * billing accounts with agreement type Microsoft Partner Agreement or Microsoft Customer Agreement.Due to Azure
     * product growth, the Azure price sheet download experience in this preview version will be updated from a single
     * csv file to a Zip file containing multiple csv files, each with max 200k records.
     * 
     * @param billingAccountName The ID that uniquely identifies a billing account.
     * @param billingProfileName The ID that uniquely identifies a billing profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a URL to download the current month's pricesheet for a billing profile along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> downloadByBillingProfileWithResponseAsync(String billingAccountName,
        String billingProfileName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (billingAccountName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter billingAccountName is required and cannot be null."));
        }
        if (billingProfileName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter billingProfileName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.downloadByBillingProfile(this.client.getEndpoint(),
                this.client.getApiVersion(), billingAccountName, billingProfileName, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a URL to download the current month's pricesheet for a billing profile. The operation is supported for
     * billing accounts with agreement type Microsoft Partner Agreement or Microsoft Customer Agreement.Due to Azure
     * product growth, the Azure price sheet download experience in this preview version will be updated from a single
     * csv file to a Zip file containing multiple csv files, each with max 200k records.
     * 
     * @param billingAccountName The ID that uniquely identifies a billing account.
     * @param billingProfileName The ID that uniquely identifies a billing profile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a URL to download the current month's pricesheet for a billing profile along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> downloadByBillingProfileWithResponseAsync(String billingAccountName,
        String billingProfileName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (billingAccountName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter billingAccountName is required and cannot be null."));
        }
        if (billingProfileName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter billingProfileName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.downloadByBillingProfile(this.client.getEndpoint(), this.client.getApiVersion(),
            billingAccountName, billingProfileName, accept, context);
    }

    /**
     * Gets a URL to download the current month's pricesheet for a billing profile. The operation is supported for
     * billing accounts with agreement type Microsoft Partner Agreement or Microsoft Customer Agreement.Due to Azure
     * product growth, the Azure price sheet download experience in this preview version will be updated from a single
     * csv file to a Zip file containing multiple csv files, each with max 200k records.
     * 
     * @param billingAccountName The ID that uniquely identifies a billing account.
     * @param billingProfileName The ID that uniquely identifies a billing profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of a URL to download the current month's pricesheet for a billing
     * profile.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DownloadUrlInner>, DownloadUrlInner>
        beginDownloadByBillingProfileAsync(String billingAccountName, String billingProfileName) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = downloadByBillingProfileWithResponseAsync(billingAccountName, billingProfileName);
        return this.client.<DownloadUrlInner, DownloadUrlInner>getLroResult(mono, this.client.getHttpPipeline(),
            DownloadUrlInner.class, DownloadUrlInner.class, this.client.getContext());
    }

    /**
     * Gets a URL to download the current month's pricesheet for a billing profile. The operation is supported for
     * billing accounts with agreement type Microsoft Partner Agreement or Microsoft Customer Agreement.Due to Azure
     * product growth, the Azure price sheet download experience in this preview version will be updated from a single
     * csv file to a Zip file containing multiple csv files, each with max 200k records.
     * 
     * @param billingAccountName The ID that uniquely identifies a billing account.
     * @param billingProfileName The ID that uniquely identifies a billing profile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of a URL to download the current month's pricesheet for a billing
     * profile.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DownloadUrlInner>, DownloadUrlInner>
        beginDownloadByBillingProfileAsync(String billingAccountName, String billingProfileName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = downloadByBillingProfileWithResponseAsync(billingAccountName, billingProfileName, context);
        return this.client.<DownloadUrlInner, DownloadUrlInner>getLroResult(mono, this.client.getHttpPipeline(),
            DownloadUrlInner.class, DownloadUrlInner.class, context);
    }

    /**
     * Gets a URL to download the current month's pricesheet for a billing profile. The operation is supported for
     * billing accounts with agreement type Microsoft Partner Agreement or Microsoft Customer Agreement.Due to Azure
     * product growth, the Azure price sheet download experience in this preview version will be updated from a single
     * csv file to a Zip file containing multiple csv files, each with max 200k records.
     * 
     * @param billingAccountName The ID that uniquely identifies a billing account.
     * @param billingProfileName The ID that uniquely identifies a billing profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a URL to download the current month's pricesheet for a billing
     * profile.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DownloadUrlInner>, DownloadUrlInner>
        beginDownloadByBillingProfile(String billingAccountName, String billingProfileName) {
        return this.beginDownloadByBillingProfileAsync(billingAccountName, billingProfileName).getSyncPoller();
    }

    /**
     * Gets a URL to download the current month's pricesheet for a billing profile. The operation is supported for
     * billing accounts with agreement type Microsoft Partner Agreement or Microsoft Customer Agreement.Due to Azure
     * product growth, the Azure price sheet download experience in this preview version will be updated from a single
     * csv file to a Zip file containing multiple csv files, each with max 200k records.
     * 
     * @param billingAccountName The ID that uniquely identifies a billing account.
     * @param billingProfileName The ID that uniquely identifies a billing profile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a URL to download the current month's pricesheet for a billing
     * profile.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DownloadUrlInner>, DownloadUrlInner>
        beginDownloadByBillingProfile(String billingAccountName, String billingProfileName, Context context) {
        return this.beginDownloadByBillingProfileAsync(billingAccountName, billingProfileName, context).getSyncPoller();
    }

    /**
     * Gets a URL to download the current month's pricesheet for a billing profile. The operation is supported for
     * billing accounts with agreement type Microsoft Partner Agreement or Microsoft Customer Agreement.Due to Azure
     * product growth, the Azure price sheet download experience in this preview version will be updated from a single
     * csv file to a Zip file containing multiple csv files, each with max 200k records.
     * 
     * @param billingAccountName The ID that uniquely identifies a billing account.
     * @param billingProfileName The ID that uniquely identifies a billing profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a URL to download the current month's pricesheet for a billing profile on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DownloadUrlInner> downloadByBillingProfileAsync(String billingAccountName, String billingProfileName) {
        return beginDownloadByBillingProfileAsync(billingAccountName, billingProfileName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Gets a URL to download the current month's pricesheet for a billing profile. The operation is supported for
     * billing accounts with agreement type Microsoft Partner Agreement or Microsoft Customer Agreement.Due to Azure
     * product growth, the Azure price sheet download experience in this preview version will be updated from a single
     * csv file to a Zip file containing multiple csv files, each with max 200k records.
     * 
     * @param billingAccountName The ID that uniquely identifies a billing account.
     * @param billingProfileName The ID that uniquely identifies a billing profile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a URL to download the current month's pricesheet for a billing profile on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DownloadUrlInner> downloadByBillingProfileAsync(String billingAccountName, String billingProfileName,
        Context context) {
        return beginDownloadByBillingProfileAsync(billingAccountName, billingProfileName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Gets a URL to download the current month's pricesheet for a billing profile. The operation is supported for
     * billing accounts with agreement type Microsoft Partner Agreement or Microsoft Customer Agreement.Due to Azure
     * product growth, the Azure price sheet download experience in this preview version will be updated from a single
     * csv file to a Zip file containing multiple csv files, each with max 200k records.
     * 
     * @param billingAccountName The ID that uniquely identifies a billing account.
     * @param billingProfileName The ID that uniquely identifies a billing profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a URL to download the current month's pricesheet for a billing profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DownloadUrlInner downloadByBillingProfile(String billingAccountName, String billingProfileName) {
        return downloadByBillingProfileAsync(billingAccountName, billingProfileName).block();
    }

    /**
     * Gets a URL to download the current month's pricesheet for a billing profile. The operation is supported for
     * billing accounts with agreement type Microsoft Partner Agreement or Microsoft Customer Agreement.Due to Azure
     * product growth, the Azure price sheet download experience in this preview version will be updated from a single
     * csv file to a Zip file containing multiple csv files, each with max 200k records.
     * 
     * @param billingAccountName The ID that uniquely identifies a billing account.
     * @param billingProfileName The ID that uniquely identifies a billing profile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a URL to download the current month's pricesheet for a billing profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DownloadUrlInner downloadByBillingProfile(String billingAccountName, String billingProfileName,
        Context context) {
        return downloadByBillingProfileAsync(billingAccountName, billingProfileName, context).block();
    }
}
