// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.costmanagement.fluent.models.ScheduledActionInner;
import com.azure.resourcemanager.costmanagement.models.FileDestination;
import com.azure.resourcemanager.costmanagement.models.NotificationProperties;
import com.azure.resourcemanager.costmanagement.models.ScheduleProperties;
import com.azure.resourcemanager.costmanagement.models.ScheduledAction;
import com.azure.resourcemanager.costmanagement.models.ScheduledActionKind;
import com.azure.resourcemanager.costmanagement.models.ScheduledActionStatus;

public final class ScheduledActionImpl implements ScheduledAction, ScheduledAction.Definition, ScheduledAction.Update {
    private ScheduledActionInner innerObject;

    private final com.azure.resourcemanager.costmanagement.CostManagementManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String etag() {
        return this.innerModel().etag();
    }

    public ScheduledActionKind kind() {
        return this.innerModel().kind();
    }

    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    public String displayName() {
        return this.innerModel().displayName();
    }

    public FileDestination fileDestination() {
        return this.innerModel().fileDestination();
    }

    public NotificationProperties notification() {
        return this.innerModel().notification();
    }

    public String notificationEmail() {
        return this.innerModel().notificationEmail();
    }

    public ScheduleProperties schedule() {
        return this.innerModel().schedule();
    }

    public String scope() {
        return this.innerModel().scope();
    }

    public ScheduledActionStatus status() {
        return this.innerModel().status();
    }

    public String viewId() {
        return this.innerModel().viewId();
    }

    public ScheduledActionInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.costmanagement.CostManagementManager manager() {
        return this.serviceManager;
    }

    private String scope;

    private String name;

    private String createIfMatch;

    private String updateIfMatch;

    public ScheduledActionImpl withExistingScope(String scope) {
        this.scope = scope;
        return this;
    }

    public ScheduledAction create() {
        this.innerObject = serviceManager.serviceClient()
            .getScheduledActions()
            .createOrUpdateByScopeWithResponse(scope, name, this.innerModel(), createIfMatch, Context.NONE)
            .getValue();
        return this;
    }

    public ScheduledAction create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getScheduledActions()
            .createOrUpdateByScopeWithResponse(scope, name, this.innerModel(), createIfMatch, context)
            .getValue();
        return this;
    }

    ScheduledActionImpl(String name, com.azure.resourcemanager.costmanagement.CostManagementManager serviceManager) {
        this.innerObject = new ScheduledActionInner();
        this.serviceManager = serviceManager;
        this.name = name;
        this.createIfMatch = null;
    }

    public ScheduledActionImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    public ScheduledAction apply() {
        this.innerObject = serviceManager.serviceClient()
            .getScheduledActions()
            .createOrUpdateByScopeWithResponse(scope, name, this.innerModel(), updateIfMatch, Context.NONE)
            .getValue();
        return this;
    }

    public ScheduledAction apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getScheduledActions()
            .createOrUpdateByScopeWithResponse(scope, name, this.innerModel(), updateIfMatch, context)
            .getValue();
        return this;
    }

    ScheduledActionImpl(ScheduledActionInner innerObject,
        com.azure.resourcemanager.costmanagement.CostManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.scope = ResourceManagerUtils.getValueFromIdByParameterName(innerObject.id(),
            "/{scope}/providers/Microsoft.CostManagement/scheduledActions/{name}", "scope");
        this.name = ResourceManagerUtils.getValueFromIdByParameterName(innerObject.id(),
            "/{scope}/providers/Microsoft.CostManagement/scheduledActions/{name}", "name");
    }

    public ScheduledAction refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getScheduledActions()
            .getByScopeWithResponse(scope, name, Context.NONE)
            .getValue();
        return this;
    }

    public ScheduledAction refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getScheduledActions()
            .getByScopeWithResponse(scope, name, context)
            .getValue();
        return this;
    }

    public Response<Void> runByScopeWithResponse(Context context) {
        return serviceManager.scheduledActions().runByScopeWithResponse(scope, name, context);
    }

    public void runByScope() {
        serviceManager.scheduledActions().runByScope(scope, name);
    }

    public ScheduledActionImpl withKind(ScheduledActionKind kind) {
        this.innerModel().withKind(kind);
        return this;
    }

    public ScheduledActionImpl withDisplayName(String displayName) {
        this.innerModel().withDisplayName(displayName);
        return this;
    }

    public ScheduledActionImpl withFileDestination(FileDestination fileDestination) {
        this.innerModel().withFileDestination(fileDestination);
        return this;
    }

    public ScheduledActionImpl withNotification(NotificationProperties notification) {
        this.innerModel().withNotification(notification);
        return this;
    }

    public ScheduledActionImpl withNotificationEmail(String notificationEmail) {
        this.innerModel().withNotificationEmail(notificationEmail);
        return this;
    }

    public ScheduledActionImpl withSchedule(ScheduleProperties schedule) {
        this.innerModel().withSchedule(schedule);
        return this;
    }

    public ScheduledActionImpl withScope(String scope) {
        this.innerModel().withScope(scope);
        return this;
    }

    public ScheduledActionImpl withStatus(ScheduledActionStatus status) {
        this.innerModel().withStatus(status);
        return this;
    }

    public ScheduledActionImpl withViewId(String viewId) {
        this.innerModel().withViewId(viewId);
        return this;
    }

    public ScheduledActionImpl withIfMatch(String ifMatch) {
        if (isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        } else {
            this.updateIfMatch = ifMatch;
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
