// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * defines the type of alert.
 */
@Fluent
public final class AlertPropertiesDefinition implements JsonSerializable<AlertPropertiesDefinition> {
    /*
     * type of alert
     */
    private AlertType type;

    /*
     * Alert category
     */
    private AlertCategory category;

    /*
     * Criteria that triggered alert
     */
    private AlertCriteria criteria;

    /**
     * Creates an instance of AlertPropertiesDefinition class.
     */
    public AlertPropertiesDefinition() {
    }

    /**
     * Get the type property: type of alert.
     * 
     * @return the type value.
     */
    public AlertType type() {
        return this.type;
    }

    /**
     * Set the type property: type of alert.
     * 
     * @param type the type value to set.
     * @return the AlertPropertiesDefinition object itself.
     */
    public AlertPropertiesDefinition withType(AlertType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the category property: Alert category.
     * 
     * @return the category value.
     */
    public AlertCategory category() {
        return this.category;
    }

    /**
     * Set the category property: Alert category.
     * 
     * @param category the category value to set.
     * @return the AlertPropertiesDefinition object itself.
     */
    public AlertPropertiesDefinition withCategory(AlertCategory category) {
        this.category = category;
        return this;
    }

    /**
     * Get the criteria property: Criteria that triggered alert.
     * 
     * @return the criteria value.
     */
    public AlertCriteria criteria() {
        return this.criteria;
    }

    /**
     * Set the criteria property: Criteria that triggered alert.
     * 
     * @param criteria the criteria value to set.
     * @return the AlertPropertiesDefinition object itself.
     */
    public AlertPropertiesDefinition withCriteria(AlertCriteria criteria) {
        this.criteria = criteria;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("category", this.category == null ? null : this.category.toString());
        jsonWriter.writeStringField("criteria", this.criteria == null ? null : this.criteria.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AlertPropertiesDefinition from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AlertPropertiesDefinition if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AlertPropertiesDefinition.
     */
    public static AlertPropertiesDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AlertPropertiesDefinition deserializedAlertPropertiesDefinition = new AlertPropertiesDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedAlertPropertiesDefinition.type = AlertType.fromString(reader.getString());
                } else if ("category".equals(fieldName)) {
                    deserializedAlertPropertiesDefinition.category = AlertCategory.fromString(reader.getString());
                } else if ("criteria".equals(fieldName)) {
                    deserializedAlertPropertiesDefinition.criteria = AlertCriteria.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAlertPropertiesDefinition;
        });
    }
}
