// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;

/**
 * Alert details.
 */
@Fluent
public final class AlertPropertiesDetails implements JsonSerializable<AlertPropertiesDetails> {
    /*
     * Type of timegrain cadence
     */
    private AlertTimeGrainType timeGrainType;

    /*
     * datetime of periodStartDate
     */
    private String periodStartDate;

    /*
     * notificationId that triggered this alert
     */
    private String triggeredBy;

    /*
     * array of resourceGroups to filter by
     */
    private List<Object> resourceGroupFilter;

    /*
     * array of resources to filter by
     */
    private List<Object> resourceFilter;

    /*
     * array of meters to filter by
     */
    private List<Object> meterFilter;

    /*
     * tags to filter by
     */
    private Object tagFilter;

    /*
     * notification threshold percentage as a decimal which activated this alert
     */
    private BigDecimal threshold;

    /*
     * operator used to compare currentSpend with amount
     */
    private AlertOperator operator;

    /*
     * budget threshold amount
     */
    private BigDecimal amount;

    /*
     * unit of currency being used
     */
    private String unit;

    /*
     * current spend
     */
    private BigDecimal currentSpend;

    /*
     * list of emails to contact
     */
    private List<String> contactEmails;

    /*
     * list of action groups to broadcast to
     */
    private List<String> contactGroups;

    /*
     * list of contact roles
     */
    private List<String> contactRoles;

    /*
     * overriding alert
     */
    private String overridingAlert;

    /*
     * department name
     */
    private String departmentName;

    /*
     * company name
     */
    private String companyName;

    /*
     * enrollment number
     */
    private String enrollmentNumber;

    /*
     * datetime of enrollmentStartDate
     */
    private String enrollmentStartDate;

    /*
     * datetime of enrollmentEndDate
     */
    private String enrollmentEndDate;

    /*
     * invoicing threshold
     */
    private BigDecimal invoicingThreshold;

    /**
     * Creates an instance of AlertPropertiesDetails class.
     */
    public AlertPropertiesDetails() {
    }

    /**
     * Get the timeGrainType property: Type of timegrain cadence.
     * 
     * @return the timeGrainType value.
     */
    public AlertTimeGrainType timeGrainType() {
        return this.timeGrainType;
    }

    /**
     * Set the timeGrainType property: Type of timegrain cadence.
     * 
     * @param timeGrainType the timeGrainType value to set.
     * @return the AlertPropertiesDetails object itself.
     */
    public AlertPropertiesDetails withTimeGrainType(AlertTimeGrainType timeGrainType) {
        this.timeGrainType = timeGrainType;
        return this;
    }

    /**
     * Get the periodStartDate property: datetime of periodStartDate.
     * 
     * @return the periodStartDate value.
     */
    public String periodStartDate() {
        return this.periodStartDate;
    }

    /**
     * Set the periodStartDate property: datetime of periodStartDate.
     * 
     * @param periodStartDate the periodStartDate value to set.
     * @return the AlertPropertiesDetails object itself.
     */
    public AlertPropertiesDetails withPeriodStartDate(String periodStartDate) {
        this.periodStartDate = periodStartDate;
        return this;
    }

    /**
     * Get the triggeredBy property: notificationId that triggered this alert.
     * 
     * @return the triggeredBy value.
     */
    public String triggeredBy() {
        return this.triggeredBy;
    }

    /**
     * Set the triggeredBy property: notificationId that triggered this alert.
     * 
     * @param triggeredBy the triggeredBy value to set.
     * @return the AlertPropertiesDetails object itself.
     */
    public AlertPropertiesDetails withTriggeredBy(String triggeredBy) {
        this.triggeredBy = triggeredBy;
        return this;
    }

    /**
     * Get the resourceGroupFilter property: array of resourceGroups to filter by.
     * 
     * @return the resourceGroupFilter value.
     */
    public List<Object> resourceGroupFilter() {
        return this.resourceGroupFilter;
    }

    /**
     * Set the resourceGroupFilter property: array of resourceGroups to filter by.
     * 
     * @param resourceGroupFilter the resourceGroupFilter value to set.
     * @return the AlertPropertiesDetails object itself.
     */
    public AlertPropertiesDetails withResourceGroupFilter(List<Object> resourceGroupFilter) {
        this.resourceGroupFilter = resourceGroupFilter;
        return this;
    }

    /**
     * Get the resourceFilter property: array of resources to filter by.
     * 
     * @return the resourceFilter value.
     */
    public List<Object> resourceFilter() {
        return this.resourceFilter;
    }

    /**
     * Set the resourceFilter property: array of resources to filter by.
     * 
     * @param resourceFilter the resourceFilter value to set.
     * @return the AlertPropertiesDetails object itself.
     */
    public AlertPropertiesDetails withResourceFilter(List<Object> resourceFilter) {
        this.resourceFilter = resourceFilter;
        return this;
    }

    /**
     * Get the meterFilter property: array of meters to filter by.
     * 
     * @return the meterFilter value.
     */
    public List<Object> meterFilter() {
        return this.meterFilter;
    }

    /**
     * Set the meterFilter property: array of meters to filter by.
     * 
     * @param meterFilter the meterFilter value to set.
     * @return the AlertPropertiesDetails object itself.
     */
    public AlertPropertiesDetails withMeterFilter(List<Object> meterFilter) {
        this.meterFilter = meterFilter;
        return this;
    }

    /**
     * Get the tagFilter property: tags to filter by.
     * 
     * @return the tagFilter value.
     */
    public Object tagFilter() {
        return this.tagFilter;
    }

    /**
     * Set the tagFilter property: tags to filter by.
     * 
     * @param tagFilter the tagFilter value to set.
     * @return the AlertPropertiesDetails object itself.
     */
    public AlertPropertiesDetails withTagFilter(Object tagFilter) {
        this.tagFilter = tagFilter;
        return this;
    }

    /**
     * Get the threshold property: notification threshold percentage as a decimal which activated this alert.
     * 
     * @return the threshold value.
     */
    public BigDecimal threshold() {
        return this.threshold;
    }

    /**
     * Set the threshold property: notification threshold percentage as a decimal which activated this alert.
     * 
     * @param threshold the threshold value to set.
     * @return the AlertPropertiesDetails object itself.
     */
    public AlertPropertiesDetails withThreshold(BigDecimal threshold) {
        this.threshold = threshold;
        return this;
    }

    /**
     * Get the operator property: operator used to compare currentSpend with amount.
     * 
     * @return the operator value.
     */
    public AlertOperator operator() {
        return this.operator;
    }

    /**
     * Set the operator property: operator used to compare currentSpend with amount.
     * 
     * @param operator the operator value to set.
     * @return the AlertPropertiesDetails object itself.
     */
    public AlertPropertiesDetails withOperator(AlertOperator operator) {
        this.operator = operator;
        return this;
    }

    /**
     * Get the amount property: budget threshold amount.
     * 
     * @return the amount value.
     */
    public BigDecimal amount() {
        return this.amount;
    }

    /**
     * Set the amount property: budget threshold amount.
     * 
     * @param amount the amount value to set.
     * @return the AlertPropertiesDetails object itself.
     */
    public AlertPropertiesDetails withAmount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    /**
     * Get the unit property: unit of currency being used.
     * 
     * @return the unit value.
     */
    public String unit() {
        return this.unit;
    }

    /**
     * Set the unit property: unit of currency being used.
     * 
     * @param unit the unit value to set.
     * @return the AlertPropertiesDetails object itself.
     */
    public AlertPropertiesDetails withUnit(String unit) {
        this.unit = unit;
        return this;
    }

    /**
     * Get the currentSpend property: current spend.
     * 
     * @return the currentSpend value.
     */
    public BigDecimal currentSpend() {
        return this.currentSpend;
    }

    /**
     * Set the currentSpend property: current spend.
     * 
     * @param currentSpend the currentSpend value to set.
     * @return the AlertPropertiesDetails object itself.
     */
    public AlertPropertiesDetails withCurrentSpend(BigDecimal currentSpend) {
        this.currentSpend = currentSpend;
        return this;
    }

    /**
     * Get the contactEmails property: list of emails to contact.
     * 
     * @return the contactEmails value.
     */
    public List<String> contactEmails() {
        return this.contactEmails;
    }

    /**
     * Set the contactEmails property: list of emails to contact.
     * 
     * @param contactEmails the contactEmails value to set.
     * @return the AlertPropertiesDetails object itself.
     */
    public AlertPropertiesDetails withContactEmails(List<String> contactEmails) {
        this.contactEmails = contactEmails;
        return this;
    }

    /**
     * Get the contactGroups property: list of action groups to broadcast to.
     * 
     * @return the contactGroups value.
     */
    public List<String> contactGroups() {
        return this.contactGroups;
    }

    /**
     * Set the contactGroups property: list of action groups to broadcast to.
     * 
     * @param contactGroups the contactGroups value to set.
     * @return the AlertPropertiesDetails object itself.
     */
    public AlertPropertiesDetails withContactGroups(List<String> contactGroups) {
        this.contactGroups = contactGroups;
        return this;
    }

    /**
     * Get the contactRoles property: list of contact roles.
     * 
     * @return the contactRoles value.
     */
    public List<String> contactRoles() {
        return this.contactRoles;
    }

    /**
     * Set the contactRoles property: list of contact roles.
     * 
     * @param contactRoles the contactRoles value to set.
     * @return the AlertPropertiesDetails object itself.
     */
    public AlertPropertiesDetails withContactRoles(List<String> contactRoles) {
        this.contactRoles = contactRoles;
        return this;
    }

    /**
     * Get the overridingAlert property: overriding alert.
     * 
     * @return the overridingAlert value.
     */
    public String overridingAlert() {
        return this.overridingAlert;
    }

    /**
     * Set the overridingAlert property: overriding alert.
     * 
     * @param overridingAlert the overridingAlert value to set.
     * @return the AlertPropertiesDetails object itself.
     */
    public AlertPropertiesDetails withOverridingAlert(String overridingAlert) {
        this.overridingAlert = overridingAlert;
        return this;
    }

    /**
     * Get the departmentName property: department name.
     * 
     * @return the departmentName value.
     */
    public String departmentName() {
        return this.departmentName;
    }

    /**
     * Set the departmentName property: department name.
     * 
     * @param departmentName the departmentName value to set.
     * @return the AlertPropertiesDetails object itself.
     */
    public AlertPropertiesDetails withDepartmentName(String departmentName) {
        this.departmentName = departmentName;
        return this;
    }

    /**
     * Get the companyName property: company name.
     * 
     * @return the companyName value.
     */
    public String companyName() {
        return this.companyName;
    }

    /**
     * Set the companyName property: company name.
     * 
     * @param companyName the companyName value to set.
     * @return the AlertPropertiesDetails object itself.
     */
    public AlertPropertiesDetails withCompanyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    /**
     * Get the enrollmentNumber property: enrollment number.
     * 
     * @return the enrollmentNumber value.
     */
    public String enrollmentNumber() {
        return this.enrollmentNumber;
    }

    /**
     * Set the enrollmentNumber property: enrollment number.
     * 
     * @param enrollmentNumber the enrollmentNumber value to set.
     * @return the AlertPropertiesDetails object itself.
     */
    public AlertPropertiesDetails withEnrollmentNumber(String enrollmentNumber) {
        this.enrollmentNumber = enrollmentNumber;
        return this;
    }

    /**
     * Get the enrollmentStartDate property: datetime of enrollmentStartDate.
     * 
     * @return the enrollmentStartDate value.
     */
    public String enrollmentStartDate() {
        return this.enrollmentStartDate;
    }

    /**
     * Set the enrollmentStartDate property: datetime of enrollmentStartDate.
     * 
     * @param enrollmentStartDate the enrollmentStartDate value to set.
     * @return the AlertPropertiesDetails object itself.
     */
    public AlertPropertiesDetails withEnrollmentStartDate(String enrollmentStartDate) {
        this.enrollmentStartDate = enrollmentStartDate;
        return this;
    }

    /**
     * Get the enrollmentEndDate property: datetime of enrollmentEndDate.
     * 
     * @return the enrollmentEndDate value.
     */
    public String enrollmentEndDate() {
        return this.enrollmentEndDate;
    }

    /**
     * Set the enrollmentEndDate property: datetime of enrollmentEndDate.
     * 
     * @param enrollmentEndDate the enrollmentEndDate value to set.
     * @return the AlertPropertiesDetails object itself.
     */
    public AlertPropertiesDetails withEnrollmentEndDate(String enrollmentEndDate) {
        this.enrollmentEndDate = enrollmentEndDate;
        return this;
    }

    /**
     * Get the invoicingThreshold property: invoicing threshold.
     * 
     * @return the invoicingThreshold value.
     */
    public BigDecimal invoicingThreshold() {
        return this.invoicingThreshold;
    }

    /**
     * Set the invoicingThreshold property: invoicing threshold.
     * 
     * @param invoicingThreshold the invoicingThreshold value to set.
     * @return the AlertPropertiesDetails object itself.
     */
    public AlertPropertiesDetails withInvoicingThreshold(BigDecimal invoicingThreshold) {
        this.invoicingThreshold = invoicingThreshold;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timeGrainType", this.timeGrainType == null ? null : this.timeGrainType.toString());
        jsonWriter.writeStringField("periodStartDate", this.periodStartDate);
        jsonWriter.writeStringField("triggeredBy", this.triggeredBy);
        jsonWriter.writeArrayField("resourceGroupFilter", this.resourceGroupFilter,
            (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeArrayField("resourceFilter", this.resourceFilter,
            (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeArrayField("meterFilter", this.meterFilter, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeUntypedField("tagFilter", this.tagFilter);
        jsonWriter.writeNumberField("threshold", this.threshold);
        jsonWriter.writeStringField("operator", this.operator == null ? null : this.operator.toString());
        jsonWriter.writeNumberField("amount", this.amount);
        jsonWriter.writeStringField("unit", this.unit);
        jsonWriter.writeNumberField("currentSpend", this.currentSpend);
        jsonWriter.writeArrayField("contactEmails", this.contactEmails,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("contactGroups", this.contactGroups,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("contactRoles", this.contactRoles, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("overridingAlert", this.overridingAlert);
        jsonWriter.writeStringField("departmentName", this.departmentName);
        jsonWriter.writeStringField("companyName", this.companyName);
        jsonWriter.writeStringField("enrollmentNumber", this.enrollmentNumber);
        jsonWriter.writeStringField("enrollmentStartDate", this.enrollmentStartDate);
        jsonWriter.writeStringField("enrollmentEndDate", this.enrollmentEndDate);
        jsonWriter.writeNumberField("invoicingThreshold", this.invoicingThreshold);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AlertPropertiesDetails from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AlertPropertiesDetails if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AlertPropertiesDetails.
     */
    public static AlertPropertiesDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AlertPropertiesDetails deserializedAlertPropertiesDetails = new AlertPropertiesDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("timeGrainType".equals(fieldName)) {
                    deserializedAlertPropertiesDetails.timeGrainType
                        = AlertTimeGrainType.fromString(reader.getString());
                } else if ("periodStartDate".equals(fieldName)) {
                    deserializedAlertPropertiesDetails.periodStartDate = reader.getString();
                } else if ("triggeredBy".equals(fieldName)) {
                    deserializedAlertPropertiesDetails.triggeredBy = reader.getString();
                } else if ("resourceGroupFilter".equals(fieldName)) {
                    List<Object> resourceGroupFilter = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAlertPropertiesDetails.resourceGroupFilter = resourceGroupFilter;
                } else if ("resourceFilter".equals(fieldName)) {
                    List<Object> resourceFilter = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAlertPropertiesDetails.resourceFilter = resourceFilter;
                } else if ("meterFilter".equals(fieldName)) {
                    List<Object> meterFilter = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAlertPropertiesDetails.meterFilter = meterFilter;
                } else if ("tagFilter".equals(fieldName)) {
                    deserializedAlertPropertiesDetails.tagFilter = reader.readUntyped();
                } else if ("threshold".equals(fieldName)) {
                    deserializedAlertPropertiesDetails.threshold
                        = reader.getNullable(nonNullReader -> new BigDecimal(nonNullReader.getString()));
                } else if ("operator".equals(fieldName)) {
                    deserializedAlertPropertiesDetails.operator = AlertOperator.fromString(reader.getString());
                } else if ("amount".equals(fieldName)) {
                    deserializedAlertPropertiesDetails.amount
                        = reader.getNullable(nonNullReader -> new BigDecimal(nonNullReader.getString()));
                } else if ("unit".equals(fieldName)) {
                    deserializedAlertPropertiesDetails.unit = reader.getString();
                } else if ("currentSpend".equals(fieldName)) {
                    deserializedAlertPropertiesDetails.currentSpend
                        = reader.getNullable(nonNullReader -> new BigDecimal(nonNullReader.getString()));
                } else if ("contactEmails".equals(fieldName)) {
                    List<String> contactEmails = reader.readArray(reader1 -> reader1.getString());
                    deserializedAlertPropertiesDetails.contactEmails = contactEmails;
                } else if ("contactGroups".equals(fieldName)) {
                    List<String> contactGroups = reader.readArray(reader1 -> reader1.getString());
                    deserializedAlertPropertiesDetails.contactGroups = contactGroups;
                } else if ("contactRoles".equals(fieldName)) {
                    List<String> contactRoles = reader.readArray(reader1 -> reader1.getString());
                    deserializedAlertPropertiesDetails.contactRoles = contactRoles;
                } else if ("overridingAlert".equals(fieldName)) {
                    deserializedAlertPropertiesDetails.overridingAlert = reader.getString();
                } else if ("departmentName".equals(fieldName)) {
                    deserializedAlertPropertiesDetails.departmentName = reader.getString();
                } else if ("companyName".equals(fieldName)) {
                    deserializedAlertPropertiesDetails.companyName = reader.getString();
                } else if ("enrollmentNumber".equals(fieldName)) {
                    deserializedAlertPropertiesDetails.enrollmentNumber = reader.getString();
                } else if ("enrollmentStartDate".equals(fieldName)) {
                    deserializedAlertPropertiesDetails.enrollmentStartDate = reader.getString();
                } else if ("enrollmentEndDate".equals(fieldName)) {
                    deserializedAlertPropertiesDetails.enrollmentEndDate = reader.getString();
                } else if ("invoicingThreshold".equals(fieldName)) {
                    deserializedAlertPropertiesDetails.invoicingThreshold
                        = reader.getNullable(nonNullReader -> new BigDecimal(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAlertPropertiesDetails;
        });
    }
}
